/*
 * Decompiled with CFR 0.152.
 */
package gratum.pgp;

import gratum.pgp.PgpContext;
import gratum.pgp.PgpObjectCallback;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.bouncycastle.openpgp.PGPCompressedData;
import org.bouncycastle.openpgp.PGPEncryptedDataList;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPLiteralData;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.openpgp.PGPOnePassSignatureList;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKeyEncryptedData;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSignatureList;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.jcajce.JcaKeyFingerprintCalculator;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPDigestCalculatorProviderBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcePBESecretKeyDecryptorBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcePublicKeyDataDecryptorFactoryBuilder;

public class PgpObjectProcessor {
    private PgpContext context;
    Map<Class<?>, PgpObjectCallback> callbacks = new HashMap();

    public PgpObjectProcessor(PgpContext context, char[] passphrase) {
        this.context = context;
        this.onEncryptedData(data -> {
            Iterator it = data.getEncryptedDataObjects();
            PGPPublicKeyEncryptedData publicKeyEncryptedData = null;
            boolean processed = true;
            while (processed && it.hasNext()) {
                publicKeyEncryptedData = (PGPPublicKeyEncryptedData)it.next();
                PGPSecretKey pgpSecKey = context.getSecretKey(publicKeyEncryptedData.getKeyID());
                if (pgpSecKey != null) {
                    PGPPrivateKey secretKey = pgpSecKey.extractPrivateKey(new JcePBESecretKeyDecryptorBuilder(new JcaPGPDigestCalculatorProviderBuilder().setProvider("BC").build()).setProvider("BC").build(passphrase));
                    InputStream clear = publicKeyEncryptedData.getDataStream(new JcePublicKeyDataDecryptorFactoryBuilder().setProvider("BC").build(secretKey));
                    PGPObjectFactory plainFact = new PGPObjectFactory(clear, (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator());
                    processed = this.process(plainFact);
                    if (!processed || !publicKeyEncryptedData.isIntegrityProtected() || publicKeyEncryptedData.verify()) continue;
                    throw new PGPException("Message failed integrity check against key: " + Long.toHexString(publicKeyEncryptedData.getKeyID()));
                }
                throw new PGPException("Could not find a secret key " + Long.toHexString(publicKeyEncryptedData.getKeyID()) + " for encrypted data.");
            }
            return processed;
        });
        this.onCompressed(compressedData -> {
            BufferedInputStream compressedStream = new BufferedInputStream(compressedData.getDataStream());
            PGPObjectFactory pgpFact = new PGPObjectFactory((InputStream)compressedStream, (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator());
            return this.process(pgpFact);
        });
    }

    public boolean process(InputStream encryptedStream) throws IOException, PGPException {
        InputStream in = PGPUtil.getDecoderStream((InputStream)encryptedStream);
        PGPObjectFactory pgpObjFactory = new PGPObjectFactory(in, (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator());
        return this.process(pgpObjFactory);
    }

    protected boolean process(PGPObjectFactory factory) throws PGPException, IOException {
        Object pgpObj;
        boolean processed = true;
        while ((pgpObj = factory.nextObject()) != null) {
            if (!this.callbacks.containsKey(pgpObj.getClass()) || !(processed = this.callbacks.get(pgpObj.getClass()).handle(pgpObj))) continue;
        }
        return processed;
    }

    public PgpObjectProcessor onData(PgpObjectCallback<PGPLiteralData> callback) {
        this.callbacks.put(PGPLiteralData.class, callback);
        return this;
    }

    public PgpObjectProcessor onCompressed(PgpObjectCallback<PGPCompressedData> callback) {
        this.callbacks.put(PGPCompressedData.class, callback);
        return this;
    }

    public PgpObjectProcessor onSignature(PgpObjectCallback<PGPSignatureList> callback) {
        this.callbacks.put(PGPSignatureList.class, callback);
        return this;
    }

    public PgpObjectProcessor onOnePassSignature(PgpObjectCallback<PGPOnePassSignatureList> callback) {
        this.callbacks.put(PGPOnePassSignatureList.class, callback);
        return this;
    }

    public PgpObjectProcessor onEncryptedData(PgpObjectCallback<PGPEncryptedDataList> callback) {
        this.callbacks.put(PGPEncryptedDataList.class, callback);
        return this;
    }

    public PgpObjectProcessor onSecretKeyRing(PgpObjectCallback<PGPSecretKeyRing> callback) {
        this.callbacks.put(PGPSecretKeyRing.class, callback);
        return this;
    }

    public PgpObjectProcessor onPublicKeyRing(PgpObjectCallback<PGPPublicKeyRing> callback) {
        this.callbacks.put(PGPPublicKeyRing.class, callback);
        return this;
    }
}

