/*
 * Decompiled with CFR 0.152.
 */
package com.github.cjnygard.mvn.rest;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.commons.io.IOUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.FileSet;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.settings.Settings;
import org.codehaus.plexus.components.io.filemappers.FileMapper;
import org.codehaus.plexus.util.FileUtils;
import org.sonatype.plexus.build.incremental.BuildContext;

@Mojo(name="rest-request")
public class Plugin
extends AbstractMojo {
    @Parameter(defaultValue="${session}", readonly=true)
    private MavenSession session;
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @Parameter(defaultValue="${mojoExecution}", readonly=true)
    private MojoExecution mojo;
    @Parameter(defaultValue="${plugin}", readonly=true)
    private PluginDescriptor plugin;
    @Parameter(defaultValue="${settings}", readonly=true)
    private Settings settings;
    @Component
    private MavenProjectHelper projectHelper;
    @Parameter(defaultValue="${project.basedir}", readonly=true)
    private File basedir;
    @Parameter(defaultValue="${project.build.directory}", readonly=true)
    private File target;
    @Parameter(property="endpoint")
    private URI endpoint;
    @Parameter(property="resource")
    private String resource;
    @Parameter(property="method")
    private String method = "POST";
    @Parameter(property="filesets")
    private List<FileSet> filesets = new ArrayList<FileSet>();
    @Parameter(property="fileset")
    private FileSet fileset;
    @Parameter(defaultValue="${project.build.directory}/rest", property="outputDir")
    private File outputDir;
    @Parameter(defaultValue="rest.file", property="outputFilename")
    private File outputFilename;
    @Parameter(property="queryParams")
    private Map<String, String> queryParams;
    @Parameter(property="headers")
    private Map<String, String> headers;
    @Parameter(property="filemapper")
    private FileMapper fileMapper;
    @Parameter(property="filemappers")
    private List<FileMapper> fileMappers;
    @Parameter
    private MediaType requestType = MediaType.TEXT_PLAIN_TYPE;
    @Parameter
    private MediaType responseType = MediaType.APPLICATION_OCTET_STREAM_TYPE;
    @Component(role=BuildContext.class)
    private BuildContext buildContext;
    @Parameter(defaultValue="${mojoExecution}", readonly=true)
    private MojoExecution execution;

    private <T> T getInjectedObject(T objectOrNull, String objectName) {
        if (objectOrNull == null) {
            this.getLog().error((CharSequence)String.format("Found null [%s]: Maven @Component injection was not done properly.", objectName));
        }
        return objectOrNull;
    }

    protected final BuildContext getBuildContext() {
        return this.getInjectedObject(this.buildContext, "buildContext");
    }

    protected final MavenProject getProject() {
        return this.getInjectedObject(this.project, "project");
    }

    public MojoExecution getExecution() {
        return this.getInjectedObject(this.execution, "execution");
    }

    protected List<File> getFilesToProcess() throws MojoExecutionException {
        ArrayList<File> files = new ArrayList<File>();
        if (null != this.getFileset()) {
            if (null == this.getFilesets()) {
                this.filesets = new ArrayList<FileSet>();
            }
            this.getFilesets().add(this.getFileset());
        }
        if (null != this.getFilesets()) {
            for (FileSet fs : this.getFilesets()) {
                if (null == fs || null == fs.getDirectory()) continue;
                FileSetTransformer fileMgr = new FileSetTransformer(fs);
                files.addAll(fileMgr.toFileList());
            }
        }
        return files;
    }

    protected String readStream(InputStream in) throws MojoExecutionException {
        byte[] buf = new byte[1024];
        int sz = 0;
        StringBuilder result = new StringBuilder();
        try {
            while (sz != -1) {
                sz = in.read(buf);
                result.append(buf);
            }
            return result.toString();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to read result stream", (Exception)e);
        }
    }

    protected <T> String wrap(String prefix, String suffix, List<T> tokens) {
        StringBuilder str = new StringBuilder();
        for (T s : tokens) {
            str.append(prefix);
            str.append(s.toString());
            str.append(suffix);
        }
        return str.toString();
    }

    protected <T> String join(String delim, List<T> tokens) {
        StringBuilder str = new StringBuilder();
        for (T s : tokens) {
            str.append(s.toString());
            str.append(delim);
        }
        return str.toString().substring(0, -delim.length());
    }

    protected void pipeToFile(InputStream stream, File outputFile) throws IOException {
        int bytesRead;
        this.getLog().info((CharSequence)String.format("Writing file [%s]", outputFile.getCanonicalPath()));
        FileOutputStream outStream = new FileOutputStream(outputFile);
        byte[] buffer = new byte[8192];
        while ((bytesRead = stream.read(buffer)) != -1) {
            ((OutputStream)outStream).write(buffer, 0, bytesRead);
        }
        IOUtils.closeQuietly((InputStream)stream);
        IOUtils.closeQuietly((OutputStream)outStream);
    }

    protected String remapFilename(String filename) {
        String remappedName = filename;
        if (null != this.getFileMapper()) {
            return this.getFileMapper().getMappedFileName(filename);
        }
        if (null != this.getFileMappers()) {
            for (FileMapper fm : this.getFileMappers()) {
                if (null == fm) continue;
                remappedName = fm.getMappedFileName(remappedName);
            }
        }
        return remappedName;
    }

    protected boolean validateOutputDir() throws MojoExecutionException {
        try {
            if (null == this.getOutputDir()) {
                this.outputDir = new File(this.getProject().getBasedir(), "rest");
            }
            if (!this.outputDir.isDirectory()) {
                if (this.outputDir.isFile()) {
                    this.getLog().error((CharSequence)String.format("Error: [%s] is not a directory", this.outputDir.getCanonicalPath()));
                } else if (!this.outputDir.mkdirs()) {
                    this.getLog().error((CharSequence)String.format("Error: Unable to create path[%s]", this.outputDir.getCanonicalPath()));
                }
            }
        }
        catch (IOException ex) {
            this.getLog().error((CharSequence)String.format("IOException: [%s]", ex.toString()));
            throw new MojoExecutionException(String.format("Unable to create destination dir [%s]: [%s]", this.outputDir.toString(), ex.toString()));
        }
        return true;
    }

    public void execute() throws MojoExecutionException {
        this.validateOutputDir();
        this.getLog().info((CharSequence)String.format("Output dir [%s]", this.getOutputDir().toString()));
        Client client = ClientBuilder.newClient();
        WebTarget baseTarget = client.target(this.getEndpoint());
        if (null != this.getResource()) {
            this.getLog().debug((CharSequence)String.format("Setting resource [%s]", this.getResource()));
            baseTarget = baseTarget.path(this.getResource());
        }
        if (null != this.getQueryParams()) {
            for (String string : this.getQueryParams().keySet()) {
                String param = this.getQueryParams().get(string);
                baseTarget = baseTarget.queryParam(string, new Object[]{param});
                this.getLog().debug((CharSequence)String.format("Param [%s:%s]", string, param));
            }
        }
        Invocation.Builder builder = baseTarget.request(new MediaType[]{this.getRequestType()}).accept(new MediaType[]{this.getResponseType()});
        if (null != this.getHeaders()) {
            for (String k : this.getHeaders().keySet()) {
                String hdr = this.getHeaders().get(k);
                builder = builder.header(k, (Object)hdr);
                this.getLog().debug((CharSequence)String.format("Header [%s:%s]", k, hdr));
            }
        }
        this.getLog().info((CharSequence)String.format("Endpoint: [%s %s]", this.getMethod(), baseTarget.getUri()));
        ArrayList<ErrorInfo> arrayList = new ArrayList<ErrorInfo>();
        List<File> files = this.getFilesToProcess();
        if (null == files || files.size() <= 0) {
            if (!this.getMethod().equalsIgnoreCase("GET")) {
                this.getLog().info((CharSequence)"No files to process");
                return;
            }
            this.getLog().debug((CharSequence)"GET request");
            ErrorInfo result = this.processResponse(builder.method(this.getMethod()), this.remapFilename(this.getOutputFilename().getName()));
            if (result != null) {
                arrayList.add(result);
            }
        }
        for (File f : files) {
            this.getLog().debug((CharSequence)String.format("Submitting file [%s]", f.toString()));
            ErrorInfo result = this.processResponse(builder.method(this.getMethod(), Entity.entity((Object)f, (MediaType)this.getRequestType())), this.remapFilename(f.getName()));
            if (result == null) continue;
            arrayList.add(new FileErrorInfo(f.getPath(), result));
        }
        if (arrayList.size() > 0) {
            throw new MojoExecutionException(String.format("Unable to process files:\n%s", this.wrap("  ", "\n", arrayList)));
        }
    }

    private ErrorInfo processResponse(Response response, String outputFilename) {
        if (response.getStatusInfo().getFamily() == Response.Status.Family.SUCCESSFUL) {
            this.getLog().debug((CharSequence)String.format("Status: [%d]", response.getStatus()));
            InputStream in = (InputStream)response.readEntity(InputStream.class);
            try {
                File of = new File(this.getOutputDir(), outputFilename);
                this.pipeToFile(in, of);
            }
            catch (IOException ex) {
                this.getLog().debug((CharSequence)String.format("IOException: [%s]", ex.toString()));
                return new ErrorInfo(String.format("IOException: [%s]", ex.getMessage()));
            }
        } else {
            this.getLog().warn((CharSequence)String.format("Error code: [%d]", response.getStatus()));
            this.getLog().debug((CharSequence)response.getEntity().toString());
            return new ErrorInfo(response.getStatus(), response.getEntity().toString());
        }
        return null;
    }

    public URI getEndpoint() {
        return this.endpoint;
    }

    public String getResource() {
        return this.resource;
    }

    public List<FileSet> getFilesets() {
        return this.filesets;
    }

    public FileSet getFileset() {
        return this.fileset;
    }

    public File getOutputDir() {
        return this.outputDir;
    }

    public File getOutputFilename() {
        return this.outputFilename;
    }

    public MediaType getRequestType() {
        return this.requestType;
    }

    public MediaType getResponseType() {
        return this.responseType;
    }

    public Map<String, String> getQueryParams() {
        return this.queryParams;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public FileMapper getFileMapper() {
        return this.fileMapper;
    }

    public List<FileMapper> getFileMappers() {
        return this.fileMappers;
    }

    public File getBasedir() {
        return this.basedir;
    }

    public File getTarget() {
        return this.target;
    }

    public MavenProjectHelper getProjectHelper() {
        return this.projectHelper;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public final class FileErrorInfo
    extends ErrorInfo {
        private final String filename;

        public FileErrorInfo(String fn, ErrorInfo error) {
            super(error.errorCode, error.message);
            this.filename = fn;
        }

        public FileErrorInfo(String fn, int code, String msg) {
            super(code, msg);
            this.filename = fn;
        }

        public FileErrorInfo(String fn, String msg) {
            super(msg);
            this.filename = fn;
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.filename).append(super.toString());
            return sb.toString();
        }
    }

    public class ErrorInfo {
        private final int errorCode;
        private final String message;

        public ErrorInfo(int code, String msg) {
            this.errorCode = code;
            this.message = msg;
        }

        public ErrorInfo(String msg) {
            this.errorCode = -1;
            this.message = msg;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(" [").append(this.errorCode).append(":").append(this.message).append("]");
            return sb.toString();
        }
    }

    public final class FileSetTransformer {
        private final FileSet fileSet;

        private FileSetTransformer(FileSet fileSet) {
            this.fileSet = fileSet;
        }

        public List<File> toFileList() throws MojoExecutionException {
            return this.toFileList(this.fileSet);
        }

        public List<File> toFileList(FileSet fs) throws MojoExecutionException {
            try {
                if (fs.getDirectory() != null) {
                    File directory = new File(fs.getDirectory());
                    String includes = this.toString(fs.getIncludes());
                    String excludes = this.toString(fs.getExcludes());
                    return FileUtils.getFiles((File)directory, (String)includes, (String)excludes);
                }
                Plugin.this.getLog().warn((CharSequence)String.format("Fileset [%s] directory empty", fs.toString()));
                return new ArrayList<File>();
            }
            catch (IOException e) {
                throw new MojoExecutionException(String.format("Unable to get paths to fileset [%s]", fs.toString()), (Exception)e);
            }
        }

        private String toString(List<String> strings) {
            StringBuilder sb = new StringBuilder();
            for (String string : strings) {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(string);
            }
            return sb.toString();
        }
    }
}

