/*
 * Decompiled with CFR 0.152.
 */
package se.claremont.eyeautomatesupport;

import eyeautomate.ScriptRunner;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Assume;
import se.claremont.eyeautomatesupport.GuiImageElement;
import se.claremont.eyeautomatesupport.HtmlStyleElements;
import se.claremont.taf.core.logging.LogFolder;
import se.claremont.taf.core.logging.LogLevel;
import se.claremont.taf.core.logging.LogPost;
import se.claremont.taf.core.reporting.HtmlStyles;
import se.claremont.taf.core.testcase.TestCase;
import se.claremont.taf.core.testrun.TestRun;
import se.claremont.taf.genericguiinteraction.ScreenshotManager;
import se.claremont.taf.genericguiinteraction.guidriverpluginstructure.GuiElement;

public class EyeAutomateDriver {
    public final ScriptRunner scriptRunner = new ScriptRunner(null);
    private final TestCase testCase;

    public EyeAutomateDriver(TestCase testCase) {
        if (testCase == null) {
            testCase = new TestCase(null, "EyeAutomateRunner");
        }
        HtmlStyles.addStyleInfo((String)HtmlStyleElements.styles);
        this.testCase = testCase;
        this.addJarFileToClassPath(EyeAutomateDriver.getTestFileFromTestResourcesFolder("EyeAutomate.jar"));
        testCase.log(LogLevel.INFO, "Started EyeAutomate driver.");
    }

    public void runScriptFile(String filePath) {
        this.Log(LogLevel.DEBUG, "Attempting to run scriptFile '" + filePath + "'.");
        if (!Files.exists(Paths.get(filePath, new String[0]), new LinkOption[0])) {
            this.Log(LogLevel.EXECUTION_PROBLEM, "Attempting to run EyeAutomate script file '" + filePath + "', but it does not exist.");
            return;
        }
        boolean success = this.scriptRunner.runScript(filePath);
        if (success) {
            this.Log(LogLevel.EXECUTED, "Executed EyeAutomate script file '" + filePath + "' successfully.");
        } else {
            this.Log(LogLevel.EXECUTION_PROBLEM, "Could not successfully execute EyeAutomate script file '" + filePath + "'.");
        }
    }

    public boolean executeCommand(String commandLine) {
        String[] scriptRowParts = commandLine.split(" ");
        ArrayList<String> validParts = new ArrayList<String>();
        for (String part : scriptRowParts) {
            if (part.trim().length() == 0) continue;
            validParts.add(part);
        }
        boolean success = this.executeCommand(validParts);
        return success;
    }

    public void wait(int seconds) {
        try {
            Thread.sleep(seconds * 1000);
            this.testCase.log(LogLevel.DEBUG, "Paused execution for " + seconds + "' seconds.");
        }
        catch (InterruptedException e) {
            this.testCase.log(LogLevel.EXECUTION_PROBLEM, "Could not pause execution as expected.");
        }
    }

    private boolean executeCommand(ArrayList<String> scriptRowParts) {
        boolean success;
        this.Log(LogLevel.DEBUG, "Attempting to run EyeAutomate command '" + String.join((CharSequence)" ", scriptRowParts) + "'.");
        String commandString = "";
        String command = null;
        StringBuilder arguments = null;
        if (scriptRowParts.size() == 0) {
            this.testCase.log(LogLevel.EXECUTION_PROBLEM, "EyeAutomate command string was null. Cannot execute command.");
            return false;
        }
        if (scriptRowParts.size() > 0) {
            command = scriptRowParts.get(0);
            commandString = commandString + command + " ";
        }
        if (scriptRowParts.size() > 1) {
            String imageFile = scriptRowParts.get(1);
            commandString = commandString + imageFile + " ";
        }
        if (scriptRowParts.size() > 2) {
            for (int i = 3; i < scriptRowParts.size(); ++i) {
                arguments.append(scriptRowParts.get(i)).append(" ");
            }
            if (arguments != null) {
                arguments = new StringBuilder(arguments.toString().trim());
                commandString = commandString + arguments + " ";
            }
        }
        if (success = this.scriptRunner.runScript(command, commandString = commandString.trim())) {
            this.testCase.log(LogLevel.EXECUTED, "EyeAutomate executed '" + commandString + "' command.");
        } else {
            this.testCase.log(LogLevel.EXECUTION_PROBLEM, "EyeAutomate could not execute '" + commandString + "'.");
            GuiImageElement element = null;
            if (scriptRowParts.size() > 1) {
                element = new GuiImageElement(scriptRowParts.get(1), scriptRowParts.get(1));
            }
            this.saveScreenshot(element);
            this.saveDesktopScreenshot();
            this.haltFurtherExecution();
        }
        return success;
    }

    private void executeScriptRow(ArrayList<String> scriptRowParts) {
        String command = null;
        String imageFile = null;
        StringBuilder arguments = null;
        if (scriptRowParts.size() == 0) {
            return;
        }
        if (scriptRowParts.size() > 0) {
            command = scriptRowParts.get(0);
        }
        if (scriptRowParts.size() > 1) {
            imageFile = scriptRowParts.get(1);
        }
        if (scriptRowParts.size() > 2) {
            for (int i = 3; i < scriptRowParts.size(); ++i) {
                arguments.append(scriptRowParts.get(i)).append(" ");
            }
            if (arguments != null) {
                arguments = new StringBuilder(arguments.toString().trim());
            }
        }
        if (command == null) {
            this.testCase.log(LogLevel.DEBUG, "EyeAutomate command string was null.");
            return;
        }
        switch (command.toLowerCase()) {
            case "click": {
                if (scriptRowParts.size() == 2) {
                    this.click(new GuiImageElement(imageFile, imageFile));
                    break;
                }
                if (scriptRowParts.size() == 4) {
                    this.click((GuiElement)new GuiImageElement(imageFile, imageFile), scriptRowParts.get(2), scriptRowParts.get(3));
                    break;
                }
                this.executeCommand(scriptRowParts);
                break;
            }
            case "write": {
                if (scriptRowParts.size() > 2) {
                    this.write(new GuiImageElement(imageFile, imageFile), arguments.toString());
                    break;
                }
                this.executeCommand(scriptRowParts);
                break;
            }
            default: {
                this.executeCommand(scriptRowParts);
            }
        }
    }

    public void click(GuiElement element) {
        this.click(element, true);
    }

    public void click(GuiElement element, boolean performLogging) {
        if (performLogging) {
            this.verifyGuiElementFileExistance(element);
        }
        GuiImageElement guiImageElement = (GuiImageElement)element;
        boolean success = this.scriptRunner.runScript("Click", "Click \"" + guiImageElement.getImageFilePath() + "\"", null);
        if (success && performLogging) {
            this.testCase.logDifferentlyToTextLogAndHtmlLog(LogLevel.EXECUTED, "Clicked the '" + guiImageElement.getName() + "' element ('" + guiImageElement.getImageFilePath() + "').", "Clicked " + this.guiImageElementToHtml(guiImageElement));
        } else if (performLogging) {
            this.testCase.logDifferentlyToTextLogAndHtmlLog(LogLevel.EXECUTION_PROBLEM, "Could not click the '" + guiImageElement.getName() + "' element located at '" + guiImageElement.getImageFilePath() + "'. The file was found, but the click could not be performed.", "Could not click " + this.guiImageElementToHtml(guiImageElement));
            this.saveScreenshot(element);
            this.saveDesktopScreenshot();
            this.haltFurtherExecution();
        }
    }

    public void click(GuiElement element, int offsetX, int offsetY) {
        this.verifyGuiElementFileExistance(element);
        GuiImageElement guiImageElement = (GuiImageElement)element;
        boolean success = this.scriptRunner.runScript("Click", "Click \"" + guiImageElement.getImageFilePath() + "\"", String.valueOf(offsetX) + " " + String.valueOf(offsetY));
        if (success) {
            this.testCase.logDifferentlyToTextLogAndHtmlLog(LogLevel.EXECUTED, "Clicked the '" + guiImageElement.getName() + "' element with offset X:" + String.valueOf(offsetX) + ", Y:" + String.valueOf(offsetY) + ".", "Clicked with offset X:" + String.valueOf(offsetX) + ", Y:" + String.valueOf(offsetY) + " to " + this.guiImageElementToHtml(guiImageElement));
        } else {
            this.testCase.log(LogLevel.EXECUTION_PROBLEM, "Could not click with offset X:" + String.valueOf(offsetX) + ", Y:" + String.valueOf(offsetY) + " to " + this.guiImageElementToHtml(guiImageElement));
            this.saveScreenshot(element);
            this.saveDesktopScreenshot();
            this.haltFurtherExecution();
        }
    }

    public void click(GuiElement element, String offsetX, String offsetY) {
        this.verifyGuiElementFileExistance(element);
        GuiImageElement guiImageElement = (GuiImageElement)element;
        boolean success = this.scriptRunner.runScript("Click", "Click \"" + guiImageElement.getImageFilePath() + "\"", offsetX + " " + offsetY);
        if (success) {
            this.testCase.logDifferentlyToTextLogAndHtmlLog(LogLevel.EXECUTED, "Clicked the '" + guiImageElement.getName() + "' element with offset X:" + String.valueOf(offsetX) + ", Y:" + String.valueOf(offsetY) + ".", "Clicked with offset X:" + String.valueOf(offsetX) + ", Y:" + String.valueOf(offsetY) + " to " + this.guiImageElementToHtml(guiImageElement));
        } else {
            this.testCase.log(LogLevel.EXECUTION_PROBLEM, "Could not click with offset X:" + String.valueOf(offsetX) + ", Y:" + String.valueOf(offsetY) + " to " + this.guiImageElementToHtml(guiImageElement));
            this.saveScreenshot(element);
            this.saveDesktopScreenshot();
            this.haltFurtherExecution();
        }
    }

    public void write(GuiElement element, String text) {
        this.verifyGuiElementFileExistance(element);
        GuiImageElement guiImageElement = (GuiImageElement)element;
        this.click(element);
        boolean success = this.scriptRunner.runScript("Write", "Write \"" + text + "\"", null);
        if (success) {
            this.testCase.logDifferentlyToTextLogAndHtmlLog(LogLevel.EXECUTED, "Wrote '" + text + "' to the '" + guiImageElement.getName() + "' element.", "Wrote '" + text + "' to " + this.guiImageElementToHtml(guiImageElement));
        } else {
            this.testCase.logDifferentlyToTextLogAndHtmlLog(LogLevel.EXECUTION_PROBLEM, "Could not write '" + text + "' to the '" + guiImageElement.getName() + "' element (" + guiImageElement.getImageFilePath() + ").", "Could not write '" + text + "' to " + this.guiImageElementToHtml(guiImageElement));
            this.saveScreenshot(element);
            this.saveDesktopScreenshot();
            this.haltFurtherExecution();
        }
    }

    public void moveMouseToElement(GuiElement element) {
        this.verifyGuiElementFileExistance(element);
        GuiImageElement guiImageElement = (GuiImageElement)element;
        boolean success = this.scriptRunner.runScript("WaitMouseMove", "WaitMouseMove \"" + guiImageElement.getImageFilePath() + "\"", null);
        if (success) {
            this.testCase.logDifferentlyToTextLogAndHtmlLog(LogLevel.DEBUG, "Moved mouse cursor to the '" + guiImageElement.getName() + "' element (" + guiImageElement.getImageFilePath() + ").", "Moved mouse cursor to " + this.guiImageElementToHtml(guiImageElement));
        } else {
            this.testCase.logDifferentlyToTextLogAndHtmlLog(LogLevel.EXECUTION_PROBLEM, "Could not move the mouse cursor to '" + guiImageElement.getName() + "' element.", "Could not move mouse cursor to " + this.guiImageElementToHtml(guiImageElement));
            this.saveScreenshot(element);
            this.saveDesktopScreenshot();
            this.haltFurtherExecution();
        }
    }

    public void verifyImage(GuiElement element) {
        this.verifyGuiElementFileExistance(element);
        GuiImageElement guiImageElement = (GuiImageElement)element;
        boolean success = this.scriptRunner.runScript("WaitVerify", "WaitVerify \"" + guiImageElement.getImageFilePath() + "\"", null);
        if (success) {
            this.testCase.logDifferentlyToTextLogAndHtmlLog(LogLevel.VERIFICATION_PASSED, "Found match for '" + guiImageElement.getName() + "' (" + guiImageElement.getImageFilePath() + ").", "Found image match for " + this.guiImageElementToHtml(guiImageElement));
        } else {
            this.testCase.logDifferentlyToTextLogAndHtmlLog(LogLevel.VERIFICATION_FAILED, "Could not find any match for '" + guiImageElement.getName() + "' element (" + guiImageElement.getImageFilePath() + ").", "Could not find any match for " + this.guiImageElementToHtml(guiImageElement));
            this.saveScreenshot(element);
            this.saveDesktopScreenshot();
            this.haltFurtherExecution();
        }
    }

    public void exists(GuiElement element) {
        GuiImageElement guiImageElement = (GuiImageElement)element;
        boolean success = this.scriptRunner.callCommand("Find", new String[]{guiImageElement.getImageFilePath()}, null);
        if (success) {
            this.testCase.logDifferentlyToTextLogAndHtmlLog(LogLevel.DEBUG, "Found match for '" + guiImageElement.getName() + "' (" + guiImageElement.getImageFilePath() + ").", "Found image match for " + this.guiImageElementToHtml(guiImageElement));
        } else {
            this.testCase.logDifferentlyToTextLogAndHtmlLog(LogLevel.DEBUG, "Could not find any match for '" + guiImageElement.getName() + "' element (" + guiImageElement.getImageFilePath() + ").", "Could not find any match for " + this.guiImageElementToHtml(guiImageElement));
        }
    }

    private String guiImageElementToHtml(GuiImageElement guiImageElement) {
        return "the " + guiImageElement.toHtml();
    }

    public void haltFurtherExecution() {
        this.testCase.writeProcessListDeviationsFromSystemStartToLog();
        this.testCase.report();
    }

    public void saveScreenshot(GuiElement element) {
        String filePath = LogFolder.testRunLogFolder + this.testCase.testName + TestRun.getFileCounter() + ".png";
        TestRun.increaseFileCounter();
        if (element == null) {
            this.saveDesktopScreenshot();
        } else {
            GuiImageElement guiImageElement = (GuiImageElement)element;
            if (guiImageElement.getImageFilePath().contains("http://") || guiImageElement.getImageFilePath().contains("https://")) {
                return;
            }
            StandardCopyOption copyOption = StandardCopyOption.REPLACE_EXISTING;
            try {
                File file = new File(filePath);
                file.getParentFile().mkdirs();
                Files.copy(Paths.get(guiImageElement.getImageFilePath(), new String[0]), Paths.get(filePath, new String[0]), copyOption);
                this.testCase.logDifferentlyToTextLogAndHtmlLog(LogLevel.INFO, "Image of element in question copied from '" + guiImageElement.getImageFilePath() + "' to '" + filePath + "'.", "Image of element<br><img src=\"file://" + filePath + "\" alt=\"Image " + filePath + "\">");
            }
            catch (IOException e) {
                this.testCase.logDifferentlyToTextLogAndHtmlLog(LogLevel.EXECUTION_PROBLEM, "Could not copy image of element in question copied from '" + guiImageElement.getImageFilePath() + "' to '" + filePath + "'.", "Could not copy image of element<br><img src=\"file://" + filePath.replace("\\", "/") + "\" alt=\"Image " + filePath + "\"><br>From '" + guiImageElement.getImageFilePath() + "' to '" + filePath + "'");
            }
        }
    }

    public void saveDesktopScreenshot() {
        try {
            ScreenshotManager e = new ScreenshotManager(this.testCase);
            e.takeScreenshot();
        }
        catch (Exception e) {
            this.testCase.log(LogLevel.DEBUG, "Could not take desktop screenshot: " + e.toString());
        }
    }

    public void Log(LogLevel logLevel, String message) {
        if (this.testCase == null) {
            System.out.println(new LogPost(logLevel, message, null, this.testCase.testName, this.testCase.getCurrentTestStepName(), this.getClass().getSimpleName()).toString());
            return;
        }
        this.testCase.log(logLevel, message);
    }

    private void verifyGuiElementFileExistance(GuiElement guiElement) {
        GuiImageElement guiImageElement = (GuiImageElement)guiElement;
        if (guiElement == null || guiImageElement == null || guiImageElement.getImageFilePath() == null || guiImageElement.getImageFilePath().trim().length() == 0 || !Files.exists(Paths.get(guiImageElement.getImageFilePath(), new String[0]), new LinkOption[0])) {
            String name = "";
            try {
                name = guiImageElement.getName();
            }
            catch (Exception exception) {
                // empty catch block
            }
            String path = "";
            try {
                path = ((GuiImageElement)guiElement).getImageFilePath();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.testCase.log(LogLevel.EXECUTION_PROBLEM, "Could not identify the '" + name + "' element since its image file could not be found at '" + path + "'.");
            this.saveScreenshot(guiElement);
            this.saveDesktopScreenshot();
            this.haltFurtherExecution();
        } else {
            this.testCase.log(LogLevel.DEBUG, "Identified image file for element '" + guiImageElement.getName() + "' at '" + guiImageElement.getImageFilePath() + "'.");
        }
    }

    private static String getTestFileFromTestResourcesFolder(String fileName) {
        URL url = Thread.currentThread().getContextClassLoader().getResource(fileName);
        Assert.assertNotNull((String)("Could not identify file '" + fileName + "'"), (Object)url);
        File file = new File(url.getPath());
        Assume.assumeNotNull((Object[])new Object[]{file});
        return file.getAbsolutePath();
    }

    private void addURL(URL url) throws Exception {
        URLClassLoader classLoader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        Class<URLClassLoader> clazz = URLClassLoader.class;
        Method method = clazz.getDeclaredMethod("addURL", URL.class);
        method.setAccessible(true);
        method.invoke((Object)classLoader, url);
    }

    private void addJarFileToClassPath(String filePath) {
        try {
            this.testCase.log(LogLevel.EXECUTED, "Adding file '" + filePath + "' to classpath.");
            this.addURL(new File(filePath).toURI().toURL());
        }
        catch (Exception e) {
            this.testCase.log(LogLevel.EXECUTION_PROBLEM, "Could not add file '" + filePath + "' to classpath. Error: " + e.getMessage());
        }
    }
}

