/*
 * Decompiled with CFR 0.152.
 */
package io.changock.migration.api;

import java.lang.reflect.Method;
import java.util.Objects;

public class ChangeSetItem {
    private final String id;
    private final String author;
    private final String order;
    private final boolean runAlways;
    private final String systemVersion;
    private final Method method;
    private final boolean failFast;

    public ChangeSetItem(String id, String author, String order, boolean runAlways, String systemVersion, boolean failFast, Method method) {
        this.id = id;
        this.author = author;
        this.order = order;
        this.runAlways = runAlways;
        this.systemVersion = systemVersion;
        this.method = method;
        this.failFast = failFast;
    }

    public String getId() {
        return this.id;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getOrder() {
        return this.order;
    }

    public boolean isRunAlways() {
        return this.runAlways;
    }

    public String getSystemVersion() {
        return this.systemVersion;
    }

    public Method getMethod() {
        return this.method;
    }

    public boolean isFailFast() {
        return this.failFast;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChangeSetItem that = (ChangeSetItem)o;
        return Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public String toString() {
        return "ChangeSetItem{id='" + this.id + '\'' + ", author='" + this.author + '\'' + ", order='" + this.order + '\'' + ", runAlways=" + this.runAlways + ", systemVersion='" + this.systemVersion + '\'' + ", method=" + this.method + ", failFast=" + this.failFast + '}';
    }

    public String toPrettyString() {
        return "ChangeEntry{, \"id\"=\"" + this.id + "\", \"author\"=\"" + this.author + "\", \"class\"=\"" + this.method.getDeclaringClass().getSimpleName() + "\", \"method\"=\"" + this.method.getName() + "\"" + '}';
    }
}

