/*
 * Decompiled with CFR 0.152.
 */
package io.changock.runner.spring.v5;

import io.changock.driver.api.driver.ChangeSetDependency;
import io.changock.driver.api.driver.ConnectionDriver;
import io.changock.migration.api.exception.ChangockException;
import io.changock.runner.core.DependencyContext;
import io.changock.runner.core.DependencyManagerWithContext;
import io.changock.runner.core.MigrationExecutorConfiguration;
import io.changock.runner.core.builder.RunnerBuilderBase;
import io.changock.runner.core.builder.configuration.LegacyMigration;
import io.changock.runner.spring.util.SpringDependencyContext;
import io.changock.runner.spring.util.SpringEventPublisher;
import io.changock.runner.spring.util.config.ChangockSpringConfiguration;
import io.changock.runner.spring.v5.SpringApplicationRunner;
import io.changock.runner.spring.v5.SpringInitializingBean;
import io.changock.runner.spring.v5.core.ProfiledChangeLogService;
import io.changock.runner.spring.v5.core.SpringMigrationExecutor;
import io.changock.utils.CollectionUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.core.env.Environment;

public abstract class ChangockSpringBuilderBase<BUILDER_TYPE extends ChangockSpringBuilderBase, DRIVER extends ConnectionDriver, SPRING_CONFIG extends ChangockSpringConfiguration>
extends RunnerBuilderBase<BUILDER_TYPE, DRIVER, SPRING_CONFIG> {
    protected static final String DEFAULT_PROFILE = "default";
    protected ApplicationContext springContext;
    protected ApplicationEventPublisher applicationEventPublisher;

    public BUILDER_TYPE setSpringContext(ApplicationContext springContext) {
        this.springContext = springContext;
        return (BUILDER_TYPE)((Object)((ChangockSpringBuilderBase)this.returnInstance()));
    }

    public BUILDER_TYPE setEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
        return (BUILDER_TYPE)((Object)((ChangockSpringBuilderBase)this.returnInstance()));
    }

    public BUILDER_TYPE setConfig(SPRING_CONFIG config) {
        super.setConfig(config);
        return (BUILDER_TYPE)((Object)((ChangockSpringBuilderBase)this.returnInstance()));
    }

    public SpringApplicationRunner buildApplicationRunner() {
        return new SpringApplicationRunner(this.buildExecutorWithEnvironmentDependency(), this.buildProfiledChangeLogService(), this.throwExceptionIfCannotObtainLock, this.enabled, this.buildSpringEventPublisher());
    }

    public SpringInitializingBean buildInitializingBeanRunner() {
        return new SpringInitializingBean(this.buildExecutorWithEnvironmentDependency(), this.buildProfiledChangeLogService(), this.throwExceptionIfCannotObtainLock, this.enabled, this.buildSpringEventPublisher());
    }

    protected SpringMigrationExecutor buildExecutorWithEnvironmentDependency() {
        return new SpringMigrationExecutor(this.driver, this.buildDependencyManagerWithContext(), new MigrationExecutorConfiguration(this.trackIgnored), this.metadata);
    }

    protected DependencyManagerWithContext buildDependencyManagerWithContext() {
        DependencyManagerWithContext dependencyManager = new DependencyManagerWithContext((DependencyContext)new SpringDependencyContext(this.springContext));
        if (this.legacyMigration != null) {
            dependencyManager.addStandardDependency(new ChangeSetDependency("legacy-migration", LegacyMigration.class, (Object)this.legacyMigration));
        }
        dependencyManager.addDriverDependencies(this.dependencies);
        return dependencyManager;
    }

    protected ProfiledChangeLogService buildProfiledChangeLogService() {
        if (this.springContext == null) {
            throw new ChangockException("ApplicationContext from Spring must be injected to Builder");
        }
        Environment springEnvironment = this.springContext.getEnvironment();
        List<String> activeProfiles = springEnvironment != null && CollectionUtils.isNotNullOrEmpty((Object[])springEnvironment.getActiveProfiles()) ? Arrays.asList(springEnvironment.getActiveProfiles()) : Collections.singletonList(DEFAULT_PROFILE);
        return new ProfiledChangeLogService(this.changeLogsScanPackage, this.changeLogsScanClasses, this.startSystemVersion, this.endSystemVersion, activeProfiles, this.annotationProcessor);
    }

    protected SpringEventPublisher buildSpringEventPublisher() {
        return new SpringEventPublisher(this.applicationEventPublisher);
    }

    public void runValidation() {
        super.runValidation();
        if (this.springContext == null) {
            throw new ChangockException("ApplicationContext from Spring must be injected to Builder");
        }
    }
}

