/*
 * Decompiled with CFR 0.152.
 */
package io.changock.runner.spring.v5.config;

import io.changock.migration.api.exception.ChangockException;
import io.changock.runner.spring.v5.config.importers.ContextImporter;
import io.changock.runner.spring.v5.config.importers.MongoSpringDataImporter;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.springframework.context.annotation.ImportSelector;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotationMetadata;

public class ChangockContextSelector
implements ImportSelector {
    private static final String DRIVER_NOT_FOUND_ERROR_TEMPLATE = "CHANGOCK DRIVER HAS NOT BEEN IMPORTED\n====================================\n\tSOLUTION: You need to import one of the following artifacts";
    private static final List<ContextImporter> contextImporters = Collections.singletonList(new MongoSpringDataImporter());
    private static final String DRIVER_NOT_FOUND_ERROR;
    private final Environment environment;

    public ChangockContextSelector(Environment environment) {
        this.environment = environment;
    }

    public String[] selectImports(AnnotationMetadata importingClassMetadata) {
        return contextImporters.stream().map(contextImporter -> contextImporter.getPaths(this.environment)).filter(Objects::nonNull).findFirst().orElseThrow(() -> new ChangockException(String.format("\n\n%s\n\n", DRIVER_NOT_FOUND_ERROR)));
    }

    static {
        StringBuilder sb = new StringBuilder(DRIVER_NOT_FOUND_ERROR_TEMPLATE);
        contextImporters.stream().map(ContextImporter::getArtifacts).flatMap(Collection::stream).forEach(desc -> sb.append("\n\t- '").append(desc.getArtifact()).append("' for ").append(desc.getTitle()));
        DRIVER_NOT_FOUND_ERROR = sb.toString();
    }
}

