/*
 * Decompiled with CFR 0.152.
 */
package io.changock.runner.spring.v5.config.importers;

import io.changock.runner.spring.v5.config.importers.ArtifactDescriptor;
import io.changock.runner.spring.v5.config.importers.ContextImporter;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.springframework.core.env.AbstractEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;

public class MongoSpringDataImporter
implements ContextImporter {
    private static final String PACKAGE_TEMPLATE = "com.github.cloudyrock.mongock.driver.mongodb.springdata.v%s.";
    private static final String DRIVER_TEMPLATE = "com.github.cloudyrock.mongock.driver.mongodb.springdata.v%s.SpringDataMongoV%sDriver";
    private static final String CONTEXT_TEMPLATE = "com.github.cloudyrock.mongock.driver.mongodb.springdata.v%s.SpringDataMongoV%sContext";
    private static final String CONFIG_TEMPLATE = "com.github.cloudyrock.mongock.driver.mongodb.springdata.v%s.SpringDataMongoV%sConfiguration";
    private static final String DEPRECATED_CONFIG_TEMPLATE = "com.github.cloudyrock.mongock.driver.mongodb.springdata.v%s.MongockSpringDataV%sConfiguration";

    @Override
    public String[] getPaths(Environment environment) {
        try {
            return this.loadSpringDataContextByVersion((AbstractEnvironment)environment, "3");
        }
        catch (ClassNotFoundException e) {
            try {
                return this.loadSpringDataContextByVersion((AbstractEnvironment)environment, "2");
            }
            catch (ClassNotFoundException e2) {
                return null;
            }
        }
    }

    @Override
    public List<ArtifactDescriptor> getArtifacts() {
        String v = "3";
        return Arrays.asList(this.getArtifactDescriptor("3"), this.getArtifactDescriptor("2"));
    }

    private ArtifactDescriptor getArtifactDescriptor(String v) {
        return new ArtifactDescriptor("MongoDB Spring data " + v, "com.github.cloudyrock.mongock:mongodb-springdata-v" + v + "-driver");
    }

    private String[] loadSpringDataContextByVersion(AbstractEnvironment env, String v) throws ClassNotFoundException {
        Class.forName(String.format(DRIVER_TEMPLATE, v, v));
        String configImport = String.format(this.isChangockConfig(env) ? CONFIG_TEMPLATE : DEPRECATED_CONFIG_TEMPLATE, v, v);
        return new String[]{configImport, String.format(CONTEXT_TEMPLATE, v, v)};
    }

    private boolean isChangockConfig(AbstractEnvironment env) {
        return env.getPropertySources().stream().filter(propertySource -> propertySource instanceof MapPropertySource).map(propertySource -> ((Map)((MapPropertySource)propertySource).getSource()).keySet()).flatMap(Collection::stream).anyMatch(key -> key.toLowerCase().startsWith("changock."));
    }
}

