/*
 * Decompiled with CFR 0.152.
 */
package com.github.cloudyrock.mongock.config;

import com.github.cloudyrock.mongock.config.LegacyMigration;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongockConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(MongockConfiguration.class);
    private static final String LEGACY_DEFAULT_CHANGELOG_REPOSITORY_NAME = "mongockChangeLog";
    private static final String LEGACY_DEFAULT_LOCK_REPOSITORY_NAME = "mongockLock";
    private static final String DEPRECATED_PROPERTY_TEMPLATE = "\n\n\n*****************************************************************\nPROPERTY [{}] DEPRECATED. IT WILL BE REMOVED IN NEXT VERSIONS\nPlease use the following properties instead: [{}]\n\n\n*****************************************************************";
    public static final long DEFAULT_QUIT_TRYING_AFTER_MILLIS = 180000L;
    private String changeLogRepositoryName;
    private boolean indexCreation = true;
    private String lockRepositoryName;
    private long lockAcquiredForMillis = 60000L;
    private Long lockQuitTryingAfterMillis;
    private long lockTryFrequencyMillis = 1000L;
    private boolean throwExceptionIfCannotObtainLock = true;
    private boolean trackIgnored = false;
    private boolean enabled = true;
    private List<String> changeLogsScanPackage;
    private String startSystemVersion = "0";
    private String endSystemVersion = String.valueOf(Integer.MAX_VALUE);
    private String serviceIdentifier = null;
    private Map<String, Object> metadata;
    private boolean transactionEnabled = true;
    private LegacyMigration legacyMigration = null;
    @Deprecated
    private Integer maxTries;
    @Deprecated
    private Long maxWaitingForLockMillis;

    public MongockConfiguration() {
        this.setChangeLogRepositoryName(this.getChangeLogRepositoryNameDefault());
        this.setLockRepositoryName(this.getLockRepositoryNameDefault());
    }

    public long getLockAcquiredForMillis() {
        return this.lockAcquiredForMillis;
    }

    public void setLockAcquiredForMillis(long lockAcquiredForMillis) {
        this.lockAcquiredForMillis = lockAcquiredForMillis;
    }

    public long getLockQuitTryingAfterMillis() {
        if (this.lockQuitTryingAfterMillis == null) {
            if (this.maxWaitingForLockMillis != null) {
                return this.maxWaitingForLockMillis * (long)(this.maxTries != null ? this.maxTries : 3);
            }
            return 180000L;
        }
        return this.lockQuitTryingAfterMillis;
    }

    public void setLockQuitTryingAfterMillis(long lockQuitTryingAfterMillis) {
        this.lockQuitTryingAfterMillis = lockQuitTryingAfterMillis;
    }

    public long getLockTryFrequencyMillis() {
        return this.lockTryFrequencyMillis;
    }

    public void setLockTryFrequencyMillis(long lockTryFrequencyMillis) {
        this.lockTryFrequencyMillis = lockTryFrequencyMillis;
    }

    public String getChangeLogRepositoryName() {
        return this.changeLogRepositoryName;
    }

    public void setChangeLogRepositoryName(String changeLogRepositoryName) {
        this.changeLogRepositoryName = changeLogRepositoryName;
    }

    public String getLockRepositoryName() {
        return this.lockRepositoryName;
    }

    public void setLockRepositoryName(String lockRepositoryName) {
        this.lockRepositoryName = lockRepositoryName;
    }

    public boolean isIndexCreation() {
        return this.indexCreation;
    }

    public void setIndexCreation(boolean indexCreation) {
        this.indexCreation = indexCreation;
    }

    public boolean isTrackIgnored() {
        return this.trackIgnored;
    }

    public void setTrackIgnored(boolean trackIgnored) {
        this.trackIgnored = trackIgnored;
    }

    public boolean isThrowExceptionIfCannotObtainLock() {
        return this.throwExceptionIfCannotObtainLock;
    }

    public void setThrowExceptionIfCannotObtainLock(boolean throwExceptionIfCannotObtainLock) {
        this.throwExceptionIfCannotObtainLock = throwExceptionIfCannotObtainLock;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public List<String> getChangeLogsScanPackage() {
        return this.changeLogsScanPackage;
    }

    public void setChangeLogsScanPackage(List<String> changeLogsScanPackage) {
        this.changeLogsScanPackage = changeLogsScanPackage;
    }

    public String getStartSystemVersion() {
        return this.startSystemVersion;
    }

    public void setStartSystemVersion(String startSystemVersion) {
        this.startSystemVersion = startSystemVersion;
    }

    public String getEndSystemVersion() {
        return this.endSystemVersion;
    }

    public void setEndSystemVersion(String endSystemVersion) {
        this.endSystemVersion = endSystemVersion;
    }

    public String getServiceIdentifier() {
        return this.serviceIdentifier;
    }

    public void setServiceIdentifier(String serviceIdentifier) {
        this.serviceIdentifier = serviceIdentifier;
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map<String, Object> metadata) {
        this.metadata = metadata;
    }

    public boolean isTransactionEnabled() {
        return this.transactionEnabled;
    }

    public void setTransactionEnabled(boolean transactionEnabled) {
        this.transactionEnabled = transactionEnabled;
    }

    public LegacyMigration getLegacyMigration() {
        return this.legacyMigration;
    }

    public void setLegacyMigration(LegacyMigration legacyMigration) {
        this.legacyMigration = legacyMigration;
    }

    protected String getChangeLogRepositoryNameDefault() {
        return LEGACY_DEFAULT_CHANGELOG_REPOSITORY_NAME;
    }

    protected String getLockRepositoryNameDefault() {
        return LEGACY_DEFAULT_LOCK_REPOSITORY_NAME;
    }

    @Deprecated
    public void setLockAcquiredForMinutes(int lockAcquiredForMinutes) {
        logger.warn(DEPRECATED_PROPERTY_TEMPLATE, (Object)"lockAcquiredForMinutes", (Object)"lockQuitTryingAfterMillis and lockTryFrequencyMillis");
        this.lockAcquiredForMillis = MongockConfiguration.minutesToMillis(lockAcquiredForMinutes);
    }

    @Deprecated
    public void setMaxWaitingForLockMinutes(int maxWaitingForLockMinutes) {
        logger.warn(DEPRECATED_PROPERTY_TEMPLATE, (Object)"maxWaitingForLockMinutes", (Object)"lockQuitTryingAfterMillis and lockTryFrequencyMillis");
        this.maxWaitingForLockMillis = MongockConfiguration.minutesToMillis(maxWaitingForLockMinutes);
    }

    @Deprecated
    public void setMaxTries(int maxTries) {
        logger.warn(DEPRECATED_PROPERTY_TEMPLATE, (Object)"maxTries", (Object)"lockQuitTryingAfterMillis and lockTryFrequencyMillis");
        this.maxTries = maxTries;
    }

    private static long minutesToMillis(int minutes) {
        return (long)(minutes * 60) * 1000L;
    }
}

