/*
 * Decompiled with CFR 0.152.
 */
package com.github.cloudyrock.mongock.driver.api.entry;

import com.github.cloudyrock.mongock.ChangeSetItem;
import com.github.cloudyrock.mongock.driver.api.entry.ChangeState;
import com.github.cloudyrock.mongock.utils.StringUtils;
import com.github.cloudyrock.mongock.utils.field.Field;
import java.util.Date;

public class ChangeEntry {
    @Field(value="executionId")
    private final String executionId;
    @Field(value="changeId")
    private final String changeId;
    @Field(value="author")
    private final String author;
    @Field(value="timestamp")
    private final Date timestamp;
    @Field(value="state")
    private final ChangeState state;
    @Field(value="changeLogClass")
    private final String changeLogClass;
    @Field(value="changeSetMethod")
    private final String changeSetMethod;
    @Field(value="metadata")
    private final Object metadata;
    @Field(value="executionMillis")
    private final long executionMillis;

    public static ChangeEntry createInstance(String executionId, ChangeState state, ChangeSetItem changeSet, long executionMillis, Object metadata) {
        return new ChangeEntry(executionId, changeSet.getId(), changeSet.getAuthor(), new Date(), state, changeSet.getMethod().getDeclaringClass().getName(), changeSet.getMethod().getName(), executionMillis, metadata);
    }

    public ChangeEntry(String executionId, String changeId, String author, Date timestamp, ChangeState state, String changeLogClass, String changeSetMethod, long executionMillis, Object metadata) {
        this.executionId = executionId;
        this.changeId = changeId;
        this.author = author;
        this.timestamp = new Date(timestamp.getTime());
        this.state = state;
        this.changeLogClass = changeLogClass;
        this.changeSetMethod = changeSetMethod;
        this.executionMillis = executionMillis;
        this.metadata = metadata;
    }

    public String getExecutionId() {
        return this.executionId;
    }

    public String getChangeId() {
        return this.changeId;
    }

    public String getAuthor() {
        return this.author;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public ChangeState getState() {
        return this.state;
    }

    public String getChangeLogClass() {
        return this.changeLogClass;
    }

    public String getChangeSetMethod() {
        return this.changeSetMethod;
    }

    public long getExecutionMillis() {
        return this.executionMillis;
    }

    public Object getMetadata() {
        return this.metadata;
    }

    public String toString() {
        return "ChangeEntry{executionId='" + this.executionId + '\'' + ", changeId='" + this.changeId + '\'' + ", author='" + this.author + '\'' + ", timestamp=" + this.timestamp + ", state=" + (Object)((Object)this.state) + ", changeLogClass='" + this.changeLogClass + '\'' + ", changeSetMethod='" + this.changeSetMethod + '\'' + ", metadata=" + this.metadata + ", executionMillis=" + this.executionMillis + '}';
    }

    public String toPrettyString() {
        return "ChangeEntry{, \"id\"=\"" + this.changeId + "\", \"author\"=\"" + this.author + "\", \"class\"=\"" + StringUtils.getSimpleClassName((String)this.changeLogClass) + "\", \"method\"=\"" + this.changeSetMethod + "\"" + '}';
    }
}

