/*
 * Decompiled with CFR 0.152.
 */
package com.github.cloudyrock.spring.v5;

import com.github.cloudyrock.mongock.migration.MongockLegacyMigration;
import io.changock.runner.core.builder.configuration.LegacyMigrationMappingFields;
import io.changock.runner.spring.util.config.ChangockSpringConfiguration;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;

@Configuration
@ConfigurationProperties(value="mongock")
public class MongockConfiguration
extends ChangockSpringConfiguration {
    public static final String DEFAULT_CHANGELOG_COLLECTION_NAME = "mongockChangeLog";
    public static final String DEFAULT_LOCK_COLLECTION_NAME = "mongockLock";
    private String changeLogCollectionName = "mongockChangeLog";
    private String lockCollectionName = "mongockLock";
    private boolean indexCreation = true;
    private MongockLegacyMigrationConfig legacyMigration = null;

    public String getChangeLogCollectionName() {
        return this.changeLogCollectionName;
    }

    public void setChangeLogCollectionName(String changeLogCollectionName) {
        this.changeLogCollectionName = changeLogCollectionName;
    }

    public String getLockCollectionName() {
        return this.lockCollectionName;
    }

    public void setLockCollectionName(String lockCollectionName) {
        this.lockCollectionName = lockCollectionName;
    }

    public boolean isIndexCreation() {
        return this.indexCreation;
    }

    public void setIndexCreation(boolean indexCreation) {
        this.indexCreation = indexCreation;
    }

    public MongockLegacyMigrationConfig getLegacyMigration() {
        return this.legacyMigration;
    }

    public void setLegacyMigration(MongockLegacyMigrationConfig legacyMigration) {
        this.legacyMigration = legacyMigration;
    }

    public static boolean isLegacyMigrationValid(MongockConfiguration config) {
        return config.getLegacyMigration() == null || StringUtils.isEmpty((Object)config.getLegacyMigration().getCollectionName()) || config.getLegacyMigration().getMappingFields() == null || StringUtils.isEmpty((Object)config.getLegacyMigration().getMappingFields().getChangeId()) || StringUtils.isEmpty((Object)config.getLegacyMigration().getMappingFields().getAuthor());
    }

    public static class MongockLegacyMigrationConfig
    extends MongockLegacyMigration {
        @ConfigurationProperties(value="mongock.legacy-migration.mapping-fields")
        public LegacyMigrationMappingFields getMappingFields() {
            return super.getMappingFields();
        }
    }
}

