/*
 * Decompiled with CFR 0.152.
 */
package com.github.cloudyrock.mongock;

import com.github.cloudyrock.mongock.ChangeEntryRepository;
import com.github.cloudyrock.mongock.ChangeService;
import com.github.cloudyrock.mongock.LockChecker;
import com.github.cloudyrock.mongock.LockRepository;
import com.github.cloudyrock.mongock.MongockBuilder;
import com.github.cloudyrock.mongock.MongockException;
import com.github.cloudyrock.mongock.PreInterceptor;
import com.github.cloudyrock.mongock.ProxyFactory;
import com.github.cloudyrock.mongock.SpringBootMongock;
import com.github.cloudyrock.mongock.SpringChangeService;
import com.github.cloudyrock.mongock.TimeUtils;
import com.mongodb.DB;
import com.mongodb.MongoClient;
import com.mongodb.client.MongoDatabase;
import java.util.Arrays;
import java.util.HashSet;
import org.springframework.context.ApplicationContext;
import org.springframework.core.env.Environment;

public class SpringBootMongockBuilder
extends MongockBuilder {
    private ApplicationContext context;

    public SpringBootMongockBuilder(MongoClient mongoClient, String databaseName, String changeLogsScanPackage) {
        super(mongoClient, databaseName, changeLogsScanPackage);
    }

    public SpringBootMongockBuilder setApplicationContext(ApplicationContext context) {
        this.context = context;
        return this;
    }

    public SpringBootMongock build() {
        this.validateMandatoryFields();
        TimeUtils timeUtils = new TimeUtils();
        MongoDatabase database = this.mongoClient.getDatabase(this.databaseName);
        LockRepository lockRepository = new LockRepository(this.lockCollectionName, database);
        lockRepository.ensureIndex();
        final LockChecker lockChecker = new LockChecker(lockRepository, timeUtils).setLockAcquiredForMillis(timeUtils.minutesToMillis(this.lockAcquiredForMinutes)).setLockMaxTries(this.maxTries).setLockMaxWaitMillis(timeUtils.minutesToMillis(this.maxWaitingForLockMinutes));
        PreInterceptor preInterceptor = new PreInterceptor(){

            public void before() {
                lockChecker.ensureLockDefault();
            }
        };
        HashSet<String> proxyCreatorAndUncheckedmethods = new HashSet<String>(Arrays.asList("getCollection", "getCollectionFromString", "getDatabase", "toString"));
        ProxyFactory proxyFactory = new ProxyFactory(preInterceptor, proxyCreatorAndUncheckedmethods, proxyCreatorAndUncheckedmethods);
        ChangeEntryRepository changeEntryRepository = new ChangeEntryRepository(this.changeLogCollectionName, database);
        changeEntryRepository.ensureIndex();
        SpringChangeService changeService = new SpringChangeService();
        changeService.setEnvironment((Environment)this.context.getBean(Environment.class));
        changeService.setChangeLogsBasePackage(this.changeLogsScanPackage);
        DB db = this.mongoClient.getDB(this.databaseName);
        return this.build(changeEntryRepository, changeService, lockChecker, (MongoDatabase)proxyFactory.createProxyFromOriginal((Object)this.mongoClient.getDatabase(this.databaseName), MongoDatabase.class), (DB)proxyFactory.createProxyFromOriginal((Object)db, DB.class), this.context);
    }

    private SpringBootMongock build(ChangeEntryRepository changeEntryRepository, ChangeService changeService, LockChecker lockChecker, MongoDatabase mongoDatabaseProxy, DB dbProxy, ApplicationContext context) {
        SpringBootMongock mongock = new SpringBootMongock(changeEntryRepository, this.mongoClient, changeService, lockChecker);
        mongock.setChangelogMongoDatabase(mongoDatabaseProxy);
        mongock.setChangelogDb(dbProxy);
        mongock.setEnabled(this.enabled);
        mongock.springContext(context);
        mongock.setThrowExceptionIfCannotObtainLock(this.throwExceptionIfCannotObtainLock);
        return mongock;
    }

    void validateMandatoryFields() throws MongockException {
        super.validateMandatoryFields();
        if (this.context == null) {
            throw new MongockException("ApplicationContext must be set to use SpringBootMongockBuilder");
        }
    }
}

