/*
 * Decompiled with CFR 0.152.
 */
package com.github.cloudyrock.mongock;

import com.github.cloudyrock.mongock.ChangeService;
import com.github.cloudyrock.mongock.MongockException;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Profile;
import org.springframework.core.env.Environment;

public class SpringChangeService
extends ChangeService {
    private static final Logger log = LoggerFactory.getLogger(SpringChangeService.class);
    private static final String DEFAULT_PROFILE = "default";
    private List<String> activeProfiles = Collections.singletonList("default");

    void setEnvironment(Environment environment) {
        if (environment != null && environment.getActiveProfiles() != null && environment.getActiveProfiles().length > 0) {
            this.activeProfiles = Arrays.asList(environment.getActiveProfiles());
        }
    }

    public List<Class<?>> fetchChangeLogs() {
        List changeLogs = super.fetchChangeLogs();
        return this.filterByActiveProfiles(changeLogs);
    }

    public List<Method> fetchChangeSets(Class<?> type) throws MongockException {
        List changeSets = super.fetchChangeSets(type);
        return this.filterByActiveProfiles(changeSets);
    }

    private <T extends AnnotatedElement> List<T> filterByActiveProfiles(Collection<T> annotated) {
        ArrayList<AnnotatedElement> filtered = new ArrayList<AnnotatedElement>();
        for (AnnotatedElement element : annotated) {
            if (!this.matchesActiveSpringProfile(element)) continue;
            filtered.add(element);
        }
        return filtered;
    }

    private boolean matchesActiveSpringProfile(AnnotatedElement element) {
        if (!element.isAnnotationPresent(Profile.class)) {
            return true;
        }
        List<String> profiles = Arrays.asList(element.getAnnotation(Profile.class).value());
        for (String profile : profiles) {
            if (!(profile != null && profile.length() > 0 && profile.charAt(0) == '!' ? !this.activeProfiles.contains(profile.substring(1)) : this.activeProfiles.contains(profile))) continue;
            return true;
        }
        return false;
    }
}

