/*
 * Decompiled with CFR 0.152.
 */
package com.github.cloudyrock.mongock;

import com.github.cloudyrock.mongock.ChangeEntryRepository;
import com.github.cloudyrock.mongock.ChangeService;
import com.github.cloudyrock.mongock.LockChecker;
import com.github.cloudyrock.mongock.Mongock;
import com.mongodb.MongoClient;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.env.Environment;
import org.springframework.data.mongodb.core.MongoTemplate;

public class SpringMongock
extends Mongock
implements InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger(SpringMongock.class);
    private Environment springEnvironment;
    private MongoTemplate mongoTemplate;

    protected SpringMongock(ChangeEntryRepository changeEntryRepository, MongoClient mongoClient, ChangeService changeService, LockChecker lockChecker) {
        super(changeEntryRepository, mongoClient, changeService, lockChecker);
    }

    public void afterPropertiesSet() throws Exception {
        this.execute();
    }

    protected void executeChangeSetMethod(Method changeSetMethod, Object changeLogInstance) throws IllegalAccessException, InvocationTargetException {
        if (changeSetMethod.getParameterTypes().length == 1 && changeSetMethod.getParameterTypes()[0].equals(MongoTemplate.class)) {
            logger.debug("method with MongoTemplate argument");
            changeSetMethod.invoke(changeLogInstance, this.mongoTemplate);
        } else if (changeSetMethod.getParameterTypes().length == 2 && changeSetMethod.getParameterTypes()[0].equals(MongoTemplate.class) && changeSetMethod.getParameterTypes()[1].equals(Environment.class)) {
            logger.debug("method with MongoTemplate and environment arguments");
            changeSetMethod.invoke(changeLogInstance, this.mongoTemplate, this.springEnvironment);
        } else {
            super.executeChangeSetMethod(changeSetMethod, changeLogInstance);
        }
    }

    SpringMongock setSpringEnvironment(Environment environment) {
        this.springEnvironment = environment;
        return this;
    }

    SpringMongock setMongoTemplate(MongoTemplate mongoTemplate) {
        this.mongoTemplate = mongoTemplate;
        return this;
    }
}

