/*
 * Decompiled with CFR 0.152.
 */
package com.github.cloudyrock.mongock;

import com.github.cloudyrock.mongock.ChangeEntryRepository;
import com.github.cloudyrock.mongock.ChangeService;
import com.github.cloudyrock.mongock.LockChecker;
import com.github.cloudyrock.mongock.LockRepository;
import com.github.cloudyrock.mongock.MongockBuilder;
import com.github.cloudyrock.mongock.PreInterceptor;
import com.github.cloudyrock.mongock.ProxyFactory;
import com.github.cloudyrock.mongock.SpringChangeService;
import com.github.cloudyrock.mongock.SpringMongock;
import com.github.cloudyrock.mongock.TimeUtils;
import com.mongodb.DB;
import com.mongodb.MongoClient;
import com.mongodb.client.MongoDatabase;
import java.util.Arrays;
import java.util.HashSet;
import org.springframework.core.env.Environment;
import org.springframework.data.mongodb.core.MongoTemplate;

public class SpringMongockBuilder
extends MongockBuilder {
    private Environment springEnvironment = null;
    private MongoTemplate mongoTemplate = null;

    public SpringMongockBuilder(MongoClient mongoClient, String databaseName, String changeLogsScanPackage) {
        super(mongoClient, databaseName, changeLogsScanPackage);
    }

    public SpringMongockBuilder setMongoTemplate(MongoTemplate mongoTemplate) {
        this.mongoTemplate = mongoTemplate;
        return this;
    }

    public SpringMongockBuilder setSpringEnvironment(Environment springEnvironment) {
        this.springEnvironment = springEnvironment;
        return this;
    }

    public SpringMongock build() {
        this.validateMandatoryFields();
        TimeUtils timeUtils = new TimeUtils();
        MongoDatabase database = this.mongoClient.getDatabase(this.databaseName);
        LockRepository lockRepository = new LockRepository(this.lockCollectionName, database);
        lockRepository.ensureIndex();
        final LockChecker lockChecker = new LockChecker(lockRepository, timeUtils).setLockAcquiredForMillis(timeUtils.minutesToMillis(this.lockAcquiredForMinutes)).setLockMaxTries(this.maxTries).setLockMaxWaitMillis(timeUtils.minutesToMillis(this.maxWaitingForLockMinutes));
        PreInterceptor preInterceptor = new PreInterceptor(){

            public void before() {
                lockChecker.ensureLockDefault();
            }
        };
        HashSet<String> proxyCreatorAndUnchackedmethods = new HashSet<String>(Arrays.asList("getCollection", "getCollectionFromString", "getDatabase", "toString"));
        ProxyFactory proxyFactory = new ProxyFactory(preInterceptor, proxyCreatorAndUnchackedmethods, proxyCreatorAndUnchackedmethods);
        ChangeEntryRepository changeEntryRepository = new ChangeEntryRepository(this.changeLogCollectionName, database);
        changeEntryRepository.ensureIndex();
        SpringChangeService changeService = new SpringChangeService();
        changeService.setEnvironment(this.springEnvironment);
        changeService.setChangeLogsBasePackage(this.changeLogsScanPackage);
        DB db = this.mongoClient.getDB(this.databaseName);
        return this.build(changeEntryRepository, changeService, lockChecker, (MongoDatabase)proxyFactory.createProxyFromOriginal((Object)this.mongoClient.getDatabase(this.databaseName), MongoDatabase.class), (DB)proxyFactory.createProxyFromOriginal((Object)db, DB.class), (MongoTemplate)proxyFactory.createProxyFromOriginal((Object)(this.mongoTemplate != null ? this.mongoTemplate : new MongoTemplate(this.mongoClient, this.databaseName)), MongoTemplate.class));
    }

    SpringMongock build(ChangeEntryRepository changeEntryRepository, ChangeService changeService, LockChecker lockChecker, MongoDatabase mongoDatabaseProxy, DB dbProxy, MongoTemplate mongoTemplateProxy) {
        SpringMongock mongock = new SpringMongock(changeEntryRepository, this.mongoClient, changeService, lockChecker);
        mongock.setChangelogMongoDatabase(mongoDatabaseProxy);
        mongock.setChangelogDb(dbProxy);
        mongock.setMongoTemplate(mongoTemplateProxy);
        mongock.setEnabled(this.enabled);
        mongock.setThrowExceptionIfCannotObtainLock(this.throwExceptionIfCannotObtainLock);
        return mongock;
    }
}

