/*
 * Decompiled with CFR 0.152.
 */
package com.github.cloudyrock.mongock;

import com.github.cloudyrock.mongock.ChangeService;
import com.github.cloudyrock.mongock.MongockException;
import com.github.cloudyrock.mongock.ProfileUtil;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.springframework.core.env.Environment;

public class SpringChangeService
extends ChangeService {
    private static final String DEFAULT_PROFILE = "default";
    private List<String> activeProfiles = Collections.singletonList("default");

    void setEnvironment(Environment environment) {
        if (environment != null && environment.getActiveProfiles() != null && environment.getActiveProfiles().length > 0) {
            this.activeProfiles = Arrays.asList(environment.getActiveProfiles());
        }
    }

    public List<Class<?>> fetchChangeLogs() {
        List changeLogs = super.fetchChangeLogs();
        return ProfileUtil.filterByActiveProfiles(this.activeProfiles, changeLogs);
    }

    public List<Method> fetchChangeSets(Class<?> type) throws MongockException {
        List changeSets = super.fetchChangeSets(type);
        return ProfileUtil.filterByActiveProfiles(this.activeProfiles, changeSets);
    }
}

