/*
 * Decompiled with CFR 0.152.
 */
package com.github.cloudyrock.mongock.decorator;

import com.github.cloudyrock.mongock.decorator.impl.MongoDataBaseDecoratorImpl;
import com.github.cloudyrock.mongock.decorator.impl.MongoDbFactoryDecoratorImpl;
import com.github.cloudyrock.mongock.decorator.util.MongockDecoratorBase;
import com.mongodb.ClientSessionOptions;
import com.mongodb.DB;
import com.mongodb.client.ClientSession;
import com.mongodb.client.MongoDatabase;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.support.PersistenceExceptionTranslator;
import org.springframework.data.mongodb.MongoDbFactory;

public interface MongoDbFactoryDecorator
extends MongockDecoratorBase<MongoDbFactory>,
MongoDbFactory {
    default public MongoDatabase getDb() throws DataAccessException {
        return new MongoDataBaseDecoratorImpl(((MongoDbFactory)this.getImpl()).getDb(), this.getInvoker());
    }

    default public MongoDatabase getDb(String dbName) throws DataAccessException {
        return new MongoDataBaseDecoratorImpl(((MongoDbFactory)this.getImpl()).getDb(dbName), this.getInvoker());
    }

    default public PersistenceExceptionTranslator getExceptionTranslator() {
        return ((MongoDbFactory)this.getImpl()).getExceptionTranslator();
    }

    default public DB getLegacyDb() {
        throw new UnsupportedOperationException("Removed DB support from Mongock due to deprecated API. Please use MongoDatabase instead");
    }

    default public ClientSession getSession(ClientSessionOptions clientSessionOptions) {
        return (ClientSession)this.getInvoker().invoke(() -> ((MongoDbFactory)this.getImpl()).getSession(clientSessionOptions));
    }

    default public MongoDbFactory withSession(ClientSession clientSession) {
        return (MongoDbFactory)this.getInvoker().invoke(() -> new MongoDbFactoryDecoratorImpl(((MongoDbFactory)this.getImpl()).withSession(clientSession), this.getInvoker()));
    }
}

