/*
 * Decompiled with CFR 0.152.
 */
package com.github.cloudyrock.mongock.decorator;

import com.github.cloudyrock.mongock.decorator.impl.BulkOperationsDecoratorImpl;
import com.github.cloudyrock.mongock.decorator.impl.CloseableIteratorDecoratorImpl;
import com.github.cloudyrock.mongock.decorator.impl.IndexOperationsDecoratorImpl;
import com.github.cloudyrock.mongock.decorator.impl.MapReduceWithMapFunctionDecoratorImpl;
import com.github.cloudyrock.mongock.decorator.impl.MongoCollectionDecoratorImpl;
import com.github.cloudyrock.mongock.decorator.impl.MongoOperationsDecoratorImpl;
import com.github.cloudyrock.mongock.decorator.impl.ScriptOperationsDecoratorImpl;
import com.github.cloudyrock.mongock.decorator.util.MethodInvoker;
import com.mongodb.ClientSessionOptions;
import com.mongodb.ReadPreference;
import com.mongodb.client.ClientSession;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import org.bson.Document;
import org.springframework.data.geo.GeoResults;
import org.springframework.data.mongodb.core.BulkOperations;
import org.springframework.data.mongodb.core.CollectionCallback;
import org.springframework.data.mongodb.core.CollectionOptions;
import org.springframework.data.mongodb.core.DbCallback;
import org.springframework.data.mongodb.core.DocumentCallbackHandler;
import org.springframework.data.mongodb.core.ExecutableAggregationOperation;
import org.springframework.data.mongodb.core.ExecutableFindOperation;
import org.springframework.data.mongodb.core.ExecutableInsertOperation;
import org.springframework.data.mongodb.core.ExecutableMapReduceOperation;
import org.springframework.data.mongodb.core.ExecutableRemoveOperation;
import org.springframework.data.mongodb.core.ExecutableUpdateOperation;
import org.springframework.data.mongodb.core.FindAndModifyOptions;
import org.springframework.data.mongodb.core.FindAndReplaceOptions;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.ScriptOperations;
import org.springframework.data.mongodb.core.SessionScoped;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationResults;
import org.springframework.data.mongodb.core.aggregation.TypedAggregation;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.index.IndexOperations;
import org.springframework.data.mongodb.core.mapreduce.GroupBy;
import org.springframework.data.mongodb.core.mapreduce.GroupByResults;
import org.springframework.data.mongodb.core.mapreduce.MapReduceOptions;
import org.springframework.data.mongodb.core.mapreduce.MapReduceResults;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.NearQuery;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.util.CloseableIterator;

public interface MongoOperationsDecorator
extends MongoOperations {
    public MongoOperations getImpl();

    public MethodInvoker getInvoker();

    default public MongoConverter getConverter() {
        return this.getImpl().getConverter();
    }

    default public <T> CloseableIterator<T> stream(Query query, Class<T> entityType) {
        return (CloseableIterator)this.getInvoker().invoke(() -> this.getImpl().stream(query, entityType));
    }

    default public <T> CloseableIterator<T> stream(Query query, Class<T> entityType, String collectionName) {
        return (CloseableIterator)this.getInvoker().invoke(() -> this.getImpl().stream(query, entityType, collectionName));
    }

    default public String getCollectionName(Class<?> entityClass) {
        return this.getImpl().getCollectionName(entityClass);
    }

    default public Document executeCommand(String jsonCommand) {
        return (Document)this.getInvoker().invoke(() -> this.getImpl().executeCommand(jsonCommand));
    }

    default public Document executeCommand(Document command) {
        return (Document)this.getInvoker().invoke(() -> this.getImpl().executeCommand(command));
    }

    default public Document executeCommand(Document command, ReadPreference readPreference) {
        return (Document)this.getInvoker().invoke(() -> this.getImpl().executeCommand(command, readPreference));
    }

    default public void executeQuery(Query query, String collectionName, DocumentCallbackHandler dch) {
        this.getInvoker().invoke(() -> this.getImpl().executeQuery(query, collectionName, dch));
    }

    default public <T> T execute(DbCallback<T> action) {
        return (T)this.getInvoker().invoke(() -> this.getImpl().execute(action));
    }

    default public <T> T execute(Class<?> entityClass, CollectionCallback<T> callback) {
        return (T)this.getInvoker().invoke(() -> this.getImpl().execute(entityClass, callback));
    }

    default public <T> T execute(String collectionName, CollectionCallback<T> callback) {
        return (T)this.getInvoker().invoke(() -> this.getImpl().execute(collectionName, callback));
    }

    default public <T> MongoCollection<Document> createCollection(Class<T> entityClass) {
        return new MongoCollectionDecoratorImpl((MongoCollection)this.getInvoker().invoke(() -> this.getImpl().createCollection(entityClass)), this.getInvoker());
    }

    default public <T> MongoCollection<Document> createCollection(Class<T> entityClass, CollectionOptions collectionOptions) {
        return new MongoCollectionDecoratorImpl((MongoCollection)this.getInvoker().invoke(() -> this.getImpl().createCollection(entityClass, collectionOptions)), this.getInvoker());
    }

    default public MongoCollection<Document> createCollection(String collectionName) {
        return new MongoCollectionDecoratorImpl((MongoCollection)this.getInvoker().invoke(() -> this.getImpl().createCollection(collectionName)), this.getInvoker());
    }

    default public MongoCollection<Document> createCollection(String collectionName, CollectionOptions collectionOptions) {
        return new MongoCollectionDecoratorImpl((MongoCollection)this.getInvoker().invoke(() -> this.getImpl().createCollection(collectionName, collectionOptions)), this.getInvoker());
    }

    default public MongoCollection<Document> getCollection(String collectionName) {
        return new MongoCollectionDecoratorImpl((MongoCollection)this.getInvoker().invoke(() -> this.getImpl().getCollection(collectionName)), this.getInvoker());
    }

    default public <T> boolean collectionExists(Class<T> entityClass) {
        return (Boolean)this.getInvoker().invoke(() -> this.getImpl().collectionExists(entityClass));
    }

    default public boolean collectionExists(String collectionName) {
        return (Boolean)this.getInvoker().invoke(() -> this.getImpl().collectionExists(collectionName));
    }

    default public <T> void dropCollection(Class<T> entityClass) {
        this.getInvoker().invoke(() -> this.getImpl().dropCollection(entityClass));
    }

    default public void dropCollection(String collectionName) {
        this.getInvoker().invoke(() -> this.getImpl().dropCollection(collectionName));
    }

    default public <T> T findOne(Query query, Class<T> entityClass) {
        return (T)this.getInvoker().invoke(() -> this.getImpl().findOne(query, entityClass));
    }

    default public <T> T findOne(Query query, Class<T> entityClass, String collectionName) {
        return (T)this.getInvoker().invoke(() -> this.getImpl().findOne(query, entityClass, collectionName));
    }

    default public boolean exists(Query query, Class<?> entityClass) {
        return (Boolean)this.getInvoker().invoke(() -> this.getImpl().exists(query, entityClass));
    }

    default public boolean exists(Query query, String collectionName) {
        return (Boolean)this.getInvoker().invoke(() -> this.getImpl().exists(query, collectionName));
    }

    default public boolean exists(Query query, Class<?> entityClass, String collectionName) {
        return (Boolean)this.getInvoker().invoke(() -> this.getImpl().exists(query, entityClass, collectionName));
    }

    default public <T> List<T> find(Query query, Class<T> entityClass) {
        return (List)this.getInvoker().invoke(() -> this.getImpl().find(query, entityClass));
    }

    default public <T> List<T> find(Query query, Class<T> entityClass, String collectionName) {
        return (List)this.getInvoker().invoke(() -> this.getImpl().find(query, entityClass, collectionName));
    }

    default public <T> T findById(Object id, Class<T> entityClass) {
        return (T)this.getInvoker().invoke(() -> this.getImpl().findById(id, entityClass));
    }

    default public <T> T findById(Object id, Class<T> entityClass, String collectionName) {
        return (T)this.getInvoker().invoke(() -> this.getImpl().findById(id, entityClass, collectionName));
    }

    default public <T> GeoResults<T> geoNear(NearQuery near, Class<T> entityClass) {
        return (GeoResults)this.getInvoker().invoke(() -> this.getImpl().geoNear(near, entityClass));
    }

    default public <T> GeoResults<T> geoNear(NearQuery near, Class<T> domainType, String collectionName) {
        return (GeoResults)this.getInvoker().invoke(() -> this.getImpl().geoNear(near, domainType, collectionName));
    }

    default public <T> T findAndModify(Query query, Update update, Class<T> entityClass) {
        return (T)this.getInvoker().invoke(() -> this.getImpl().findAndModify(query, update, entityClass));
    }

    default public <T> T findAndModify(Query query, Update update, Class<T> entityClass, String collectionName) {
        return (T)this.getInvoker().invoke(() -> this.getImpl().findAndModify(query, update, entityClass, collectionName));
    }

    default public <T> T findAndModify(Query query, Update update, FindAndModifyOptions options, Class<T> entityClass) {
        return (T)this.getInvoker().invoke(() -> this.getImpl().findAndModify(query, update, options, entityClass));
    }

    default public <T> T findAndModify(Query query, Update update, FindAndModifyOptions options, Class<T> entityClass, String collectionName) {
        return (T)this.getInvoker().invoke(() -> this.getImpl().findAndModify(query, update, options, entityClass, collectionName));
    }

    default public <T> T findAndRemove(Query query, Class<T> entityClass) {
        return (T)this.getInvoker().invoke(() -> this.getImpl().findAndRemove(query, entityClass));
    }

    default public <T> T findAndRemove(Query query, Class<T> entityClass, String collectionName) {
        return (T)this.getInvoker().invoke(() -> this.getImpl().findAndRemove(query, entityClass, collectionName));
    }

    default public long count(Query query, Class<?> entityClass) {
        return (Long)this.getInvoker().invoke(() -> this.getImpl().count(query, entityClass));
    }

    default public long count(Query query, String collectionName) {
        return (Long)this.getInvoker().invoke(() -> this.getImpl().count(query, collectionName));
    }

    default public long count(Query query, Class<?> entityClass, String collectionName) {
        return (Long)this.getInvoker().invoke(() -> this.getImpl().count(query, entityClass, collectionName));
    }

    default public <T> T insert(T objectToSave) {
        return (T)this.getInvoker().invoke(() -> this.getImpl().insert(objectToSave));
    }

    default public <T> T insert(T objectToSave, String collectionName) {
        return (T)this.getInvoker().invoke(() -> this.getImpl().insert(objectToSave, collectionName));
    }

    default public <T> Collection<T> insert(Collection<? extends T> batchToSave, Class<?> entityClass) {
        return (Collection)this.getInvoker().invoke(() -> this.getImpl().insert(batchToSave, entityClass));
    }

    default public <T> Collection<T> insert(Collection<? extends T> batchToSave, String collectionName) {
        return (Collection)this.getInvoker().invoke(() -> this.getImpl().insert(batchToSave, collectionName));
    }

    default public <T> Collection<T> insertAll(Collection<? extends T> objectsToSave) {
        return (Collection)this.getInvoker().invoke(() -> this.getImpl().insertAll(objectsToSave));
    }

    default public <T> T save(T objectToSave) {
        return (T)this.getInvoker().invoke(() -> this.getImpl().save(objectToSave));
    }

    default public <T> T save(T objectToSave, String collectionName) {
        return (T)this.getInvoker().invoke(() -> this.getImpl().save(objectToSave, collectionName));
    }

    default public UpdateResult upsert(Query query, Update update, Class<?> entityClass) {
        return (UpdateResult)this.getInvoker().invoke(() -> this.getImpl().upsert(query, update, entityClass));
    }

    default public UpdateResult upsert(Query query, Update update, String collectionName) {
        return (UpdateResult)this.getInvoker().invoke(() -> this.getImpl().upsert(query, update, collectionName));
    }

    default public UpdateResult upsert(Query query, Update update, Class<?> entityClass, String collectionName) {
        return (UpdateResult)this.getInvoker().invoke(() -> this.getImpl().upsert(query, update, entityClass, collectionName));
    }

    default public UpdateResult updateFirst(Query query, Update update, Class<?> entityClass) {
        return (UpdateResult)this.getInvoker().invoke(() -> this.getImpl().updateFirst(query, update, entityClass));
    }

    default public UpdateResult updateFirst(Query query, Update update, String collectionName) {
        return (UpdateResult)this.getInvoker().invoke(() -> this.getImpl().upsert(query, update, collectionName));
    }

    default public UpdateResult updateFirst(Query query, Update update, Class<?> entityClass, String collectionName) {
        return (UpdateResult)this.getInvoker().invoke(() -> this.getImpl().updateFirst(query, update, entityClass, collectionName));
    }

    default public UpdateResult updateMulti(Query query, Update update, Class<?> entityClass) {
        return (UpdateResult)this.getInvoker().invoke(() -> this.getImpl().updateMulti(query, update, entityClass));
    }

    default public UpdateResult updateMulti(Query query, Update update, String collectionName) {
        return (UpdateResult)this.getInvoker().invoke(() -> this.getImpl().updateMulti(query, update, collectionName));
    }

    default public UpdateResult updateMulti(Query query, Update update, Class<?> entityClass, String collectionName) {
        return (UpdateResult)this.getInvoker().invoke(() -> this.getImpl().updateMulti(query, update, entityClass, collectionName));
    }

    default public DeleteResult remove(Object object) {
        return (DeleteResult)this.getInvoker().invoke(() -> this.getImpl().remove(object));
    }

    default public DeleteResult remove(Object object, String collectionName) {
        return (DeleteResult)this.getInvoker().invoke(() -> this.getImpl().remove(object, collectionName));
    }

    default public DeleteResult remove(Query query, String collectionName) {
        return (DeleteResult)this.getInvoker().invoke(() -> this.getImpl().remove(query, collectionName));
    }

    default public DeleteResult remove(Query query, Class<?> entityClass) {
        return (DeleteResult)this.getInvoker().invoke(() -> this.getImpl().remove(query, entityClass));
    }

    default public DeleteResult remove(Query query, Class<?> entityClass, String collectionName) {
        return (DeleteResult)this.getInvoker().invoke(() -> this.getImpl().remove(query, entityClass, collectionName));
    }

    default public <T> List<T> findAll(Class<T> entityClass) {
        return (List)this.getInvoker().invoke(() -> this.getImpl().findAll(entityClass));
    }

    default public <T> List<T> findAll(Class<T> entityClass, String collectionName) {
        return (List)this.getInvoker().invoke(() -> this.getImpl().findAll(entityClass, collectionName));
    }

    default public <T> MapReduceResults<T> mapReduce(String inputCollectionName, String mapFunction, String reduceFunction, Class<T> entityClass) {
        return (MapReduceResults)this.getInvoker().invoke(() -> this.getImpl().mapReduce(inputCollectionName, mapFunction, reduceFunction, entityClass));
    }

    default public <T> MapReduceResults<T> mapReduce(String inputCollectionName, String mapFunction, String reduceFunction, MapReduceOptions mapReduceOptions, Class<T> entityClass) {
        return (MapReduceResults)this.getInvoker().invoke(() -> this.getImpl().mapReduce(inputCollectionName, mapFunction, reduceFunction, mapReduceOptions, entityClass));
    }

    default public <T> MapReduceResults<T> mapReduce(Query query, String inputCollectionName, String mapFunction, String reduceFunction, Class<T> entityClass) {
        return (MapReduceResults)this.getInvoker().invoke(() -> this.getImpl().mapReduce(query, inputCollectionName, mapFunction, reduceFunction, entityClass));
    }

    default public <T> MapReduceResults<T> mapReduce(Query query, String inputCollectionName, String mapFunction, String reduceFunction, MapReduceOptions mapReduceOptions, Class<T> entityClass) {
        return (MapReduceResults)this.getInvoker().invoke(() -> this.getImpl().mapReduce(query, inputCollectionName, mapFunction, reduceFunction, mapReduceOptions, entityClass));
    }

    default public <T> GroupByResults<T> group(String inputCollectionName, GroupBy groupBy, Class<T> entityClass) {
        return (GroupByResults)this.getInvoker().invoke(() -> this.getImpl().group(inputCollectionName, groupBy, entityClass));
    }

    default public <T> GroupByResults<T> group(Criteria criteria, String inputCollectionName, GroupBy groupBy, Class<T> entityClass) {
        return (GroupByResults)this.getInvoker().invoke(() -> this.getImpl().group(criteria, inputCollectionName, groupBy, entityClass));
    }

    default public <O> AggregationResults<O> aggregate(TypedAggregation<?> aggregation, Class<O> outputType) {
        return (AggregationResults)this.getInvoker().invoke(() -> this.getImpl().aggregate(aggregation, outputType));
    }

    default public <O> AggregationResults<O> aggregate(TypedAggregation<?> aggregation, String inputCollectionName, Class<O> outputType) {
        return (AggregationResults)this.getInvoker().invoke(() -> this.getImpl().aggregate(aggregation, inputCollectionName, outputType));
    }

    default public <O> AggregationResults<O> aggregate(Aggregation aggregation, Class<?> inputType, Class<O> outputType) {
        return (AggregationResults)this.getInvoker().invoke(() -> this.getImpl().aggregate(aggregation, inputType, outputType));
    }

    default public <O> AggregationResults<O> aggregate(Aggregation aggregation, String collectionName, Class<O> outputType) {
        return (AggregationResults)this.getInvoker().invoke(() -> this.getImpl().aggregate(aggregation, collectionName, outputType));
    }

    default public <O> CloseableIterator<O> aggregateStream(TypedAggregation<?> aggregation, String inputCollectionName, Class<O> outputType) {
        return new CloseableIteratorDecoratorImpl((CloseableIterator)this.getInvoker().invoke(() -> this.getImpl().aggregateStream(aggregation, inputCollectionName, outputType)), this.getInvoker());
    }

    default public <O> CloseableIterator<O> aggregateStream(TypedAggregation<?> aggregation, Class<O> outputType) {
        return new CloseableIteratorDecoratorImpl((CloseableIterator)this.getInvoker().invoke(() -> this.getImpl().aggregateStream(aggregation, outputType)), this.getInvoker());
    }

    default public <O> CloseableIterator<O> aggregateStream(Aggregation aggregation, Class<?> inputType, Class<O> outputType) {
        return new CloseableIteratorDecoratorImpl((CloseableIterator)this.getInvoker().invoke(() -> this.getImpl().aggregateStream(aggregation, inputType, outputType)), this.getInvoker());
    }

    default public <O> CloseableIterator<O> aggregateStream(Aggregation aggregation, String collectionName, Class<O> outputType) {
        return new CloseableIteratorDecoratorImpl((CloseableIterator)this.getInvoker().invoke(() -> this.getImpl().aggregateStream(aggregation, collectionName, outputType)), this.getInvoker());
    }

    default public <T> List<T> findAllAndRemove(Query query, String collectionName) {
        return (List)this.getInvoker().invoke(() -> this.getImpl().findAllAndRemove(query, collectionName));
    }

    default public <T> List<T> findAllAndRemove(Query query, Class<T> entityClass) {
        return (List)this.getInvoker().invoke(() -> this.getImpl().findAllAndRemove(query, entityClass));
    }

    default public <T> List<T> findAllAndRemove(Query query, Class<T> entityClass, String collectionName) {
        return (List)this.getInvoker().invoke(() -> this.getImpl().findAllAndRemove(query, entityClass, collectionName));
    }

    default public <T> ExecutableFindOperation.ExecutableFind<T> query(Class<T> domainType) {
        return (ExecutableFindOperation.ExecutableFind)this.getInvoker().invoke(() -> this.getImpl().query(domainType));
    }

    default public <T> ExecutableUpdateOperation.ExecutableUpdate<T> update(Class<T> domainType) {
        return (ExecutableUpdateOperation.ExecutableUpdate)this.getInvoker().invoke(() -> this.getImpl().update(domainType));
    }

    default public <T> ExecutableRemoveOperation.ExecutableRemove<T> remove(Class<T> domainType) {
        return (ExecutableRemoveOperation.ExecutableRemove)this.getInvoker().invoke(() -> this.getImpl().remove(domainType));
    }

    default public <T> ExecutableAggregationOperation.ExecutableAggregation<T> aggregateAndReturn(Class<T> domainType) {
        return (ExecutableAggregationOperation.ExecutableAggregation)this.getInvoker().invoke(() -> this.getImpl().aggregateAndReturn(domainType));
    }

    default public <T> ExecutableInsertOperation.ExecutableInsert<T> insert(Class<T> domainType) {
        return (ExecutableInsertOperation.ExecutableInsert)this.getInvoker().invoke(() -> this.getImpl().insert(domainType));
    }

    default public Set<String> getCollectionNames() {
        return (Set)this.getInvoker().invoke(() -> this.getImpl().getCollectionNames());
    }

    default public <T> List<T> findDistinct(Query query, String field, Class<?> entityClass, Class<T> resultClass) {
        return (List)this.getInvoker().invoke(() -> this.getImpl().findDistinct(query, field, entityClass, resultClass));
    }

    default public <T> List<T> findDistinct(Query query, String field, String collectionName, Class<?> entityClass, Class<T> resultClass) {
        return (List)this.getInvoker().invoke(() -> this.getImpl().findDistinct(query, field, collectionName, entityClass, resultClass));
    }

    default public <S, T> T findAndReplace(Query query, S replacement, FindAndReplaceOptions options, Class<S> entityType, String collectionName, Class<T> resultType) {
        return (T)this.getInvoker().invoke(() -> this.getImpl().findAndReplace(query, replacement, options, entityType, collectionName, resultType));
    }

    default public <T> ExecutableMapReduceOperation.MapReduceWithMapFunction<T> mapReduce(Class<T> domainType) {
        return (ExecutableMapReduceOperation.MapReduceWithMapFunction)this.getInvoker().invoke(() -> new MapReduceWithMapFunctionDecoratorImpl(this.getImpl().mapReduce(domainType), this.getInvoker()));
    }

    default public MongoOperations withSession(ClientSession session) {
        return new MongoOperationsDecoratorImpl((MongoOperations)this.getInvoker().invoke(() -> this.getImpl().withSession(session)), this.getInvoker());
    }

    default public IndexOperations indexOps(String collectionName) {
        return (IndexOperations)this.getInvoker().invoke(() -> new IndexOperationsDecoratorImpl(this.getImpl().indexOps(collectionName), this.getInvoker()));
    }

    default public IndexOperations indexOps(Class<?> entityClass) {
        return (IndexOperations)this.getInvoker().invoke(() -> new IndexOperationsDecoratorImpl(this.getImpl().indexOps(entityClass), this.getInvoker()));
    }

    default public BulkOperations bulkOps(BulkOperations.BulkMode mode, String collectionName) {
        return new BulkOperationsDecoratorImpl((BulkOperations)this.getInvoker().invoke(() -> this.getImpl().bulkOps(mode, collectionName)), this.getInvoker());
    }

    default public BulkOperations bulkOps(BulkOperations.BulkMode mode, Class<?> entityType) {
        return new BulkOperationsDecoratorImpl((BulkOperations)this.getInvoker().invoke(() -> this.getImpl().bulkOps(mode, entityType)), this.getInvoker());
    }

    default public BulkOperations bulkOps(BulkOperations.BulkMode mode, Class<?> entityType, String collectionName) {
        return new BulkOperationsDecoratorImpl((BulkOperations)this.getInvoker().invoke(() -> this.getImpl().bulkOps(mode, entityType, collectionName)), this.getInvoker());
    }

    default public ScriptOperations scriptOps() {
        return new ScriptOperationsDecoratorImpl((ScriptOperations)this.getInvoker().invoke(() -> this.getImpl().scriptOps()), this.getInvoker());
    }

    default public SessionScoped withSession(ClientSessionOptions sessionOptions) {
        return this.getImpl().withSession(sessionOptions);
    }

    default public SessionScoped withSession(Supplier<ClientSession> sessionProvider) {
        return null;
    }
}

