/*
 * Decompiled with CFR 0.152.
 */
package com.github.cloudyrock.mongock;

import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.context.annotation.Profile;
import org.springframework.util.StringUtils;

final class ProfileUtil {
    private ProfileUtil() {
    }

    static boolean isNegativeProfile(String profile) {
        return profile.charAt(0) == '!';
    }

    static boolean containsProfile(List<String> activeProfiles, String profile) {
        return activeProfiles.contains(profile);
    }

    static boolean containsNegativeProfile(List<String> activeProfiles, String profile) {
        return ProfileUtil.containsProfile(activeProfiles, profile.substring(1));
    }

    static boolean matchesActiveSpringProfile(List<String> activeProfiles, AnnotatedElement element) {
        if (!element.isAnnotationPresent(Profile.class)) {
            return true;
        }
        boolean containsActiveProfile = false;
        for (String profile : element.getAnnotation(Profile.class).value()) {
            if (StringUtils.isEmpty((Object)profile)) continue;
            if (ProfileUtil.isNegativeProfile(profile)) {
                if (!ProfileUtil.containsNegativeProfile(activeProfiles, profile)) continue;
                return false;
            }
            containsActiveProfile = true;
            if (!ProfileUtil.containsProfile(activeProfiles, profile)) continue;
            return true;
        }
        return !containsActiveProfile;
    }

    static <T extends AnnotatedElement> List<T> filterByActiveProfiles(List<String> activeProfiles, Collection<T> annotated) {
        ArrayList<AnnotatedElement> filtered = new ArrayList<AnnotatedElement>();
        for (AnnotatedElement element : annotated) {
            if (!ProfileUtil.matchesActiveSpringProfile(activeProfiles, element)) continue;
            filtered.add(element);
        }
        return filtered;
    }
}

