/*
 * Decompiled with CFR 0.152.
 */
package com.github.cloudyrock.mongock;

import com.github.cloudyrock.mongock.ChangeEntryRepository;
import com.github.cloudyrock.mongock.ChangeService;
import com.github.cloudyrock.mongock.LockChecker;
import com.github.cloudyrock.mongock.Mongock;
import java.util.Optional;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.context.ApplicationContext;
import org.springframework.data.mongodb.core.MongoTemplate;

public class SpringBootMongock
extends Mongock
implements ApplicationRunner {
    private static final Logger logger = LoggerFactory.getLogger(SpringBootMongock.class);
    private ApplicationContext springContext;
    @Deprecated
    private MongoTemplate mongoTemplateProxy;
    @Deprecated
    private Supplier<MongoTemplate> mongoTemplateSupplier;

    SpringBootMongock(ChangeEntryRepository changeEntryRepository, ChangeService changeService, LockChecker lockChecker) {
        super(changeEntryRepository, changeService, lockChecker);
    }

    public void run(ApplicationArguments args) {
        this.execute();
    }

    protected Optional<Object> getDependency(Class dependencyType) {
        Optional dependencyFromParent = super.getDependency(dependencyType);
        if (dependencyFromParent.isPresent()) {
            return dependencyFromParent;
        }
        if (MongoTemplate.class.isAssignableFrom(dependencyType)) {
            logger.warn("[DEPRECATION] Use MongockTemplate instead of MongoTemplate. MongoTemplate in changeLogs is deprecated(will be removed in next major release)");
            return Optional.ofNullable(this.getMongoTemplateProxy());
        }
        if (this.springContext != null) {
            return Optional.of(this.springContext.getBean(dependencyType));
        }
        return Optional.empty();
    }

    SpringBootMongock springContext(ApplicationContext springContext) {
        this.springContext = springContext;
        return this;
    }

    @Deprecated
    private synchronized MongoTemplate getMongoTemplateProxy() {
        if (this.mongoTemplateProxy == null) {
            this.mongoTemplateProxy = this.mongoTemplateSupplier.get();
        }
        return this.mongoTemplateProxy;
    }

    @Deprecated
    void setMongoTemplateSupplier(Supplier<MongoTemplate> mongoTemplateSupplier) {
        this.mongoTemplateSupplier = mongoTemplateSupplier;
    }
}

