/*
 * Decompiled with CFR 0.152.
 */
package com.github.cloudyrock.mongock;

import com.github.cloudyrock.mongock.ChangeEntryRepository;
import com.github.cloudyrock.mongock.ChangeService;
import com.github.cloudyrock.mongock.LockChecker;
import com.github.cloudyrock.mongock.Mongock;
import java.util.Optional;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.data.mongodb.core.MongoTemplate;

public class SpringMongock
extends Mongock
implements InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger(SpringMongock.class);
    @Deprecated
    private MongoTemplate mongoTemplateProxy;
    @Deprecated
    private Supplier<MongoTemplate> mongoTemplateSupplier;

    SpringMongock(ChangeEntryRepository changeEntryRepository, ChangeService changeService, LockChecker lockChecker) {
        super(changeEntryRepository, changeService, lockChecker);
    }

    public void afterPropertiesSet() {
        this.execute();
    }

    protected Optional<Object> getDependency(Class dependencyType) {
        Optional dependencyFromParent = super.getDependency(dependencyType);
        if (dependencyFromParent.isPresent()) {
            return dependencyFromParent;
        }
        if (MongoTemplate.class.isAssignableFrom(dependencyType)) {
            logger.warn("[DEPRECATION] Use MongockTemplate instead of MongoTemplate. MongoTemplate in changeLogs is deprecated(will be removed in next major release)");
            return Optional.ofNullable(this.getMongoTemplateProxy());
        }
        return Optional.empty();
    }

    @Deprecated
    private synchronized MongoTemplate getMongoTemplateProxy() {
        if (this.mongoTemplateProxy == null) {
            this.mongoTemplateProxy = this.mongoTemplateSupplier.get();
        }
        return this.mongoTemplateProxy;
    }

    @Deprecated
    void setMongoTemplateSupplier(Supplier<MongoTemplate> mongoTemplateSupplier) {
        this.mongoTemplateSupplier = mongoTemplateSupplier;
    }
}

