/*
 * Decompiled with CFR 0.152.
 */
package com.github.cloudyrock.mongock;

import com.github.cloudyrock.mongock.ChangeService;
import com.github.cloudyrock.mongock.Mongock;
import com.github.cloudyrock.mongock.MongockBuilderBase;
import com.github.cloudyrock.mongock.MongockException;
import com.github.cloudyrock.mongock.SpringChangeService;
import com.github.cloudyrock.mongock.StringUtils;
import com.github.cloudyrock.mongock.decorator.impl.MongoTemplateDecoratorImpl;
import com.github.cloudyrock.mongock.decorator.impl.MongockTemplate;
import com.github.cloudyrock.mongock.decorator.util.MethodInvoker;
import com.github.cloudyrock.mongock.decorator.util.VoidSupplier;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoDatabase;
import java.util.function.Supplier;
import org.springframework.core.env.Environment;
import org.springframework.data.mongodb.core.MongoTemplate;

abstract class SpringMongockBuilderBase<BUILDER_TYPE extends SpringMongockBuilderBase, MONGOCK_TYPE extends Mongock>
extends MongockBuilderBase<BUILDER_TYPE, MONGOCK_TYPE> {
    private Environment springEnvironment = null;
    private final MongoTemplate template;

    @Deprecated
    SpringMongockBuilderBase(com.mongodb.MongoClient legacyMongoClient, String databaseName, String changeLogsScanPackage) {
        super(legacyMongoClient, databaseName, changeLogsScanPackage);
        this.template = null;
    }

    @Deprecated
    SpringMongockBuilderBase(MongoClient newMongoClient, String databaseName, String changeLogsScanPackage) {
        super(newMongoClient, databaseName, changeLogsScanPackage);
        this.template = null;
    }

    SpringMongockBuilderBase(MongoTemplate template, String changeLogsScanPackage) {
        super((MongoClient)null, template.getDb().getName(), changeLogsScanPackage);
        this.template = template;
    }

    MongoDatabase getMongoDatabase() {
        if (this.template != null) {
            return this.template.getDb();
        }
        if (this.mongoClient != null) {
            return this.mongoClient.getDatabase(this.databaseName);
        }
        return this.legacyMongoClient.getDatabase(this.databaseName);
    }

    void validateMandatoryFields() throws MongockException {
        if (this.legacyMongoClient == null && this.mongoClient == null && this.template == null) {
            throw new MongockException("MongoClient cannot be null");
        }
        if (!StringUtils.hasText((String)this.databaseName)) {
            throw new MongockException("DB name is not set. It should be defined in MongoDB URI or via setter");
        }
        if (!StringUtils.hasText((String)this.changeLogsScanPackage)) {
            throw new MongockException("Scan package for changelogs is not set: use appropriate setter");
        }
    }

    public BUILDER_TYPE setSpringEnvironment(Environment springEnvironment) {
        this.springEnvironment = springEnvironment;
        return (BUILDER_TYPE)((Object)((SpringMongockBuilderBase)this.returnInstance()));
    }

    Environment getSpringEnvironment() {
        return this.springEnvironment;
    }

    protected final ChangeService createChangeServiceInstance() {
        SpringChangeService changeService = new SpringChangeService();
        changeService.setEnvironment(this.springEnvironment);
        return changeService;
    }

    final MongockTemplate getMongockTemplate() {
        return new MongockTemplate(this.template, this.methodInvoker);
    }

    @Deprecated
    Supplier<MongoTemplate> getMongoTemplateProxySupplier() {
        return () -> {
            MongoTemplateDecoratorImpl.setDefaultMethodInvoker(new MethodInvoker(){

                public <T> T invoke(Supplier<T> supplier) {
                    SpringMongockBuilderBase.this.lockChecker.acquireLockDefault();
                    return supplier.get();
                }

                public void invoke(VoidSupplier supplier) {
                    SpringMongockBuilderBase.this.lockChecker.acquireLockDefault();
                    supplier.execute();
                }
            });
            if (this.template != null) {
                return new MongoTemplateDecoratorImpl(this.template.getMongoDbFactory(), this.template.getConverter(), this.methodInvoker);
            }
            if (this.mongoClient != null) {
                return new MongoTemplateDecoratorImpl(this.mongoClient, this.databaseName, this.methodInvoker);
            }
            return new MongoTemplateDecoratorImpl(this.legacyMongoClient, this.databaseName, this.methodInvoker);
        };
    }
}

