/*
 * Decompiled with CFR 0.152.
 */
package com.github.cloudyrock.mongock.decorator;

import com.github.cloudyrock.mongock.decorator.impl.ClientSessionDecoratorImpl;
import com.github.cloudyrock.mongock.decorator.impl.SessionCallbackDecoratorImpl;
import com.github.cloudyrock.mongock.decorator.util.MethodInvoker;
import com.mongodb.client.ClientSession;
import java.util.function.Consumer;
import org.springframework.data.mongodb.core.SessionCallback;
import org.springframework.data.mongodb.core.SessionScoped;

public interface SessionScopedDecorator
extends SessionScoped {
    public SessionScoped getImpl();

    public MethodInvoker getInvoker();

    default public <T> T execute(SessionCallback<T> action, Consumer<ClientSession> doFinally) {
        SessionCallbackDecoratorImpl sessionCallback = new SessionCallbackDecoratorImpl(action, this.getInvoker());
        Consumer<ClientSession> consumer = clientSession -> {
            ClientSessionDecoratorImpl clientSessionDecorator = new ClientSessionDecoratorImpl((ClientSession)clientSession, this.getInvoker());
            doFinally.accept(clientSessionDecorator);
        };
        return (T)this.getInvoker().invoke(() -> this.getImpl().execute(sessionCallback, consumer));
    }
}

