/*
 * Decompiled with CFR 0.152.
 */
package com.github.cloudyrock.standalone.event;

import com.github.cloudyrock.mongock.runner.core.event.EventPublisher;
import com.github.cloudyrock.mongock.runner.core.event.MigrationResult;
import com.github.cloudyrock.standalone.event.StandaloneMigrationFailureEvent;
import com.github.cloudyrock.standalone.event.StandaloneMigrationSuccessEvent;
import java.util.function.Consumer;

public class StandaloneEventPublisher
implements EventPublisher {
    private final Runnable migrationStartedListener;
    private final Consumer<StandaloneMigrationSuccessEvent> migrationSuccessListener;
    private final Consumer<StandaloneMigrationFailureEvent> migrationFailedListener;

    public StandaloneEventPublisher(Runnable migrationStartedListener, Consumer<StandaloneMigrationSuccessEvent> migrationSuccessListener, Consumer<StandaloneMigrationFailureEvent> migrationFailedListener) {
        this.migrationSuccessListener = migrationSuccessListener;
        this.migrationFailedListener = migrationFailedListener;
        this.migrationStartedListener = migrationStartedListener;
    }

    public void publishMigrationStarted() {
        if (this.migrationStartedListener != null) {
            this.migrationStartedListener.run();
        }
    }

    public void publishMigrationSuccessEvent(MigrationResult migrationResult) {
        if (this.migrationSuccessListener != null) {
            this.migrationSuccessListener.accept(new StandaloneMigrationSuccessEvent(migrationResult));
        }
    }

    public void publishMigrationFailedEvent(Exception ex) {
        if (this.migrationFailedListener != null) {
            this.migrationFailedListener.accept(new StandaloneMigrationFailureEvent(ex));
        }
    }
}

