/*
 * Decompiled with CFR 0.152.
 */
package com.github.cloudyrock.mongock.driver.mongodb.sync.v4.repository;

import com.github.cloudyrock.mongock.driver.mongodb.sync.v4.repository.MongoSync4RepositoryBase;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Filters;
import io.changock.driver.api.entry.ChangeEntry;
import io.changock.driver.api.entry.ChangeState;
import io.changock.driver.core.entry.ChangeEntryRepository;
import io.changock.migration.api.exception.ChangockException;
import java.lang.reflect.Field;
import org.bson.Document;
import org.bson.conversions.Bson;

public class MongoSync4ChangeEntryRepository<CHANGE_ENTRY extends ChangeEntry>
extends MongoSync4RepositoryBase<CHANGE_ENTRY>
implements ChangeEntryRepository<CHANGE_ENTRY, Document> {
    private static String KEY_EXECUTION_ID;
    private static String KEY_CHANGE_ID;
    private static String KEY_STATE;
    private static String KEY_AUTHOR;

    public MongoSync4ChangeEntryRepository(MongoCollection<Document> collection, boolean indexCreation) {
        super(collection, new String[]{KEY_EXECUTION_ID, KEY_AUTHOR, KEY_CHANGE_ID}, indexCreation);
    }

    public boolean isAlreadyExecuted(String changeSetId, String author) throws ChangockException {
        Document entry = (Document)this.collection.find(this.buildSearchQueryDBObject(changeSetId, author)).first();
        return entry != null && !entry.isEmpty();
    }

    public void save(CHANGE_ENTRY changeEntry) throws ChangockException {
        this.collection.insertOne(this.toEntity(changeEntry));
    }

    protected Bson buildSearchQueryDBObject(String changeSetId, String author) {
        Bson executedStateOrNoExisting = Filters.or((Bson[])new Bson[]{Filters.eq((String)KEY_STATE, (Object)ChangeState.EXECUTED.name()), Filters.eq((String)KEY_STATE, null), Filters.exists((String)KEY_STATE, (boolean)false)});
        return Filters.and((Bson[])new Bson[]{Filters.eq((String)KEY_CHANGE_ID, (Object)changeSetId), Filters.eq((String)KEY_AUTHOR, (Object)author), executedStateOrNoExisting});
    }

    static {
        try {
            Field field = ChangeEntry.class.getDeclaredField("executionId");
            field.setAccessible(true);
            KEY_EXECUTION_ID = field.getAnnotation(io.changock.utils.field.Field.class).value();
            field = ChangeEntry.class.getDeclaredField("changeId");
            field.setAccessible(true);
            KEY_CHANGE_ID = field.getAnnotation(io.changock.utils.field.Field.class).value();
            field = ChangeEntry.class.getDeclaredField("state");
            field.setAccessible(true);
            KEY_STATE = field.getAnnotation(io.changock.utils.field.Field.class).value();
            field = ChangeEntry.class.getDeclaredField("author");
            field.setAccessible(true);
            KEY_AUTHOR = field.getAnnotation(io.changock.utils.field.Field.class).value();
        }
        catch (NoSuchFieldException e) {
            throw new ChangockException((Exception)e);
        }
    }
}

