/*
 * Decompiled with CFR 0.152.
 */
package com.github.cm.heclouds.adapter.protocolhub.tcp;

import com.github.cm.heclouds.adapter.core.logging.ILogger;
import com.github.cm.heclouds.adapter.core.logging.LoggerFormat;
import com.github.cm.heclouds.adapter.protocolhub.tcp.config.TcpProtocolHubConfig;
import com.github.cm.heclouds.adapter.protocolhub.tcp.config.TcpProtocolHubConfigUtils;
import com.github.cm.heclouds.adapter.protocolhub.tcp.handler.TcpProtocolHubHandler;
import com.github.cm.heclouds.adapter.protocolhub.tcp.handler.TcpServerHandler;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.internal.StringUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

final class NettyAcceptor {
    private final ILogger logger;
    private final TcpProtocolHubConfig config;
    private final List<EventLoopGroup> eventLoopGroups = new ArrayList<EventLoopGroup>();

    NettyAcceptor(TcpProtocolHubConfig config) {
        this.config = config;
        this.logger = this.config.getLogger();
    }

    void initialize() {
        Executors.newSingleThreadExecutor().execute(() -> {
            long beginTime = System.currentTimeMillis();
            this.logger.logInnerInfo(TcpProtocolHubConfigUtils.getName(), LoggerFormat.Action.LAUNCH, "starting tcp protocol hub");
            this.logger.logInnerInfo(TcpProtocolHubConfigUtils.getName(), LoggerFormat.Action.LAUNCH, this.config.toString());
            try {
                this.initializeProtocolHub(this.config);
                BigDecimal b = new BigDecimal((System.currentTimeMillis() - beginTime) / 1000L);
                double time = b.setScale(2, 4).doubleValue();
                this.logger.logInnerInfo(TcpProtocolHubConfigUtils.getName(), LoggerFormat.Action.LAUNCH, "started tcp protocol hub in " + time + " seconds, bind:" + this.config.getPort());
            }
            catch (Exception e) {
                this.logger.logProtocolHubError(TcpProtocolHubConfigUtils.getName(), LoggerFormat.Action.INIT, "failed:", (Throwable)e);
                System.exit(0);
            }
        });
    }

    private void initializeProtocolHub(TcpProtocolHubConfig config) throws InterruptedException {
        this.initializeTcpHub(config);
    }

    private void initializeTcpHub(final TcpProtocolHubConfig config) throws InterruptedException {
        String host = config.getHost();
        Integer port = config.getPort();
        ServerBootstrap bootstrap = this.configureTcpServerBootstrap();
        bootstrap.childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel ch) {
                ChannelPipeline pipeline = ch.pipeline();
                config.addChannelHandlers(pipeline);
                pipeline.addLast("tcpHandler", (ChannelHandler)TcpServerHandler.INSTANCE);
                pipeline.addLast("protocolHandler", (ChannelHandler)new TcpProtocolHubHandler(config));
            }
        });
        ChannelFuture f = StringUtil.isNullOrEmpty((String)host) ? bootstrap.bind(port.intValue()) : bootstrap.bind(host, port.intValue());
        f.sync().addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
    }

    private ServerBootstrap configureTcpServerBootstrap() {
        Class<EpollServerSocketChannel> channelClass;
        EpollEventLoopGroup workerGroup;
        EpollEventLoopGroup bossGroup;
        if (Epoll.isAvailable()) {
            bossGroup = new EpollEventLoopGroup();
            workerGroup = new EpollEventLoopGroup();
            channelClass = EpollServerSocketChannel.class;
        } else {
            bossGroup = new NioEventLoopGroup();
            workerGroup = new NioEventLoopGroup();
            channelClass = NioServerSocketChannel.class;
        }
        this.eventLoopGroups.add((EventLoopGroup)bossGroup);
        this.eventLoopGroups.add((EventLoopGroup)workerGroup);
        ServerBootstrap b = new ServerBootstrap();
        ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)b.group((EventLoopGroup)bossGroup, (EventLoopGroup)workerGroup).channel(channelClass)).option(ChannelOption.SO_BACKLOG, (Object)1000000)).option(ChannelOption.SO_REUSEADDR, (Object)true)).childOption(ChannelOption.TCP_NODELAY, (Object)true).childOption(ChannelOption.SO_KEEPALIVE, (Object)false).childOption(ChannelOption.AUTO_READ, (Object)false);
        return b;
    }

    void close() {
        for (EventLoopGroup group : this.eventLoopGroups) {
            if (group == null) {
                throw new IllegalStateException("Invoked close on an Acceptor that wasn't initialized");
            }
            Future waiter = group.shutdownGracefully();
            try {
                waiter.await(10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (group.isTerminated()) continue;
            group.shutdownGracefully(0L, 0L, TimeUnit.MILLISECONDS);
        }
    }
}

