/*
 * Decompiled with CFR 0.152.
 */
package com.github.cm.heclouds.adapter.protocolhub.tcp;

import com.github.cm.heclouds.adapter.core.logging.ILogger;
import com.github.cm.heclouds.adapter.core.logging.LoggerFormat;
import com.github.cm.heclouds.adapter.protocolhub.tcp.NettyAcceptor;
import com.github.cm.heclouds.adapter.protocolhub.tcp.config.TcpProtocolHubConfig;
import com.github.cm.heclouds.adapter.protocolhub.tcp.config.TcpProtocolHubConfigUtils;

public final class TcpProtocolHubService {
    private final ILogger logger;
    private final NettyAcceptor acceptor;

    public TcpProtocolHubService(TcpProtocolHubConfig config) {
        this.logger = config.getLogger();
        this.acceptor = new NettyAcceptor(config);
    }

    public void start() {
        try {
            this.acceptor.initialize();
        }
        catch (Exception e) {
            this.logger.logProtocolHubError(TcpProtocolHubConfigUtils.getName(), LoggerFormat.Action.INIT, "failed", (Throwable)e);
            System.exit(1);
        }
    }

    public void stop() {
        if (this.acceptor != null) {
            this.acceptor.close();
        }
    }
}

