/*
 * Decompiled with CFR 0.152.
 */
package com.github.cm.heclouds.adapter.protocolhub.tcp.api;

import com.github.cm.heclouds.adapter.core.entity.Device;
import com.github.cm.heclouds.adapter.core.logging.ILogger;
import com.github.cm.heclouds.adapter.core.logging.LoggerFormat;
import com.github.cm.heclouds.adapter.protocolhub.tcp.config.TcpProtocolHubConfigUtils;
import com.github.cm.heclouds.adapter.protocolhub.tcp.session.TcpDeviceSession;
import com.github.cm.heclouds.adapter.protocolhub.tcp.session.TcpDeviceSessionManager;
import io.netty.channel.Channel;

public final class TcpDeviceDownLinkApi {
    private final ILogger logger = TcpProtocolHubConfigUtils.getLogger();

    public boolean pushToDevice(Device device, Object data) {
        String deviceName;
        String productId = device.getProductId();
        TcpDeviceSession deviceSession = TcpDeviceSessionManager.getDeviceSession(productId, deviceName = device.getDeviceName());
        if (deviceSession == null || deviceSession.getChannel() == null) {
            this.logger.logDevWarn(TcpProtocolHubConfigUtils.getName(), LoggerFormat.Action.GW_DOWN_LINK, productId, deviceName, "push to device failed dut to null device session");
            return false;
        }
        Channel channel = deviceSession.getChannel();
        if (!channel.isActive()) {
            this.logger.logDevWarn(TcpProtocolHubConfigUtils.getName(), LoggerFormat.Action.GW_DOWN_LINK, productId, deviceName, "push to device failed due to inactive channel");
            return false;
        }
        channel.writeAndFlush(data);
        this.logger.logDevInfo(TcpProtocolHubConfigUtils.getName(), LoggerFormat.Action.GW_DOWN_LINK, productId, deviceName, "push to device");
        return true;
    }

    public boolean logoutDevice(Device device) {
        String deviceName;
        String productId = device.getProductId();
        TcpDeviceSession deviceSession = TcpDeviceSessionManager.getDeviceSession(productId, deviceName = device.getDeviceName());
        if (deviceSession == null) {
            return true;
        }
        Channel channel = deviceSession.getChannel();
        if (channel == null || !channel.isActive()) {
            return true;
        }
        channel.close();
        return false;
    }
}

