/*
 * Decompiled with CFR 0.152.
 */
package com.github.cm.heclouds.adapter.protocolhub.tcp.config;

import com.github.cm.heclouds.adapter.core.config.CoreConfig;
import com.github.cm.heclouds.adapter.core.logging.ILogger;
import com.github.cm.heclouds.adapter.core.logging.LoggerFormat;
import com.github.cm.heclouds.adapter.core.utils.CoreConfigUtils;
import com.github.cm.heclouds.adapter.protocolhub.tcp.TcpProtocolHubService;
import com.github.cm.heclouds.adapter.protocolhub.tcp.config.ITcpConfig;
import com.github.cm.heclouds.adapter.protocolhub.tcp.config.TcpProtocolHubConfigUtils;
import com.github.cm.heclouds.adapter.protocolhub.tcp.custom.TcpDeviceUpLinkHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.util.internal.StringUtil;

public abstract class TcpProtocolHubConfig {
    public static final String DEFAULT_NAME = "TCPHub";
    private static final Integer DEFAULT_PORT = 10086;
    private final ILogger logger;
    private String name = "TCPHub";
    private String host;
    private Integer port = DEFAULT_PORT;
    private TcpDeviceUpLinkHandler tcpDeviceUpLinkHandler;

    public abstract void addChannelHandlers(ChannelPipeline var1);

    public TcpProtocolHubConfig(ILogger logger) {
        this.logger = logger;
        if (CoreConfigUtils.getCoreConfig() == null) {
            CoreConfigUtils.setCoreConfig((CoreConfig)new CoreConfig(this.logger));
        }
        TcpProtocolHubConfigUtils.setConfig(this);
    }

    public void init() {
        new TcpProtocolHubService(this).start();
    }

    public TcpProtocolHubConfig tcpProtocolHubConfig(ITcpConfig tcpConfig) {
        this.name = StringUtil.isNullOrEmpty((String)tcpConfig.getName()) ? this.name : tcpConfig.getName();
        this.host = tcpConfig.getHost();
        this.port = tcpConfig.getPort();
        return this;
    }

    public TcpProtocolHubConfig name(String name) {
        this.name = name;
        return this;
    }

    public TcpProtocolHubConfig host(String host) {
        this.host = host;
        return this;
    }

    public TcpProtocolHubConfig port(Integer port) {
        this.port = port;
        return this;
    }

    public TcpProtocolHubConfig tcpDeviceUpLinkHandler(TcpDeviceUpLinkHandler tcpDeviceUpLinkHandler) {
        this.tcpDeviceUpLinkHandler = tcpDeviceUpLinkHandler;
        return this;
    }

    public ILogger getLogger() {
        return this.logger;
    }

    public String getName() {
        return this.name;
    }

    public String getHost() {
        return this.host;
    }

    public Integer getPort() {
        if (this.port == null) {
            this.port = DEFAULT_PORT;
            this.logger.logInnerWarn(this.name, LoggerFormat.Action.INIT, "config 'port' is not set, using default value: " + DEFAULT_PORT);
        }
        return this.port;
    }

    public TcpDeviceUpLinkHandler getTcpDeviceUpLinkHandler() {
        if (this.tcpDeviceUpLinkHandler == null) {
            String desc = "TcpDeviceUpLinkHandler is not configured!";
            this.logger.logInnerError(this.name, LoggerFormat.Action.INIT, desc, null);
            System.exit(0);
        }
        return this.tcpDeviceUpLinkHandler;
    }

    public String toString() {
        return "TcpProtocolHubConfig{name='" + this.name + '\'' + ", host='" + this.host + '\'' + ", port=" + this.port + '}';
    }
}

