/*
 * Decompiled with CFR 0.152.
 */
package com.github.cm.heclouds.adapter.protocolhub.tcp.config;

import com.github.cm.heclouds.adapter.core.exceptions.IllegalConfigException;
import com.github.cm.heclouds.adapter.core.logging.ILogger;
import com.github.cm.heclouds.adapter.core.utils.CoreConfigUtils;
import com.github.cm.heclouds.adapter.protocolhub.tcp.config.TcpProtocolHubConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TcpProtocolHubConfigUtils {
    private static final Logger log = LoggerFactory.getLogger(TcpProtocolHubConfigUtils.class);
    private static TcpProtocolHubConfig config;

    public static TcpProtocolHubConfig getConfig() {
        if (config == null) {
            throw new IllegalConfigException("Config is null, please init Config first");
        }
        return config;
    }

    public static void setConfig(TcpProtocolHubConfig config) {
        TcpProtocolHubConfigUtils.config = config;
    }

    public static String getName() {
        try {
            return config.getName();
        }
        catch (Exception e) {
            log.error("cannot get name", (Throwable)e);
            System.exit(1);
            return null;
        }
    }

    public static ILogger getLogger() {
        try {
            return CoreConfigUtils.getLogger();
        }
        catch (Exception e) {
            log.error("cannot get ILogger", (Throwable)e);
            System.exit(1);
            return null;
        }
    }
}

