/*
 * Decompiled with CFR 0.152.
 */
package com.github.cm.heclouds.adapter.protocolhub.tcp.config.fileconfig;

import com.github.cm.heclouds.adapter.core.utils.FileConfigUtil;
import com.github.cm.heclouds.adapter.protocolhub.tcp.config.ITcpConfig;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import io.netty.util.internal.StringUtil;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class TcpFileConfig
implements ITcpConfig {
    private static volatile TcpFileConfig tcpConfig = null;
    private final ConcurrentMap<String, Object> configCache = new ConcurrentHashMap<String, Object>(100);
    private volatile Config config;
    private String configFilePath = "config/protocolhub-tcp.conf";

    private TcpFileConfig() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TcpFileConfig getInstance(String configFilePath) {
        if (tcpConfig != null) return tcpConfig;
        Class<TcpFileConfig> clazz = TcpFileConfig.class;
        synchronized (TcpFileConfig.class) {
            if (tcpConfig != null) return tcpConfig;
            tcpConfig = new TcpFileConfig();
            TcpFileConfig.tcpConfig.configFilePath = configFilePath;
            tcpConfig.initFileAdapterConfig();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return tcpConfig;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TcpFileConfig getInstance() {
        if (tcpConfig != null) return tcpConfig;
        Class<TcpFileConfig> clazz = TcpFileConfig.class;
        synchronized (TcpFileConfig.class) {
            if (tcpConfig != null) return tcpConfig;
            tcpConfig = new TcpFileConfig();
            tcpConfig.initFileAdapterConfig();
            // ** MonitorExit[var0] (shouldn't be in output)
            return tcpConfig;
        }
    }

    @Override
    public String getName() {
        return this.getString("name");
    }

    @Override
    public String getHost() {
        return this.getString("host");
    }

    @Override
    public Integer getPort() {
        return this.getInteger("port");
    }

    private String getString(String name) {
        if (this.configCache.containsKey(name)) {
            return (String)this.configCache.get(name);
        }
        String value = FileConfigUtil.getStringIfExists((Config)this.config, (String)name);
        if (!StringUtil.isNullOrEmpty((String)value)) {
            this.configCache.put(name, value);
        }
        return value;
    }

    private Integer getInteger(String name) {
        if (this.configCache.containsKey(name)) {
            return (Integer)this.configCache.get(name);
        }
        Integer value = FileConfigUtil.getIntegerIfExists((Config)this.config, (String)name);
        if (value != null) {
            this.configCache.put(name, value);
        }
        return value;
    }

    private void initFileAdapterConfig() {
        this.configCache.clear();
        this.config = ConfigFactory.load((String)this.configFilePath);
        this.config.checkValid(ConfigFactory.defaultReference(), new String[0]);
    }
}

