/*
 * Decompiled with CFR 0.152.
 */
package com.github.cm.heclouds.adapter.protocolhub.tcp.handler;

import com.github.cm.heclouds.adapter.core.consts.CloseReason;
import com.github.cm.heclouds.adapter.core.entity.Device;
import com.github.cm.heclouds.adapter.core.logging.ILogger;
import com.github.cm.heclouds.adapter.core.logging.LoggerFormat;
import com.github.cm.heclouds.adapter.core.utils.DeviceUtils;
import com.github.cm.heclouds.adapter.protocolhub.tcp.config.TcpProtocolHubConfig;
import com.github.cm.heclouds.adapter.protocolhub.tcp.config.TcpProtocolHubConfigUtils;
import com.github.cm.heclouds.adapter.protocolhub.tcp.custom.TcpDeviceUpLinkHandler;
import com.github.cm.heclouds.adapter.protocolhub.tcp.session.TcpDeviceSession;
import com.github.cm.heclouds.adapter.protocolhub.tcp.session.TcpDeviceSessionManager;
import com.github.cm.heclouds.adapter.protocolhub.tcp.session.TcpDeviceSessionNettyUtils;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import java.io.IOException;

public final class TcpProtocolHubHandler
extends ChannelDuplexHandler {
    private final Integer port;
    private final ILogger logger;
    private final TcpDeviceUpLinkHandler tcpDeviceUpLinkHandler;

    public TcpProtocolHubHandler(TcpProtocolHubConfig config) {
        this.port = config.getPort();
        this.logger = config.getLogger();
        this.tcpDeviceUpLinkHandler = config.getTcpDeviceUpLinkHandler();
    }

    public void channelActive(ChannelHandlerContext ctx) {
        this.logger.logInnerInfo(TcpProtocolHubConfigUtils.getName(), LoggerFormat.Action.RUNTIME, "address " + ctx.channel().remoteAddress().toString() + " is connected, tcp hub port: " + this.port);
        ctx.channel().read();
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        Channel channel = ctx.channel();
        Device device = TcpDeviceSessionNettyUtils.device(channel);
        if (device == null) {
            device = this.tcpDeviceUpLinkHandler.initDevice(msg, channel);
            if (device == null) {
                this.logger.logDevError(TcpProtocolHubConfigUtils.getName(), LoggerFormat.Action.DEV_UP_LINK, "init device failed", null, null, null);
            } else {
                this.logger.logInnerInfo(TcpProtocolHubConfigUtils.getName(), LoggerFormat.Action.RUNTIME, device + " is initialized, tcp hub port: " + this.port);
                TcpDeviceSession deviceSession = TcpDeviceSessionManager.createDeviceSession(device.getProductId(), device.getDeviceName(), channel);
                TcpDeviceSessionNettyUtils.setDeviceSession(channel, deviceSession);
                TcpDeviceSessionNettyUtils.setDevice(channel, device);
                TcpDeviceSessionManager.putDeviceSession(deviceSession);
            }
        } else {
            DeviceUtils.removeDeviceCloseReason((Device)device);
            this.tcpDeviceUpLinkHandler.processUpLinkData(device, msg, channel);
        }
        channel.read();
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        Channel channel = ctx.channel();
        TcpDeviceSession devSession = TcpDeviceSessionNettyUtils.deviceSession(channel);
        Device device = TcpDeviceSessionNettyUtils.device(channel);
        if (devSession == null || device == null) {
            return;
        }
        if (DeviceUtils.getDeviceCloseReason((Device)device) != CloseReason.CLOSE_BY_DEVICE_OFFLINE) {
            this.tcpDeviceUpLinkHandler.processConnectionLost(device, channel);
        }
        TcpDeviceSessionManager.handleConnectionLost(devSession);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        Device device = TcpDeviceSessionNettyUtils.device(ctx.channel());
        String pid = device == null ? null : device.getProductId();
        String deviceName = device == null ? null : device.getDeviceName();
        this.logger.logInnerWarn(TcpProtocolHubConfigUtils.getName(), LoggerFormat.Action.RUNTIME, pid, deviceName, "exceptionCaught: " + cause);
        if (!(cause instanceof IOException) && device != null) {
            DeviceUtils.setDeviceCloseReason((Device)device, (CloseReason)CloseReason.CLOSE_DUE_TO_UNKNOWN_EXCEPTION);
        }
        if (ctx.channel().isActive()) {
            ctx.close();
        }
    }
}

