/*
 * Decompiled with CFR 0.152.
 */
package com.github.cm.heclouds.adapter.protocolhub.tcp.session;

import com.github.cm.heclouds.adapter.core.entity.Device;
import com.github.cm.heclouds.adapter.core.logging.ILogger;
import com.github.cm.heclouds.adapter.core.logging.LoggerFormat;
import com.github.cm.heclouds.adapter.core.utils.DeviceUtils;
import com.github.cm.heclouds.adapter.protocolhub.tcp.config.TcpProtocolHubConfigUtils;
import com.github.cm.heclouds.adapter.protocolhub.tcp.session.TcpDeviceSession;
import io.netty.channel.Channel;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class TcpDeviceSessionManager {
    private static final ILogger LOGGER = TcpProtocolHubConfigUtils.getLogger();
    private static final ConcurrentMap<String, TcpDeviceSession> DEVICE_SESSION_POOL = new ConcurrentHashMap<String, TcpDeviceSession>();

    private TcpDeviceSessionManager() {
    }

    public static TcpDeviceSession createDeviceSession(String productId, String deviceName, Channel channel) {
        return TcpDeviceSession.newBuilder().productId(productId).deviceName(deviceName).channel(channel).build();
    }

    public static void putDeviceSession(TcpDeviceSession deviceSession) {
        DEVICE_SESSION_POOL.put(TcpDeviceSessionManager.genKey(deviceSession), deviceSession);
    }

    public static TcpDeviceSession getDeviceSession(String productId, String deviceName) {
        return (TcpDeviceSession)DEVICE_SESSION_POOL.get(productId + "-" + deviceName);
    }

    public static void handleConnectionLost(TcpDeviceSession deviceSession) {
        if (deviceSession != null) {
            Device device = Device.newBuilder().productId(deviceSession.getProductId()).deviceName(deviceSession.getDeviceName()).build();
            String reason = DeviceUtils.getDeviceCloseReason((Device)device).getValue();
            DeviceUtils.removeDeviceCloseReason((Device)device);
            TcpDeviceSessionManager.removeDeviceSession(deviceSession);
            LOGGER.logDevInfo(TcpProtocolHubConfigUtils.getName(), LoggerFormat.Action.DISCONNECT, deviceSession.getProductId(), deviceSession.getDeviceName(), reason);
        } else {
            LOGGER.logInnerWarn(TcpProtocolHubConfigUtils.getName(), LoggerFormat.Action.RUNTIME, "device connection lost without logging in");
        }
    }

    private static void removeDeviceSession(TcpDeviceSession deviceSession) {
        DEVICE_SESSION_POOL.remove(TcpDeviceSessionManager.genKey(deviceSession));
    }

    private static String genKey(TcpDeviceSession deviceSession) {
        return deviceSession.getProductId() + "-" + deviceSession.getDeviceName();
    }
}

