/*
 * Decompiled with CFR 0.152.
 */
package com.carlosdelachica.easyrecycleradapters.decorations;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.support.v7.widget.RecyclerView;
import android.view.View;

public class DividerItemDecoration
extends RecyclerView.ItemDecoration {
    private static final int[] ATTRS = new int[]{16843284};
    private Drawable divider;
    private int insets;
    private Context context;
    private boolean addInsets = false;

    public DividerItemDecoration(Context context, Drawable divider) {
        this.context = context;
        this.divider = divider;
    }

    public DividerItemDecoration(Context context) {
        this.context = context;
        TypedArray a = context.obtainStyledAttributes(ATTRS);
        this.divider = a.getDrawable(0);
        a.recycle();
    }

    public void setInsets(int insets) {
        this.addInsets = true;
        this.insets = this.context.getResources().getDimensionPixelSize(insets);
    }

    public void onDrawOver(Canvas canvas, RecyclerView parent, RecyclerView.State state) {
        this.drawHorizontal(canvas, parent);
        this.drawToTheRightOfEachChildren(canvas, parent);
    }

    public void drawHorizontal(Canvas c, RecyclerView parent) {
        int childCount = parent.getChildCount();
        if (childCount == 0) {
            return;
        }
        for (int i = 0; i < childCount; ++i) {
            View currentChild = parent.getChildAt(i);
            int left = currentChild.getLeft();
            int right = currentChild.getRight();
            int top = this.insets + currentChild.getBottom() + this.insets;
            int bottom = top + this.divider.getIntrinsicHeight();
            this.divider.setBounds(left, top, right, bottom);
            this.divider.draw(c);
        }
    }

    public void drawToTheRightOfEachChildren(Canvas c, RecyclerView parent) {
        if (parent.getChildCount() == 0) {
            return;
        }
        int childCount = parent.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View currentChild = parent.getChildAt(i);
            int top = currentChild.getTop();
            int bottom = currentChild.getBottom() + this.divider.getIntrinsicHeight();
            int left = currentChild.getRight() + this.insets;
            int right = left + this.divider.getIntrinsicWidth();
            this.divider.setBounds(left, top, right, bottom);
            this.divider.draw(c);
        }
    }

    public void getItemOffsets(Rect outRect, View view, RecyclerView parent, RecyclerView.State state) {
        if (this.addInsets) {
            outRect.set(this.insets, this.insets, this.insets, this.insets);
        }
    }
}

