/*
 * Decompiled with CFR 0.152.
 */
package com.carlosdelachica.easyrecycleradapters.fragment;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.TextView;
import com.carlosdelachica.easyrecycleradapters.R;
import com.carlosdelachica.easyrecycleradapters.adapter.CommonRecyclerAdapter;
import com.carlosdelachica.easyrecycleradapters.decorations.DividerItemDecoration;
import com.carlosdelachica.easyrecycleradapters.standalone.RecyclerStandalone;
import java.util.List;

public abstract class BaseRecyclerFragment<T>
extends Fragment
implements CommonRecyclerAdapter.OnItemClickListener,
CommonRecyclerAdapter.OnItemLongClickListener,
RecyclerStandalone.RecyclerStandaloneCallback {
    private RecyclerStandalone<T> recyclerStandalone;
    private FrameLayout container;
    private TextView emptyListTextView;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.recyclerStandalone = new RecyclerStandalone();
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        return inflater.inflate(R.layout.common_recycler_view, container, false);
    }

    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.container = (FrameLayout)view.findViewById(R.id.recycler_view_container);
        this.initStandalone(view);
    }

    private void initStandalone(View view) {
        this.recyclerStandalone.attachToRecyclerView((RecyclerView)view.findViewById(R.id.recyclerView), this.createAdapter(), this.createLayoutManager());
        this.recyclerStandalone.setCallback(this);
    }

    public void setEmptyListText(int messageStringRes) {
        this.initEmptyListTextView();
        this.recyclerStandalone.setEmptyListText(messageStringRes);
    }

    public void setEmptyListTextColor(int colorRes) {
        this.initEmptyListTextView();
        this.recyclerStandalone.setEmptyListTextColor(colorRes);
    }

    private void initEmptyListTextView() {
        if (this.emptyListTextView == null) {
            this.emptyListTextView = (TextView)this.container.findViewById(R.id.empty_list);
            this.recyclerStandalone.attachToEmptyList(this.emptyListTextView);
        }
    }

    public void setDivider(Drawable divider) {
        this.recyclerStandalone.setDivider(new DividerItemDecoration((Context)this.getActivity(), divider));
    }

    public void updateItems(List<T> data) {
        this.recyclerStandalone.updateItems(data);
    }

    public void addItem(T data) {
        this.recyclerStandalone.addItem(data);
    }

    public void removeItem(T data) {
        this.recyclerStandalone.removeItem(data);
    }

    public void removeItem(int position) {
        this.recyclerStandalone.removeItem(position);
    }

    public void onRefresh() {
        this.recyclerStandalone.onRefresh();
    }

    @Override
    public void onItemClick(int position, View view) {
    }

    @Override
    public boolean onLongItemClicked(int position, View view) {
        return false;
    }

    protected abstract CommonRecyclerAdapter<T> createAdapter();

    protected abstract RecyclerView.LayoutManager createLayoutManager();
}

