/*
 * Decompiled with CFR 0.152.
 */
package com.carlosdelachica.easyrecycleradapters.standalone;

import android.content.Context;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.widget.TextView;
import com.carlosdelachica.easyrecycleradapters.R;
import com.carlosdelachica.easyrecycleradapters.adapter.CommonRecyclerAdapter;
import com.carlosdelachica.easyrecycleradapters.decorations.DividerItemDecoration;
import java.util.List;

public class RecyclerStandalone<T>
implements CommonRecyclerAdapter.OnItemClickListener,
CommonRecyclerAdapter.OnItemLongClickListener {
    private RecyclerView recyclerView;
    private TextView emptyListTextView;
    private CommonRecyclerAdapter<T> adapter;
    private RecyclerView.LayoutManager layoutManager;
    private Context context;
    private RecyclerStandaloneCallback callback;
    private DividerItemDecoration dividerItemDecoration;

    public void attachToRecyclerView(RecyclerView recyclerView, CommonRecyclerAdapter<T> adapter) {
        this.attachToRecyclerView(recyclerView, adapter, (RecyclerView.LayoutManager)new LinearLayoutManager(recyclerView.getContext()));
    }

    public void attachToRecyclerView(RecyclerView recyclerView, CommonRecyclerAdapter<T> adapter, RecyclerView.LayoutManager layoutManager) {
        this.recyclerView = recyclerView;
        this.adapter = adapter;
        this.layoutManager = layoutManager;
        this.context = recyclerView.getContext();
        this.initRecyclerView();
    }

    private void initRecyclerView() {
        this.recyclerView.setHasFixedSize(true);
        this.initAdapter();
        this.initLayoutManager();
        this.initItemDecorations();
    }

    private void initAdapter() {
        this.recyclerView.setAdapter(this.adapter);
        this.initListeners();
    }

    private void initListeners() {
        this.adapter.setOnItemClickListener(this);
        this.adapter.setOnItemLongClickListener(this);
    }

    private void initLayoutManager() {
        this.recyclerView.setLayoutManager(this.layoutManager);
    }

    private void initItemDecorations() {
        int dividerRes = this.layoutManager instanceof GridLayoutManager ? R.drawable.grid_divider : R.drawable.list_divider;
        this.initDivider(new DividerItemDecoration(this.context, this.context.getResources().getDrawable(dividerRes)));
    }

    private void initDivider(DividerItemDecoration dividerItemDecoration) {
        this.dividerItemDecoration = dividerItemDecoration;
        this.recyclerView.addItemDecoration((RecyclerView.ItemDecoration)dividerItemDecoration);
    }

    public void setEmptyListTextColor(int colorRes) {
        if (this.emptyListTextView != null) {
            this.emptyListTextView.setTextColor(this.context.getResources().getColor(colorRes));
        }
    }

    public void setEmptyListText(int messageStringRes) {
        if (this.emptyListTextView != null) {
            this.emptyListTextView.setText(messageStringRes);
        }
    }

    public void attachToEmptyList(TextView emptyListTextView) {
        this.emptyListTextView = emptyListTextView;
    }

    public void setCallback(RecyclerStandaloneCallback callback) {
        this.callback = callback;
    }

    public void setDivider(DividerItemDecoration dividerItemDecoration) {
        this.recyclerView.removeItemDecoration((RecyclerView.ItemDecoration)this.dividerItemDecoration);
        this.initDivider(dividerItemDecoration);
    }

    public void updateItems(List<T> data) {
        this.setEmptyListVisible(false);
        this.adapter.updateItems(data);
    }

    public void addItem(T data) {
        this.adapter.add(data);
    }

    public void removeItem(T data) {
        this.adapter.remove(data);
    }

    public void removeItem(int position) {
        this.adapter.remove(position);
    }

    public void onRefresh() {
        this.setEmptyListVisible(true);
        this.adapter.clearItems();
    }

    private void setEmptyListVisible(boolean visible) {
        if (this.emptyListTextView != null) {
            this.emptyListTextView.setVisibility(visible ? 0 : 8);
        }
    }

    @Override
    public void onItemClick(int position, View view) {
        if (this.callback != null) {
            this.callback.onItemClick(position, view);
        }
    }

    @Override
    public boolean onLongItemClicked(int position, View view) {
        if (this.callback != null) {
            return this.callback.onLongItemClicked(position, view);
        }
        return false;
    }

    public static interface RecyclerStandaloneCallback {
        public void onItemClick(int var1, View var2);

        public boolean onLongItemClicked(int var1, View var2);
    }
}

