/*
 * Decompiled with CFR 0.152.
 */
package simplexml;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import simplexml.model.Element;
import simplexml.utils.Interfaces;
import simplexml.utils.Reflection;
import simplexml.utils.XML;

public interface XmlWriter
extends Interfaces.AccessSerializers,
Interfaces.ParserConfiguration {
    default public String toXml(Object o, String name) {
        StringWriter output = new StringWriter();
        try {
            this.writeObject(output, name, o, "");
        }
        catch (IOException | IllegalAccessException | IllegalArgumentException exception) {
            // empty catch block
        }
        return output.toString();
    }

    default public void toXml(Object o, String name, Writer writer) throws IOException {
        try {
            this.writeObject(writer, name, o, "");
        }
        catch (IllegalAccessException | IllegalArgumentException exception) {
            // empty catch block
        }
    }

    default public String domToXml(Element node) {
        StringWriter output = new StringWriter();
        try {
            this.domToXml(node, output);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return output.toString();
    }

    default public void domToXml(Element node, Writer writer) throws IOException {
        if (node.text == null && node.children.isEmpty()) {
            XML.writeSelfClosingTag(writer, node.name, XML.attributesToXml(node.attributes, this.shouldEncodeUTF8()));
        } else {
            XML.writeOpeningTag(writer, node.name, XML.attributesToXml(node.attributes, this.shouldEncodeUTF8()));
            for (Element child : node.children) {
                this.domToXml(child, writer);
            }
            if (node.text != null) {
                writer.append(XML.escapeXml(node.text, this.shouldEncodeUTF8()));
            }
            XML.writeClosingTag(writer, node.name);
        }
    }

    default public void writeSimple(Writer writer, String name, Object value, String indent) throws IOException {
        this.writeIndent(writer, indent);
        XML.writeTag(writer, name, XML.escapeXml(this.getSerializer(value.getClass()).convert(value), this.shouldEncodeUTF8()));
        this.writeNewLine(writer);
    }

    default public void writeSimple(Writer writer, String name, Object value, List<Field> attributes, Object text, String indent) throws IOException, IllegalAccessException {
        this.writeIndent(writer, indent);
        XML.writeTag(writer, name, XML.attributesToXml(attributes, value, this.shouldEncodeUTF8()), XML.escapeXml(this.getSerializer(text.getClass()).convert(text), this.shouldEncodeUTF8()));
        this.writeNewLine(writer);
    }

    default public void writeList(Writer writer, String name, Object o, String indent) throws IllegalArgumentException, IllegalAccessException, IOException {
        for (Object item : (List)o) {
            this.writeField(item.getClass(), writer, name, item, indent);
        }
    }

    default public void writeArray(Writer writer, String name, Object o, String indent) throws IllegalArgumentException, IllegalAccessException, IOException {
        for (Object item : (Object[])o) {
            this.writeField(item.getClass(), writer, name, item, indent);
        }
    }

    default public void writeSet(Writer writer, String name, Object o, String indent) throws IllegalArgumentException, IllegalAccessException, IOException {
        for (Object item : (Set)o) {
            this.writeField(item.getClass(), writer, name, item, indent);
        }
    }

    default public void writeMap(Writer writer, String name, Object o, String indent) throws IllegalArgumentException, IllegalAccessException, IOException {
        this.writeIndent(writer, indent);
        XML.writeOpeningTag(writer, name);
        this.writeNewLine(writer);
        for (Map.Entry entry : ((Map)o).entrySet()) {
            this.writeField(entry.getValue().getClass(), writer, entry.getKey().toString(), entry.getValue(), indent + "  ");
        }
        this.writeIndent(writer, indent);
        XML.writeClosingTag(writer, name);
        this.writeNewLine(writer);
    }

    default public void writeObject(Writer writer, String name, Object o, String indent) throws IllegalArgumentException, IllegalAccessException, IOException {
        LinkedList<Field> attributes = new LinkedList<Field>();
        LinkedList<Field> childNodes = new LinkedList<Field>();
        Field textNode = Reflection.determineTypeOfFields(o.getClass(), o, attributes, childNodes);
        if (childNodes.isEmpty()) {
            this.writeSimple(writer, name, o, attributes, textNode.get(o), indent);
            return;
        }
        this.writeIndent(writer, indent);
        XML.writeOpeningTag(writer, name, XML.attributesToXml(attributes, o, this.shouldEncodeUTF8()));
        this.writeNewLine(writer);
        for (Field f : childNodes) {
            this.writeField(f.getType(), writer, Reflection.toName(f), f.get(o), indent + "  ");
        }
        if (textNode != null) {
            this.writeIndent(writer, indent);
            writer.append(XML.escapeXml(textNode.get(o).toString(), this.shouldEncodeUTF8()));
            this.writeNewLine(writer);
        }
        this.writeIndent(writer, indent);
        XML.writeClosingTag(writer, name);
        this.writeNewLine(writer);
    }

    default public void writeField(Class<?> c, Writer writer, String name, Object value, String indent) throws IllegalArgumentException, IllegalAccessException, IOException {
        switch (Reflection.toClassType(c, this)) {
            case SIMPLE: {
                this.writeSimple(writer, name, value, indent);
                break;
            }
            case ARRAY: {
                this.writeArray(writer, name, value, indent);
                break;
            }
            case LIST: {
                this.writeList(writer, name, value, indent);
                break;
            }
            case SET: {
                this.writeSet(writer, name, value, indent);
                break;
            }
            case MAP: {
                this.writeMap(writer, name, value, indent);
                break;
            }
            default: {
                this.writeObject(writer, name, value, indent);
            }
        }
    }

    default public void writeIndent(Writer writer, String indent) throws IOException {
        if (this.shouldPrettyPrint()) {
            writer.append(indent);
        }
    }

    default public void writeNewLine(Writer writer) throws IOException {
        if (this.shouldPrettyPrint()) {
            writer.append("\n");
        }
    }
}

