/*
 * Decompiled with CFR 0.152.
 */
package simplexml.utils;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Map;
import java.util.Set;
import simplexml.model.XmlAttribute;
import simplexml.model.XmlName;
import simplexml.model.XmlNoExport;
import simplexml.model.XmlTextNode;
import simplexml.utils.Interfaces;
import sun.reflect.ReflectionFactory;

public enum Reflection {


    public static Field determineTypeOfFields(Class<?> clazz, Object o, List<Field> attributes, List<Field> childNodes) throws IllegalAccessException {
        Field textNode = null;
        for (Field f : clazz.getDeclaredFields()) {
            f.setAccessible(true);
            if (f.get(o) == null || Modifier.isStatic(f.getModifiers()) || Modifier.isTransient(f.getModifiers()) || f.isAnnotationPresent(XmlNoExport.class)) continue;
            if (f.isAnnotationPresent(XmlTextNode.class)) {
                textNode = f;
                continue;
            }
            if (f.isAnnotationPresent(XmlAttribute.class)) {
                attributes.add(f);
                continue;
            }
            childNodes.add(f);
        }
        return textNode;
    }

    public static ClassType toClassType(Class<?> c, Interfaces.AccessSerializers s) {
        if (Reflection.isSimple(c) || s.hasSerializer(c)) {
            return ClassType.SIMPLE;
        }
        if (c.isArray()) {
            return ClassType.ARRAY;
        }
        if (Reflection.isList(c)) {
            return ClassType.LIST;
        }
        if (Reflection.isSet(c)) {
            return ClassType.SET;
        }
        if (Reflection.isMap(c)) {
            return ClassType.MAP;
        }
        return ClassType.OBJECT;
    }

    public static boolean isSimple(Class<?> c) {
        return c.isAssignableFrom(Double.class) || c.isAssignableFrom(Double.TYPE) || c.isAssignableFrom(Integer.class) || c.isAssignableFrom(String.class) || c.isAssignableFrom(Integer.TYPE) || c.isAssignableFrom(Float.TYPE) || c.isAssignableFrom(Float.class) || c.isAssignableFrom(Byte.TYPE) || c.isAssignableFrom(Byte.class) || c.isAssignableFrom(Character.TYPE) || c.isAssignableFrom(Character.class) || c.isAssignableFrom(Short.TYPE) || c.isAssignableFrom(Short.class) || c.isAssignableFrom(Long.class) || c.isAssignableFrom(Long.TYPE) || c.isAssignableFrom(Boolean.TYPE) || c.isAssignableFrom(Boolean.class);
    }

    public static boolean isList(Class<?> c) {
        return c.isAssignableFrom(List.class);
    }

    public static boolean isSet(Class<?> c) {
        return c.isAssignableFrom(Set.class);
    }

    public static boolean isMap(Class<?> c) {
        return c.isAssignableFrom(Map.class);
    }

    public static <T> T newObject(Class<T> clazz) {
        return (T)Reflection.newObject(clazz, Object.class);
    }

    public static <T> T newObject(Class<T> clazz, Class<? super T> parent) {
        try {
            return Reflection.toDeclaredNoArgsConstructor(clazz).newInstance(new Object[0]);
        }
        catch (Exception e) {
            try {
                return clazz.cast(Reflection.newNoArgsConstructor(clazz, parent).newInstance(new Object[0]));
            }
            catch (RuntimeException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new IllegalStateException("Cannot create object", ex);
            }
        }
    }

    public static <T> Constructor<T> toDeclaredNoArgsConstructor(Class<T> clazz) throws NoSuchMethodException {
        Constructor<T> constructor = clazz.getDeclaredConstructor(new Class[0]);
        constructor.setAccessible(true);
        return constructor;
    }

    public static <T> Constructor<?> newNoArgsConstructor(Class<T> clazz, Class<? super T> parent) throws NoSuchMethodException {
        return ReflectionFactory.getReflectionFactory().newConstructorForSerialization(clazz, parent.getDeclaredConstructor(new Class[0]));
    }

    public static String toName(Class<?> o) {
        if (!o.isAnnotationPresent(XmlName.class)) {
            return o.getSimpleName().toLowerCase();
        }
        return o.getAnnotation(XmlName.class).value();
    }

    public static String toName(Field field) {
        if (field.isAnnotationPresent(XmlName.class)) {
            return field.getAnnotation(XmlName.class).value();
        }
        return field.getName();
    }

    public static enum ClassType {
        SIMPLE,
        ARRAY,
        LIST,
        SET,
        MAP,
        OBJECT;

    }
}

