/*
 * Decompiled with CFR 0.152.
 */
package com.github.crab2died;

import com.github.crab2died.converter.DefaultConvertible;
import com.github.crab2died.exceptions.Excel4JException;
import com.github.crab2died.exceptions.Excel4jReadException;
import com.github.crab2died.handler.ExcelHeader;
import com.github.crab2died.handler.SheetTemplate;
import com.github.crab2died.handler.SheetTemplateHandler;
import com.github.crab2died.sheet.wrapper.MapSheetWrapper;
import com.github.crab2died.sheet.wrapper.NoTemplateSheetWrapper;
import com.github.crab2died.sheet.wrapper.NormalSheetWrapper;
import com.github.crab2died.sheet.wrapper.SimpleSheetWrapper;
import com.github.crab2died.utils.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.lang.reflect.Array;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.csv.CSVRecord;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public final class ExcelUtils {
    private static volatile ExcelUtils excelUtils;
    private static final byte[] UTF_8_DOM;

    private ExcelUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ExcelUtils getInstance() {
        if (null != excelUtils) return excelUtils;
        Class<ExcelUtils> clazz = ExcelUtils.class;
        synchronized (ExcelUtils.class) {
            if (null != excelUtils) return excelUtils;
            excelUtils = new ExcelUtils();
            // ** MonitorExit[var0] (shouldn't be in output)
            return excelUtils;
        }
    }

    public <T> List<T> readExcel2Objects(String excelPath, Class<T> clazz, int offsetLine, int limitLine, int sheetIndex) throws Excel4JException, IOException {
        try (Workbook workbook = WorkbookFactory.create((InputStream)new FileInputStream(new File(excelPath)));){
            List<T> list = this.readExcel2ObjectsHandler(workbook, clazz, offsetLine, limitLine, sheetIndex);
            return list;
        }
    }

    public <T> List<T> readExcel2Objects(InputStream is, Class<T> clazz, int offsetLine, int limitLine, int sheetIndex) throws Excel4JException, IOException {
        try (Workbook workbook = WorkbookFactory.create((InputStream)is);){
            List<T> list = this.readExcel2ObjectsHandler(workbook, clazz, offsetLine, limitLine, sheetIndex);
            return list;
        }
    }

    public <T> List<T> readExcel2Objects(String excelPath, Class<T> clazz, int offsetLine, int sheetIndex) throws Excel4JException, IOException {
        return this.readExcel2Objects(excelPath, clazz, offsetLine, Integer.MAX_VALUE, sheetIndex);
    }

    public <T> List<T> readExcel2Objects(String excelPath, Class<T> clazz, int sheetIndex) throws Excel4JException, IOException {
        return this.readExcel2Objects(excelPath, clazz, 0, Integer.MAX_VALUE, sheetIndex);
    }

    public <T> List<T> readExcel2Objects(String excelPath, Class<T> clazz) throws Excel4JException, IOException {
        return this.readExcel2Objects(excelPath, clazz, 0, Integer.MAX_VALUE, 0);
    }

    public <T> List<T> readExcel2Objects(InputStream is, Class<T> clazz, int sheetIndex) throws Excel4JException, IOException {
        return this.readExcel2Objects(is, clazz, 0, Integer.MAX_VALUE, sheetIndex);
    }

    public <T> List<T> readExcel2Objects(InputStream is, Class<T> clazz) throws Excel4JException, IOException {
        return this.readExcel2Objects(is, clazz, 0, Integer.MAX_VALUE, 0);
    }

    private <T> List<T> readExcel2ObjectsHandler(Workbook workbook, Class<T> clazz, int offsetLine, int limitLine, int sheetIndex) throws Excel4JException {
        Sheet sheet = workbook.getSheetAt(sheetIndex);
        Row row = sheet.getRow(offsetLine);
        ArrayList<T> list = new ArrayList<T>();
        Map<Integer, ExcelHeader> maps = Utils.getHeaderMap(row, clazz);
        if (maps == null || maps.size() <= 0) {
            throw new Excel4jReadException("The Excel format to read is not correct, and check to see if the appropriate rows are set");
        }
        long maxLine = (long)sheet.getLastRowNum() > (long)offsetLine + (long)limitLine ? (long)offsetLine + (long)limitLine : (long)sheet.getLastRowNum();
        int i = offsetLine + 1;
        while ((long)i <= maxLine) {
            row = sheet.getRow(i);
            if (null != row) {
                T obj;
                try {
                    obj = clazz.newInstance();
                }
                catch (IllegalAccessException | InstantiationException e) {
                    throw new Excel4JException(e);
                }
                for (Cell cell : row) {
                    int ci = cell.getColumnIndex();
                    ExcelHeader header = maps.get(ci);
                    if (null == header) continue;
                    String val = Utils.getCellValue(cell);
                    String filed = header.getFiled();
                    Object value = null != header.getReadConverter() && header.getReadConverter().getClass() != DefaultConvertible.class ? header.getReadConverter().execRead(val) : Utils.str2TargetClass(val, header.getFiledClazz());
                    Utils.copyProperty(obj, filed, value);
                }
                list.add(obj);
            }
            ++i;
        }
        return list;
    }

    public List<List<String>> readExcel2List(String excelPath, int offsetLine, int limitLine, int sheetIndex) throws IOException {
        try (Workbook workbook = WorkbookFactory.create((InputStream)new FileInputStream(new File(excelPath)));){
            List<List<String>> list = this.readExcel2ObjectsHandler(workbook, offsetLine, limitLine, sheetIndex);
            return list;
        }
    }

    public List<List<String>> readExcel2List(InputStream is, int offsetLine, int limitLine, int sheetIndex) throws IOException {
        try (Workbook workbook = WorkbookFactory.create((InputStream)is);){
            List<List<String>> list = this.readExcel2ObjectsHandler(workbook, offsetLine, limitLine, sheetIndex);
            return list;
        }
    }

    public List<List<String>> readExcel2List(String excelPath, int offsetLine) throws IOException {
        try (Workbook workbook = WorkbookFactory.create((InputStream)new FileInputStream(new File(excelPath)));){
            List<List<String>> list = this.readExcel2ObjectsHandler(workbook, offsetLine, Integer.MAX_VALUE, 0);
            return list;
        }
    }

    public List<List<String>> readExcel2List(InputStream is, int offsetLine) throws IOException {
        try (Workbook workbook = WorkbookFactory.create((InputStream)is);){
            List<List<String>> list = this.readExcel2ObjectsHandler(workbook, offsetLine, Integer.MAX_VALUE, 0);
            return list;
        }
    }

    public List<List<String>> readExcel2List(String excelPath) throws IOException {
        try (Workbook workbook = WorkbookFactory.create((InputStream)new FileInputStream(new File(excelPath)));){
            List<List<String>> list = this.readExcel2ObjectsHandler(workbook, 0, Integer.MAX_VALUE, 0);
            return list;
        }
    }

    public List<List<String>> readExcel2List(InputStream is) throws IOException {
        try (Workbook workbook = WorkbookFactory.create((InputStream)is);){
            List<List<String>> list = this.readExcel2ObjectsHandler(workbook, 0, Integer.MAX_VALUE, 0);
            return list;
        }
    }

    private List<List<String>> readExcel2ObjectsHandler(Workbook workbook, int offsetLine, int limitLine, int sheetIndex) {
        ArrayList<List<String>> list = new ArrayList<List<String>>();
        Sheet sheet = workbook.getSheetAt(sheetIndex);
        long maxLine = (long)sheet.getLastRowNum() > (long)offsetLine + (long)limitLine ? (long)offsetLine + (long)limitLine : (long)sheet.getLastRowNum();
        int i = offsetLine;
        while ((long)i <= maxLine) {
            ArrayList<String> rows = new ArrayList<String>();
            Row row = sheet.getRow(i);
            if (null != row) {
                for (Cell cell : row) {
                    String val = Utils.getCellValue(cell);
                    rows.add(val);
                }
                list.add(rows);
            }
            ++i;
        }
        return list;
    }

    public void exportObjects2Excel(String templatePath, int sheetIndex, List<?> data, Map<String, String> extendMap, Class clazz, boolean isWriteHeader, String targetPath) throws Excel4JException {
        try (SheetTemplate sheetTemplate = this.exportExcelByModuleHandler(templatePath, sheetIndex, data, extendMap, clazz, isWriteHeader);){
            sheetTemplate.write2File(targetPath);
        }
        catch (IOException e) {
            throw new Excel4JException(e);
        }
    }

    public void exportObjects2Excel(String templatePath, int sheetIndex, List<?> data, Map<String, String> extendMap, Class clazz, boolean isWriteHeader, OutputStream os) throws Excel4JException {
        try (SheetTemplate sheetTemplate = this.exportExcelByModuleHandler(templatePath, sheetIndex, data, extendMap, clazz, isWriteHeader);){
            sheetTemplate.write2Stream(os);
        }
        catch (IOException e) {
            throw new Excel4JException(e);
        }
    }

    public void exportObjects2Excel(String templatePath, List<?> data, Map<String, String> extendMap, Class clazz, boolean isWriteHeader, String targetPath) throws Excel4JException {
        this.exportObjects2Excel(templatePath, 0, data, extendMap, clazz, isWriteHeader, targetPath);
    }

    public void exportObjects2Excel(String templatePath, List<?> data, Map<String, String> extendMap, Class clazz, boolean isWriteHeader, OutputStream os) throws Excel4JException {
        this.exportObjects2Excel(templatePath, 0, data, extendMap, clazz, isWriteHeader, os);
    }

    public void exportObjects2Excel(String templatePath, List<?> data, Map<String, String> extendMap, Class clazz, String targetPath) throws Excel4JException {
        this.exportObjects2Excel(templatePath, 0, data, extendMap, clazz, true, targetPath);
    }

    public void exportObjects2Excel(String templatePath, List<?> data, Map<String, String> extendMap, Class clazz, OutputStream os) throws Excel4JException {
        this.exportObjects2Excel(templatePath, 0, data, extendMap, clazz, true, os);
    }

    public void exportObjects2Excel(String templatePath, List<?> data, Class clazz, String targetPath) throws Excel4JException {
        this.exportObjects2Excel(templatePath, 0, data, null, clazz, true, targetPath);
    }

    public void exportObjects2Excel(String templatePath, List<?> data, Class clazz, OutputStream os) throws Excel4JException {
        this.exportObjects2Excel(templatePath, 0, data, null, clazz, true, os);
    }

    private SheetTemplate exportExcelByModuleHandler(String templatePath, int sheetIndex, List<?> data, Map<String, String> extendMap, Class clazz, boolean isWriteHeader) throws Excel4JException {
        SheetTemplate template = SheetTemplateHandler.sheetTemplateBuilder(templatePath);
        this.generateSheet(sheetIndex, data, extendMap, clazz, isWriteHeader, template);
        return template;
    }

    public void normalSheet2Excel(List<NormalSheetWrapper> sheetWrappers, String templatePath, String targetPath) throws Excel4JException {
        try (SheetTemplate sheetTemplate = this.exportExcelByModuleHandler(templatePath, sheetWrappers);){
            sheetTemplate.write2File(targetPath);
        }
        catch (IOException e) {
            throw new Excel4JException(e);
        }
    }

    public void normalSheet2Excel(List<NormalSheetWrapper> sheetWrappers, String templatePath, OutputStream os) throws Excel4JException {
        try (SheetTemplate sheetTemplate = this.exportExcelByModuleHandler(templatePath, sheetWrappers);){
            sheetTemplate.write2Stream(os);
        }
        catch (IOException e) {
            throw new Excel4JException(e);
        }
    }

    private SheetTemplate exportExcelByModuleHandler(String templatePath, List<NormalSheetWrapper> sheets) throws Excel4JException {
        SheetTemplate template = SheetTemplateHandler.sheetTemplateBuilder(templatePath);
        for (NormalSheetWrapper sheet : sheets) {
            this.generateSheet(sheet.getSheetIndex(), sheet.getData(), sheet.getExtendMap(), sheet.getClazz(), sheet.isWriteHeader(), template);
        }
        return template;
    }

    private void generateSheet(int sheetIndex, List<?> data, Map<String, String> extendMap, Class clazz, boolean isWriteHeader, SheetTemplate template) throws Excel4JException {
        SheetTemplateHandler.loadTemplate(template, sheetIndex);
        SheetTemplateHandler.extendData(template, extendMap);
        List<ExcelHeader> headers = Utils.getHeaderList(clazz);
        if (isWriteHeader) {
            SheetTemplateHandler.createNewRow(template);
            for (ExcelHeader header : headers) {
                SheetTemplateHandler.createCell(template, header.getTitle(), null);
            }
        }
        for (Object object : data) {
            SheetTemplateHandler.createNewRow(template);
            SheetTemplateHandler.insertSerial(template, null);
            for (ExcelHeader header : headers) {
                SheetTemplateHandler.createCell(template, Utils.getProperty(object, header.getFiled(), header.getWriteConverter()), null);
            }
        }
    }

    public void exportMap2Excel(String templatePath, int sheetIndex, Map<String, List<?>> data, Map<String, String> extendMap, Class clazz, boolean isWriteHeader, String targetPath) throws Excel4JException {
        try (SheetTemplate sheetTemplate = this.exportExcelByMapHandler(templatePath, sheetIndex, data, extendMap, clazz, isWriteHeader);){
            sheetTemplate.write2File(targetPath);
        }
        catch (IOException e) {
            throw new Excel4JException(e);
        }
    }

    public void exportMap2Excel(String templatePath, int sheetIndex, Map<String, List<?>> data, Map<String, String> extendMap, Class clazz, boolean isWriteHeader, OutputStream os) throws Excel4JException {
        try (SheetTemplate sheetTemplate = this.exportExcelByMapHandler(templatePath, sheetIndex, data, extendMap, clazz, isWriteHeader);){
            sheetTemplate.write2Stream(os);
        }
        catch (IOException e) {
            throw new Excel4JException(e);
        }
    }

    public void exportMap2Excel(String templatePath, Map<String, List<?>> data, Map<String, String> extendMap, Class clazz, String targetPath) throws Excel4JException {
        try (SheetTemplate sheetTemplate = this.exportExcelByMapHandler(templatePath, 0, data, extendMap, clazz, true);){
            sheetTemplate.write2File(targetPath);
        }
        catch (IOException e) {
            throw new Excel4JException(e);
        }
    }

    public void exportMap2Excel(String templatePath, Map<String, List<?>> data, Map<String, String> extendMap, Class clazz, OutputStream os) throws Excel4JException {
        try (SheetTemplate sheetTemplate = this.exportExcelByMapHandler(templatePath, 0, data, extendMap, clazz, true);){
            sheetTemplate.write2Stream(os);
        }
        catch (IOException e) {
            throw new Excel4JException(e);
        }
    }

    public void exportMap2Excel(String templatePath, Map<String, List<?>> data, Class clazz, String targetPath) throws Excel4JException {
        try (SheetTemplate sheetTemplate = this.exportExcelByMapHandler(templatePath, 0, data, null, clazz, true);){
            sheetTemplate.write2File(targetPath);
        }
        catch (IOException e) {
            throw new Excel4JException(e);
        }
    }

    public void exportMap2Excel(String templatePath, Map<String, List<?>> data, Class clazz, OutputStream os) throws Excel4JException {
        try (SheetTemplate sheetTemplate = this.exportExcelByMapHandler(templatePath, 0, data, null, clazz, true);){
            sheetTemplate.write2Stream(os);
        }
        catch (IOException e) {
            throw new Excel4JException(e);
        }
    }

    private SheetTemplate exportExcelByMapHandler(String templatePath, int sheetIndex, Map<String, List<?>> data, Map<String, String> extendMap, Class clazz, boolean isWriteHeader) throws Excel4JException {
        SheetTemplate template = SheetTemplateHandler.sheetTemplateBuilder(templatePath);
        this.generateSheet(template, sheetIndex, data, extendMap, clazz, isWriteHeader);
        return template;
    }

    public void mapSheet2Excel(List<MapSheetWrapper> sheetWrappers, String templatePath, String targetPath) throws Excel4JException {
        try (SheetTemplate sheetTemplate = this.exportExcelByMapHandler(sheetWrappers, templatePath);){
            sheetTemplate.write2File(targetPath);
        }
        catch (IOException e) {
            throw new Excel4JException(e);
        }
    }

    public void mapSheet2Excel(List<MapSheetWrapper> sheetWrappers, String templatePath, OutputStream os) throws Excel4JException {
        try (SheetTemplate sheetTemplate = this.exportExcelByMapHandler(sheetWrappers, templatePath);){
            sheetTemplate.write2Stream(os);
        }
        catch (IOException e) {
            throw new Excel4JException(e);
        }
    }

    private SheetTemplate exportExcelByMapHandler(List<MapSheetWrapper> sheetWrappers, String templatePath) throws Excel4JException {
        SheetTemplate template = SheetTemplateHandler.sheetTemplateBuilder(templatePath);
        for (MapSheetWrapper sheet : sheetWrappers) {
            this.generateSheet(template, sheet.getSheetIndex(), sheet.getData(), sheet.getExtendMap(), sheet.getClazz(), sheet.isWriteHeader());
        }
        return template;
    }

    private void generateSheet(SheetTemplate template, int sheetIndex, Map<String, List<?>> data, Map<String, String> extendMap, Class clazz, boolean isWriteHeader) throws Excel4JException {
        SheetTemplateHandler.loadTemplate(template, sheetIndex);
        SheetTemplateHandler.extendData(template, extendMap);
        List<ExcelHeader> headers = Utils.getHeaderList(clazz);
        if (isWriteHeader) {
            SheetTemplateHandler.createNewRow(template);
            for (ExcelHeader excelHeader : headers) {
                SheetTemplateHandler.createCell(template, excelHeader.getTitle(), null);
            }
        }
        for (Map.Entry entry : data.entrySet()) {
            for (Object object : (List)entry.getValue()) {
                SheetTemplateHandler.createNewRow(template);
                SheetTemplateHandler.insertSerial(template, (String)entry.getKey());
                for (ExcelHeader header : headers) {
                    SheetTemplateHandler.createCell(template, Utils.getProperty(object, header.getFiled(), header.getWriteConverter()), (String)entry.getKey());
                }
            }
        }
    }

    public void exportObjects2Excel(List<?> data, Class clazz, boolean isWriteHeader, String sheetName, boolean isXSSF, String targetPath) throws Excel4JException, IOException {
        try (FileOutputStream fos = new FileOutputStream(targetPath);
             Workbook workbook = this.exportExcelNoTemplateHandler(data, clazz, isWriteHeader, sheetName, isXSSF);){
            workbook.write((OutputStream)fos);
        }
    }

    public void exportObjects2Excel(List<?> data, Class clazz, boolean isWriteHeader, String sheetName, boolean isXSSF, OutputStream os) throws Excel4JException, IOException {
        try (Workbook workbook = this.exportExcelNoTemplateHandler(data, clazz, isWriteHeader, sheetName, isXSSF);){
            workbook.write(os);
        }
    }

    public void exportObjects2Excel(List<?> data, Class clazz, boolean isWriteHeader, String targetPath) throws Excel4JException, IOException {
        try (FileOutputStream fos = new FileOutputStream(targetPath);
             Workbook workbook = this.exportExcelNoTemplateHandler(data, clazz, isWriteHeader, null, true);){
            workbook.write((OutputStream)fos);
        }
    }

    public void exportObjects2Excel(List<?> data, Class clazz, boolean isWriteHeader, OutputStream os) throws Excel4JException, IOException {
        try (Workbook workbook = this.exportExcelNoTemplateHandler(data, clazz, isWriteHeader, null, true);){
            workbook.write(os);
        }
    }

    public void exportObjects2Excel(List<?> data, Class clazz, OutputStream os) throws Excel4JException, IOException {
        try (Workbook workbook = this.exportExcelNoTemplateHandler(data, clazz, true, null, true);){
            workbook.write(os);
        }
    }

    public void exportObjects2Excel(List<?> data, Class clazz, String targetPath) throws Excel4JException, IOException {
        try (FileOutputStream fos = new FileOutputStream(targetPath);
             Workbook workbook = this.exportExcelNoTemplateHandler(data, clazz, true, null, true);){
            workbook.write((OutputStream)fos);
        }
    }

    private Workbook exportExcelNoTemplateHandler(List<?> data, Class clazz, boolean isWriteHeader, String sheetName, boolean isXSSF) throws Excel4JException {
        Object workbook = isXSSF ? new XSSFWorkbook() : new HSSFWorkbook();
        this.generateSheet((Workbook)workbook, data, clazz, isWriteHeader, sheetName);
        return workbook;
    }

    public void noTemplateSheet2Excel(List<NoTemplateSheetWrapper> sheets, String targetPath) throws Excel4JException, IOException {
        try (FileOutputStream fos = new FileOutputStream(targetPath);
             Workbook workbook = this.exportExcelNoTemplateHandler(sheets, true);){
            workbook.write((OutputStream)fos);
        }
    }

    public void noTemplateSheet2Excel(List<NoTemplateSheetWrapper> sheets, boolean isXSSF, String targetPath) throws Excel4JException, IOException {
        try (FileOutputStream fos = new FileOutputStream(targetPath);
             Workbook workbook = this.exportExcelNoTemplateHandler(sheets, isXSSF);){
            workbook.write((OutputStream)fos);
        }
    }

    public void noTemplateSheet2Excel(List<NoTemplateSheetWrapper> sheets, OutputStream os) throws Excel4JException, IOException {
        try (Workbook workbook = this.exportExcelNoTemplateHandler(sheets, true);){
            workbook.write(os);
        }
    }

    public void noTemplateSheet2Excel(List<NoTemplateSheetWrapper> sheets, boolean isXSSF, OutputStream os) throws Excel4JException, IOException {
        try (Workbook workbook = this.exportExcelNoTemplateHandler(sheets, isXSSF);){
            workbook.write(os);
        }
    }

    private Workbook exportExcelNoTemplateHandler(List<NoTemplateSheetWrapper> sheetWrappers, boolean isXSSF) throws Excel4JException {
        Object workbook = isXSSF ? new XSSFWorkbook() : new HSSFWorkbook();
        for (NoTemplateSheetWrapper sheet : sheetWrappers) {
            this.generateSheet((Workbook)workbook, sheet.getData(), sheet.getClazz(), sheet.isWriteHeader(), sheet.getSheetName());
        }
        return workbook;
    }

    private void generateSheet(Workbook workbook, List<?> data, Class clazz, boolean isWriteHeader, String sheetName) throws Excel4JException {
        Sheet sheet = null != sheetName && !"".equals(sheetName) ? workbook.createSheet(sheetName) : workbook.createSheet();
        Row row = sheet.createRow(0);
        List<ExcelHeader> headers = Utils.getHeaderList(clazz);
        if (isWriteHeader) {
            for (int i = 0; i < headers.size(); ++i) {
                row.createCell(i).setCellValue(headers.get(i).getTitle());
            }
        }
        for (int i = 0; i < data.size(); ++i) {
            row = sheet.createRow(i + 1);
            Object _data = data.get(i);
            for (int j = 0; j < headers.size(); ++j) {
                row.createCell(j).setCellValue(Utils.getProperty(_data, headers.get(j).getFiled(), headers.get(j).getWriteConverter()));
            }
        }
    }

    public void exportObjects2Excel(List<?> data, List<String> header, String sheetName, boolean isXSSF, String targetPath) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(targetPath);
             Workbook workbook = this.exportExcelBySimpleHandler(data, header, sheetName, isXSSF);){
            workbook.write((OutputStream)fos);
        }
    }

    public void exportObjects2Excel(List<?> data, List<String> header, String sheetName, boolean isXSSF, OutputStream os) throws IOException {
        try (Workbook workbook = this.exportExcelBySimpleHandler(data, header, sheetName, isXSSF);){
            workbook.write(os);
        }
    }

    public void exportObjects2Excel(List<?> data, List<String> header, String targetPath) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(targetPath);
             Workbook workbook = this.exportExcelBySimpleHandler(data, header, null, true);){
            workbook.write((OutputStream)fos);
        }
    }

    public void exportObjects2Excel(List<?> data, List<String> header, OutputStream os) throws IOException {
        try (Workbook workbook = this.exportExcelBySimpleHandler(data, header, null, true);){
            workbook.write(os);
        }
    }

    public void exportObjects2Excel(List<?> data, String targetPath) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(targetPath);
             Workbook workbook = this.exportExcelBySimpleHandler(data, null, null, true);){
            workbook.write((OutputStream)fos);
        }
    }

    public void exportObjects2Excel(List<?> data, OutputStream os) throws IOException {
        try (Workbook workbook = this.exportExcelBySimpleHandler(data, null, null, true);){
            workbook.write(os);
        }
    }

    private Workbook exportExcelBySimpleHandler(List<?> data, List<String> header, String sheetName, boolean isXSSF) {
        Object workbook = isXSSF ? new XSSFWorkbook() : new HSSFWorkbook();
        this.generateSheet((Workbook)workbook, data, header, sheetName);
        return workbook;
    }

    public void simpleSheet2Excel(List<SimpleSheetWrapper> sheets, String targetPath) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(targetPath);
             Workbook workbook = this.exportExcelBySimpleHandler(sheets, true);){
            workbook.write((OutputStream)fos);
        }
    }

    public void simpleSheet2Excel(List<SimpleSheetWrapper> sheets, boolean isXSSF, String targetPath) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(targetPath);
             Workbook workbook = this.exportExcelBySimpleHandler(sheets, isXSSF);){
            workbook.write((OutputStream)fos);
        }
    }

    public void simpleSheet2Excel(List<SimpleSheetWrapper> sheets, OutputStream os) throws IOException {
        try (Workbook workbook = this.exportExcelBySimpleHandler(sheets, true);){
            workbook.write(os);
        }
    }

    public void simpleSheet2Excel(List<SimpleSheetWrapper> sheets, boolean isXSSF, OutputStream os) throws IOException {
        try (Workbook workbook = this.exportExcelBySimpleHandler(sheets, isXSSF);){
            workbook.write(os);
        }
    }

    private Workbook exportExcelBySimpleHandler(List<SimpleSheetWrapper> sheets, boolean isXSSF) {
        Object workbook = isXSSF ? new XSSFWorkbook() : new HSSFWorkbook();
        for (SimpleSheetWrapper sheet : sheets) {
            this.generateSheet((Workbook)workbook, sheet.getData(), sheet.getHeader(), sheet.getSheetName());
        }
        return workbook;
    }

    private void generateSheet(Workbook workbook, List<?> data, List<String> header, String sheetName) {
        Sheet sheet = null != sheetName && !"".equals(sheetName) ? workbook.createSheet(sheetName) : workbook.createSheet();
        int rowIndex = 0;
        if (null != header && header.size() > 0) {
            Row row = sheet.createRow(rowIndex++);
            for (int i = 0; i < header.size(); ++i) {
                row.createCell(i, CellType.STRING).setCellValue(header.get(i));
            }
        }
        for (Object object : data) {
            Row row = sheet.createRow(rowIndex++);
            if (object.getClass().isArray()) {
                for (int j = 0; j < Array.getLength(object); ++j) {
                    row.createCell(j, CellType.STRING).setCellValue(Array.get(object, j).toString());
                }
                continue;
            }
            if (object instanceof Collection) {
                Collection items = (Collection)object;
                int j = 0;
                for (Object item : items) {
                    row.createCell(j++, CellType.STRING).setCellValue(item.toString());
                }
                continue;
            }
            row.createCell(0, CellType.STRING).setCellValue(object.toString());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> List<T> readCSV2Objects(String path, Class<T> clazz) {
        try (FileInputStream is = new FileInputStream(new File(path));){
            List<T> list = this.readCSVByMapHandler(is, clazz);
            return list;
        }
        catch (Excel4JException | IOException e) {
            throw new Excel4jReadException("read [" + path + "] CSV Error: ", e);
        }
    }

    public <T> List<T> readCSV2Objects(InputStream is, Class<T> clazz) {
        try {
            return this.readCSVByMapHandler(is, clazz);
        }
        catch (Excel4JException | IOException e) {
            throw new Excel4jReadException("read CSV Error: ", e);
        }
    }

    private <T> List<T> readCSVByMapHandler(InputStream is, Class<T> clazz) throws IOException, Excel4JException {
        ArrayList<T> records = new ArrayList<T>();
        List<ExcelHeader> headers = Utils.getHeaderList(clazz);
        if (null == headers || headers.size() <= 0) {
            throw new Excel4jReadException("[" + clazz + "] must configuration @ExcelFiled");
        }
        String[] csvHeaders = new String[headers.size()];
        for (int i = 0; i < headers.size(); ++i) {
            csvHeaders[i] = headers.get(i).getTitle();
        }
        CSVFormat format = CSVFormat.EXCEL.withHeader(csvHeaders).withSkipHeaderRecord(true);
        try (InputStreamReader read = new InputStreamReader(is, StandardCharsets.UTF_8);
             CSVParser parser = new CSVParser((Reader)read, format);){
            for (CSVRecord _parser : parser) {
                T obj;
                try {
                    obj = clazz.newInstance();
                }
                catch (IllegalAccessException | InstantiationException e) {
                    throw new Excel4jReadException(e);
                }
                for (ExcelHeader header : headers) {
                    String value = _parser.get(header.getTitle());
                    String filed = header.getFiled();
                    Object objectVal = null != header.getReadConverter() && header.getReadConverter().getClass() != DefaultConvertible.class ? header.getReadConverter().execRead(value) : Utils.str2TargetClass(value, header.getFiledClazz());
                    Utils.copyProperty(obj, filed, objectVal);
                }
                records.add(obj);
            }
        }
        return records;
    }

    public void exportObjects2CSV(List<?> data, Class clazz, String path) throws Excel4JException {
        try {
            FileWriter writer = new FileWriter(path);
            this.exportCSVByMapHandler(data, clazz, true, writer);
        }
        catch (Excel4JException | IOException e) {
            throw new Excel4JException(e);
        }
    }

    public void exportObjects2CSV(List<?> data, Class clazz, OutputStream os) throws Excel4JException {
        try {
            OutputStreamWriter writer = new OutputStreamWriter(os);
            this.exportCSVByMapHandler(data, clazz, true, writer);
        }
        catch (Excel4JException | IOException e) {
            throw new Excel4JException(e);
        }
    }

    public void exportObjects2CSV(List<?> data, Class clazz, boolean isWriteHeader, String path) throws Excel4JException {
        try {
            FileWriter writer = new FileWriter(path);
            this.exportCSVByMapHandler(data, clazz, isWriteHeader, writer);
        }
        catch (Excel4JException | IOException e) {
            throw new Excel4JException(e);
        }
    }

    public void exportObjects2CSV(List<?> data, Class clazz, boolean isWriteHeader, OutputStream os) throws Excel4JException {
        try {
            OutputStreamWriter writer = new OutputStreamWriter(os);
            this.exportCSVByMapHandler(data, clazz, isWriteHeader, writer);
        }
        catch (Excel4JException | IOException e) {
            throw new Excel4JException(e);
        }
    }

    private void exportCSVByMapHandler(List<?> data, Class clazz, boolean isWriteHeader, Appendable appendable) throws Excel4JException, IOException {
        List<ExcelHeader> headers = Utils.getHeaderList(clazz);
        appendable.append(new String(UTF_8_DOM, StandardCharsets.UTF_8));
        try (CSVPrinter printer = new CSVPrinter(appendable, CSVFormat.EXCEL);){
            if (isWriteHeader) {
                for (ExcelHeader header : headers) {
                    printer.print((Object)header.getTitle());
                }
                printer.println();
            }
            for (ExcelHeader _data : data) {
                for (ExcelHeader header : headers) {
                    printer.print((Object)Utils.getProperty(_data, header.getFiled(), header.getWriteConverter()));
                }
                printer.println();
            }
            printer.flush();
        }
    }

    static {
        UTF_8_DOM = new byte[]{-17, -69, -65};
    }
}

