/*
 * Decompiled with CFR 0.152.
 */
package nextflow.file.http;

import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.AccessDeniedException;
import java.nio.file.AccessMode;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.ProviderMismatchException;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.attribute.FileTime;
import java.nio.file.spi.FileSystemProvider;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import nextflow.file.http.XFileAttributes;
import nextflow.file.http.XFileSystem;
import nextflow.file.http.XPath;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.powerassert.AssertionRenderer;
import org.codehaus.groovy.runtime.powerassert.ValueRecorder;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import sun.net.www.protocol.ftp.FtpURLConnection;

abstract class XFileSystemProvider
extends FileSystemProvider
implements GroovyObject {
    private Map<URI, FileSystem> fileSystemMap;
    public static Set<String> ALL_SCHEMES;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    public XFileSystemProvider() {
        MetaClass metaClass;
        Map map;
        this.fileSystemMap = map = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    private static URI key(String s, String a) {
        return new URI(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{s, a}, new String[]{"", "://", ""})));
    }

    private static URI key(URI uri) {
        return XFileSystemProvider.key(uri.getScheme().toLowerCase(), uri.getAuthority().toLowerCase());
    }

    @Override
    public FileSystem newFileSystem(URI uri, Map<String, ?> env) throws IOException {
        String scheme = uri.getScheme().toLowerCase();
        if (ScriptBytecodeAdapter.compareNotEqual((Object)scheme, (Object)this.getScheme())) {
            throw (Throwable)new IllegalArgumentException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.getScheme().toUpperCase(), scheme}, new String[]{"Not a valid ", " scheme: ", ""})));
        }
        URI base = XFileSystemProvider.key(uri);
        if (this.fileSystemMap.containsKey(base)) {
            throw (Throwable)new IllegalStateException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{base}, new String[]{"File system `", "` already exists"})));
        }
        XFileSystem result = new XFileSystem(this, base);
        XFileSystem xFileSystem = result;
        DefaultGroovyMethods.putAt(this.fileSystemMap, (Object)base, (Object)xFileSystem);
        return result;
    }

    @Override
    public FileSystem getFileSystem(URI uri) {
        return this.getFileSystem(uri, false);
    }

    public FileSystem getFileSystem(URI uri, boolean canCreate) {
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            Map<URI, FileSystem> map = this.fileSystemMap;
            valueRecorder.record(map, 8);
            valueRecorder.record(map, 8);
            if (map != null) {
                valueRecorder.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert fileSystemMap != null", (ValueRecorder)valueRecorder), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
        String scheme = uri.getScheme().toLowerCase();
        if (ScriptBytecodeAdapter.compareNotEqual((Object)scheme, (Object)this.getScheme())) {
            throw (Throwable)new IllegalArgumentException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.getScheme().toUpperCase(), scheme}, new String[]{"Not a valid ", " scheme: ", ""})));
        }
        URI key = XFileSystemProvider.key(uri);
        FileSystem result = (FileSystem)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.getAt(this.fileSystemMap, (Object)key), FileSystem.class);
        if (!DefaultTypeTransformation.booleanUnbox((Object)result)) {
            if (canCreate) {
                FileSystem fileSystem;
                result = fileSystem = this.newFileSystem(uri, Collections.emptyMap());
            } else {
                throw (Throwable)new FileSystemNotFoundException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{key}, new String[]{"File system not found: ", ""})));
            }
        }
        return result;
    }

    @Override
    public Path getPath(URI uri) {
        return this.getFileSystem(uri, true).getPath(uri.getPath(), new String[0]);
    }

    @Override
    public SeekableByteChannel newByteChannel(Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        if (ScriptBytecodeAdapter.compareNotEqual(path.getClass(), XPath.class)) {
            throw (Throwable)new ProviderMismatchException();
        }
        if (options.size() > 0) {
            OpenOption opt = null;
            Iterator<? extends OpenOption> iterator = options.iterator();
            while (iterator.hasNext()) {
                opt = (OpenOption)ScriptBytecodeAdapter.castToType((Object)iterator.next(), OpenOption.class);
                if (!(ScriptBytecodeAdapter.compareEqual((Object)opt, (Object)StandardOpenOption.APPEND) || ScriptBytecodeAdapter.compareEqual((Object)opt, (Object)StandardOpenOption.WRITE))) continue;
                throw (Throwable)new UnsupportedOperationException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{opt}, new String[]{"'", "' not allowed"})));
            }
        }
        URLConnection conn = new URL(path.toUri().toString()).openConnection();
        Reference size = new Reference((Object)conn.getContentLengthLong());
        Reference stream = new Reference((Object)new BufferedInputStream(conn.getInputStream()));
        return new SeekableByteChannel(this, stream, size){
            public /* synthetic */ Reference size;
            public /* synthetic */ Reference stream;
            private long _position;
            public /* synthetic */ XFileSystemProvider this$0;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private transient /* synthetic */ MetaClass metaClass;
            {
                MetaClass metaClass;
                Reference reference;
                Reference reference2;
                XFileSystemProvider xFileSystemProvider;
                this.this$0 = xFileSystemProvider = p0;
                this.size = reference2 = p2;
                this.stream = reference = p1;
                this.metaClass = metaClass = this.$getStaticMetaClass();
            }

            /*
             * Unable to fully structure code
             */
            @Override
            public int read(ByteBuffer buffer) throws IOException {
                data = 0;
                len = 0;
                while (true) {
                    if (!(len < buffer.capacity())) ** GOTO lbl-1000
                    data = var4_4 = ((BufferedInputStream)this.stream.get()).read();
                    if (ScriptBytecodeAdapter.compareNotEqual((Object)var4_4, (Object)-1)) {
                        v0 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v0 = false;
                    }
                    if (!v0) break;
                    buffer.put((byte)data);
                    var5_5 = len;
                    var5_5 + 1;
                }
                this._position = this._position + (long)len;
                var6_6 = len;
                return var6_6 != 0 != false ? Integer.valueOf(var6_6) : Integer.valueOf(-1);
            }

            @Override
            public int write(ByteBuffer src) throws IOException {
                throw (Throwable)new UnsupportedOperationException("Write operation not supported");
            }

            @Override
            public long position() throws IOException {
                return this._position;
            }

            @Override
            public SeekableByteChannel position(long newPosition) throws IOException {
                throw (Throwable)new UnsupportedOperationException("Position operation not supported");
            }

            @Override
            public long size() throws IOException {
                return DefaultTypeTransformation.longUnbox((Object)this.size.get());
            }

            @Override
            public SeekableByteChannel truncate(long unused) throws IOException {
                throw (Throwable)new UnsupportedOperationException("Truncate operation not supported");
            }

            @Override
            public boolean isOpen() {
                return true;
            }

            @Override
            public void close() throws IOException {
                ((BufferedInputStream)this.stream.get()).close();
            }

            public /* synthetic */ Object methodMissing(String name, Object args) {
                return this.this$0.this$dist$invoke$2(name, args);
            }

            public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
                return ScriptBytecodeAdapter.invokeMethodN(1.class, XFileSystemProvider.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            }

            public /* synthetic */ void propertyMissing(String name, Object val) {
                this.this$0.this$dist$set$2(name, val);
            }

            public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
                Object object = val;
                ScriptBytecodeAdapter.setProperty((Object)object, null, XFileSystemProvider.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            public /* synthetic */ Object propertyMissing(String name) {
                return this.this$0.this$dist$get$2(name);
            }

            public static /* synthetic */ Object $static_propertyMissing(String name) {
                return ScriptBytecodeAdapter.getProperty(1.class, XFileSystemProvider.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (this.getClass() != 1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)this);
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                }
                return classInfo.getMetaClass();
            }

            @Generated
            @Internal
            public /* synthetic */ MetaClass getMetaClass() {
                MetaClass metaClass = this.metaClass;
                if (metaClass != null) {
                    return metaClass;
                }
                this.metaClass = this.$getStaticMetaClass();
                return this.metaClass;
            }

            @Generated
            @Internal
            public /* synthetic */ void setMetaClass(MetaClass metaClass) {
                this.metaClass = metaClass;
            }

            @Generated
            @Internal
            public /* synthetic */ Object invokeMethod(String string, Object object) {
                return this.getMetaClass().invokeMethod((Object)this, string, object);
            }

            @Generated
            @Internal
            public /* synthetic */ Object getProperty(String string) {
                return this.getMetaClass().getProperty((Object)this, string);
            }

            @Generated
            @Internal
            public /* synthetic */ void setProperty(String string, Object object) {
                this.getMetaClass().setProperty((Object)this, string, object);
            }
        };
    }

    @Override
    public InputStream newInputStream(Path path, OpenOption ... options) throws IOException {
        if (ScriptBytecodeAdapter.compareNotEqual(path.getClass(), XPath.class)) {
            throw (Throwable)new ProviderMismatchException();
        }
        if (options.length > 0) {
            OpenOption opt2 = null;
            OpenOption[] openOptionArray = options;
            if (options != null) {
                for (OpenOption opt2 : openOptionArray) {
                    if (!(ScriptBytecodeAdapter.compareEqual((Object)opt2, (Object)StandardOpenOption.APPEND) || ScriptBytecodeAdapter.compareEqual((Object)opt2, (Object)StandardOpenOption.WRITE))) continue;
                    throw (Throwable)new UnsupportedOperationException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{opt2}, new String[]{"'", "' not allowed"})));
                }
            }
        }
        return new URL(path.toUri().toString()).openStream();
    }

    @Override
    public OutputStream newOutputStream(Path path, OpenOption ... options) throws IOException {
        throw (Throwable)new UnsupportedOperationException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.getScheme().toUpperCase()}, new String[]{"Write not supported by ", " file system provider"})));
    }

    @Override
    public DirectoryStream<Path> newDirectoryStream(Path dir, DirectoryStream.Filter<? super Path> filter) throws IOException {
        throw (Throwable)new UnsupportedOperationException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.getScheme().toUpperCase()}, new String[]{"Direcotry listing unsupported by ", " file system provider"})));
    }

    @Override
    public void createDirectory(Path dir, FileAttribute<?> ... attrs) throws IOException {
        throw (Throwable)new UnsupportedOperationException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.getScheme().toUpperCase()}, new String[]{"Create directory not supported by ", " file system provider"})));
    }

    @Override
    public void delete(Path path) throws IOException {
        throw (Throwable)new UnsupportedOperationException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.getScheme().toUpperCase()}, new String[]{"Delete not supported by ", " file system provider"})));
    }

    @Override
    public void copy(Path source, Path target, CopyOption ... options) throws IOException {
        throw (Throwable)new UnsupportedOperationException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.getScheme().toUpperCase()}, new String[]{"Copy not supported by ", " file system provider"})));
    }

    @Override
    public void move(Path source, Path target, CopyOption ... options) throws IOException {
        throw (Throwable)new UnsupportedOperationException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.getScheme().toUpperCase()}, new String[]{"Move not supported by ", " file system provider"})));
    }

    @Override
    public boolean isSameFile(Path path, Path path2) throws IOException {
        return ScriptBytecodeAdapter.compareEqual((Object)path, (Object)path2);
    }

    @Override
    public boolean isHidden(Path path) throws IOException {
        return path.getFileName().startsWith(".");
    }

    @Override
    public FileStore getFileStore(Path path) throws IOException {
        throw (Throwable)new UnsupportedOperationException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.getScheme().toUpperCase()}, new String[]{"File store not supported by ", " file system provider"})));
    }

    @Override
    public void checkAccess(Path path, AccessMode ... modes) throws IOException {
        this.readAttributes(path, XFileAttributes.class, new LinkOption[0]);
        AccessMode m2 = null;
        AccessMode[] accessModeArray = modes;
        if (modes != null) {
            for (AccessMode m2 : accessModeArray) {
                if (!ScriptBytecodeAdapter.compareEqual((Object)((Object)m2), (Object)((Object)AccessMode.WRITE))) continue;
                throw (Throwable)new AccessDeniedException("Write mode not supported");
            }
        }
    }

    @Override
    public <V extends FileAttributeView> V getFileAttributeView(Path path, Class<V> type, LinkOption ... options) {
        return (V)((FileAttributeView)ScriptBytecodeAdapter.castToType(null, FileAttributeView.class));
    }

    @Override
    public <A extends BasicFileAttributes> A readAttributes(Path path, Class<A> type, LinkOption ... options) throws IOException {
        if (ScriptBytecodeAdapter.compareEqual(type, BasicFileAttributes.class) || ScriptBytecodeAdapter.compareEqual(type, XFileAttributes.class)) {
            XPath p = (XPath)ScriptBytecodeAdapter.castToType((Object)path, XPath.class);
            BasicFileAttributes attrs = this.readHttpAttributes(p);
            if (attrs == null) {
                throw (Throwable)new IOException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{p.toString()}, new String[]{"Unable to access path: ", ""})));
            }
            return (A)attrs;
        }
        throw (Throwable)new UnsupportedOperationException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.getScheme().toUpperCase(), type}, new String[]{"Not a valid ", " file attribute type: ", ""})));
    }

    @Override
    public Map<String, Object> readAttributes(Path path, String attributes, LinkOption ... options) throws IOException {
        throw (Throwable)new UnsupportedOperationException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.getScheme().toUpperCase()}, new String[]{"Read file attributes no supported by ", " file system provider"})));
    }

    @Override
    public void setAttribute(Path path, String attribute, Object value, LinkOption ... options) throws IOException {
        throw (Throwable)new UnsupportedOperationException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.getScheme().toUpperCase()}, new String[]{"Set file attributes not supported by ", " file system provider"})));
    }

    /*
     * Unable to fully structure code
     */
    protected XFileAttributes readHttpAttributes(XPath path) {
        conn = path.toUri().toURL().openConnection();
        if (conn instanceof FtpURLConnection) {
            return new XFileAttributes(null, DefaultTypeTransformation.longUnbox((Object)-1));
        }
        if (!(conn instanceof HttpURLConnection)) ** GOTO lbl-1000
        if (ScriptBytecodeAdapter.createList((Object[])new Object[]{200, 301, 302}) == null) {
            ((HttpURLConnection)ScriptBytecodeAdapter.castToType((Object)conn, HttpURLConnection.class)).getResponseCode();
            v0 = false;
        } else {
            v0 = DefaultGroovyMethods.isCase((Collection)ScriptBytecodeAdapter.createList((Object[])new Object[]{200, 301, 302}), (Object)((HttpURLConnection)ScriptBytecodeAdapter.castToType((Object)conn, HttpURLConnection.class)).getResponseCode());
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)v0)) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = false;
        }
        if (v1) {
            header = conn.getHeaderFields();
            return this.readHttpAttributes(header);
        }
        return (XFileAttributes)ScriptBytecodeAdapter.castToType(null, XFileAttributes.class);
    }

    protected XFileAttributes readHttpAttributes(Map<String, List<String>> header) {
        List<String> list = header.get("Last-Modified");
        String lastMod = ShortTypeHandling.castToString(list != null ? list.get(0) : null);
        List<String> list2 = header.get("Content-Length");
        String string = list2 != null ? list2.get(0) : null;
        Long l = string != null ? StringGroovyMethods.toLong((CharSequence)((CharSequence)ScriptBytecodeAdapter.castToType((Object)string, CharSequence.class))) : null;
        long contentLen = DefaultTypeTransformation.booleanUnbox(l) ? l : (Long)ScriptBytecodeAdapter.castToType((Object)-1, Long.class);
        SimpleDateFormat dateFormat = new SimpleDateFormat("E, dd MMM yyyy HH:mm:ss Z");
        FileTime modTime = DefaultTypeTransformation.booleanUnbox((Object)lastMod) ? FileTime.from(dateFormat.parse(lastMod).getTime(), TimeUnit.MILLISECONDS) : null;
        return new XFileAttributes(modTime, contentLen);
    }

    public /* synthetic */ Object this$dist$invoke$2(String name, Object args) {
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(XFileSystemProvider.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$2(String name, Object value) {
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, XFileSystemProvider.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$2(String name) {
        return ScriptBytecodeAdapter.getGroovyObjectProperty(XFileSystemProvider.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != XFileSystemProvider.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        Set set;
        ALL_SCHEMES = set = (Set)ScriptBytecodeAdapter.asType((Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{"ftp", "http", "https"}), Set.class);
    }
}

