/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomorin.xseries.profiles.objects;

import com.cryptomorin.xseries.profiles.ProfilesCore;
import com.cryptomorin.xseries.profiles.exceptions.InvalidProfileContainerException;
import com.cryptomorin.xseries.profiles.objects.Profileable;
import com.mojang.authlib.GameProfile;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Skull;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public abstract class ProfileContainer<T>
implements Profileable {
    @Nonnull
    public abstract void setProfile(@Nullable GameProfile var1);

    public abstract T getObject();

    public final String toString() {
        return this.getClass().getSimpleName() + '[' + this.getObject() + ']';
    }

    public static final class BlockStateProfileContainer
    extends ProfileContainer<Skull> {
        private final Skull state;

        public BlockStateProfileContainer(Skull state) {
            this.state = Objects.requireNonNull(state);
        }

        @Override
        public void setProfile(GameProfile profile) {
            try {
                ProfilesCore.CRAFT_SKULL_PROFILE_SETTER.invoke(this.state, profile);
            }
            catch (Throwable throwable) {
                throw new RuntimeException("Unable to set profile " + profile + " to " + this.state, throwable);
            }
        }

        @Override
        public Skull getObject() {
            return this.state;
        }

        @Override
        public GameProfile getProfile() {
            try {
                return ProfilesCore.CRAFT_SKULL_PROFILE_GETTER.invoke(this.state);
            }
            catch (Throwable throwable) {
                throw new RuntimeException("Unable to get profile fr om blockstate: " + this.state, throwable);
            }
        }
    }

    public static final class BlockProfileContainer
    extends ProfileContainer<Block> {
        private final Block block;

        public BlockProfileContainer(Block block) {
            this.block = Objects.requireNonNull(block);
        }

        private Skull getBlockState() {
            BlockState state = this.block.getState();
            if (!(state instanceof Skull)) {
                throw new InvalidProfileContainerException("Block can't contain texture: " + this.block);
            }
            return (Skull)state;
        }

        @Override
        public void setProfile(GameProfile profile) {
            Skull state = this.getBlockState();
            new BlockStateProfileContainer(state).setProfile(profile);
            state.update(true);
        }

        @Override
        public Block getObject() {
            return this.block;
        }

        @Override
        public GameProfile getProfile() {
            return new BlockStateProfileContainer(this.getBlockState()).getProfile();
        }
    }

    public static final class ItemMetaProfileContainer
    extends ProfileContainer<ItemMeta> {
        private final ItemMeta meta;

        public ItemMetaProfileContainer(SkullMeta meta) {
            this.meta = (ItemMeta)Objects.requireNonNull(meta);
        }

        @Override
        public void setProfile(GameProfile profile) {
            try {
                ProfilesCore.CRAFT_META_SKULL_PROFILE_SETTER.invoke(this.meta, profile);
            }
            catch (Throwable throwable) {
                throw new RuntimeException("Unable to set profile " + profile + " to " + this.meta, throwable);
            }
        }

        @Override
        public ItemMeta getObject() {
            return this.meta;
        }

        @Override
        public GameProfile getProfile() {
            try {
                return ProfilesCore.CRAFT_META_SKULL_PROFILE_GETTER.invoke((SkullMeta)this.meta);
            }
            catch (Throwable throwable) {
                throw new RuntimeException("Failed to get profile from item meta: " + this.meta, throwable);
            }
        }
    }

    public static final class ItemStackProfileContainer
    extends ProfileContainer<ItemStack> {
        private final ItemStack itemStack;

        public ItemStackProfileContainer(ItemStack itemStack) {
            this.itemStack = Objects.requireNonNull(itemStack);
        }

        private ItemMetaProfileContainer getMetaContainer(ItemMeta meta) {
            if (!(meta instanceof SkullMeta)) {
                throw new InvalidProfileContainerException("Item can't contain texture: " + this.itemStack);
            }
            return new ItemMetaProfileContainer((SkullMeta)meta);
        }

        @Override
        public void setProfile(GameProfile profile) {
            ItemMeta meta = this.itemStack.getItemMeta();
            this.getMetaContainer(meta).setProfile(profile);
            this.itemStack.setItemMeta(meta);
        }

        @Override
        public ItemStack getObject() {
            return this.itemStack;
        }

        @Override
        public GameProfile getProfile() {
            return this.getMetaContainer(this.itemStack.getItemMeta()).getProfile();
        }
    }
}

