/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomorin.xseries;

import com.cryptomorin.xseries.ReflectionUtils;
import com.cryptomorin.xseries.XSound;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

public final class NMSExtras {
    public static final MethodHandle EXP_PACKET;
    public static final MethodHandle ENTITY_PACKET;
    public static final MethodHandle WORLD_HANDLE;
    public static final MethodHandle ENTITY_HANDLE;
    public static final MethodHandle LIGHTNING_ENTITY;
    public static final MethodHandle VEC3D;
    public static final MethodHandle ANIMATION_PACKET;
    public static final MethodHandle ANIMATION_TYPE;
    public static final MethodHandle ANIMATION_ENTITY_ID;
    public static final MethodHandle PLAY_OUT_MULTI_BLOCK_CHANGE_PACKET;
    public static final MethodHandle MULTI_BLOCK_CHANGE_INFO;
    public static final MethodHandle CHUNK_WRAPPER_SET;
    public static final MethodHandle CHUNK_WRAPPER;
    public static final MethodHandle SHORTS_OR_INFO;
    public static final MethodHandle SET_BLOCK_DATA;
    public static final MethodHandle BLOCK_POSITION;
    public static final MethodHandle PLAY_BLOCK_ACTION;
    public static final MethodHandle GET_BUKKIT_ENTITY;
    public static final MethodHandle GET_BLOCK_TYPE;
    public static final MethodHandle GET_BLOCK;
    public static final Class<?> MULTI_BLOCK_CHANGE_INFO_CLASS;
    public static final Class<?> BLOCK_DATA;

    private NMSExtras() {
    }

    public static void setExp(Player player, float bar, int lvl, int exp) {
        try {
            Object packet = EXP_PACKET.invoke(bar, lvl, exp);
            ReflectionUtils.sendPacket(player, packet);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    public static void lightning(Player player, Location location, boolean sound) {
        NMSExtras.lightning(Collections.singletonList(player), location, sound);
    }

    public static void lightning(Collection<Player> players, Location location, boolean sound) {
        try {
            Object world = WORLD_HANDLE.invoke(location.getWorld());
            if (!ReflectionUtils.supports(16)) {
                Object lightningBolt = LIGHTNING_ENTITY.invoke(world, location.getX(), location.getY(), location.getZ(), false, false);
                Object packet = ENTITY_PACKET.invoke(lightningBolt);
                for (Player player : players) {
                    if (sound) {
                        XSound.ENTITY_LIGHTNING_BOLT_THUNDER.play((Entity)player);
                    }
                    ReflectionUtils.sendPacket(player, packet);
                }
            } else {
                Class<?> nmsEntityType = ReflectionUtils.getNMSClass("world.entity", "EntityTypes");
                Object lightningType = nmsEntityType.getField(ReflectionUtils.supports(17) ? "U" : "LIGHTNING_BOLT").get(nmsEntityType);
                Object lightningBolt = LIGHTNING_ENTITY.invoke(lightningType, world);
                Object lightningBoltID = lightningBolt.getClass().getMethod("getId", new Class[0]).invoke(lightningBolt, new Object[0]);
                Object lightningBoltUUID = lightningBolt.getClass().getMethod("getUniqueID", new Class[0]).invoke(lightningBolt, new Object[0]);
                Object vec3D = VEC3D.invoke(0.0, 0.0, 0.0);
                Object packet = ENTITY_PACKET.invoke(lightningBoltID, lightningBoltUUID, location.getX(), location.getY(), location.getZ(), 0.0f, 0.0f, lightningType, 0, vec3D);
                for (Player player : players) {
                    if (sound) {
                        XSound.ENTITY_LIGHTNING_BOLT_THUNDER.play((Entity)player);
                    }
                    ReflectionUtils.sendPacket(player, packet);
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public static void animation(Collection<? extends Player> players, LivingEntity entity, Animation animation) {
        try {
            Object packet;
            if (ReflectionUtils.supports(17)) {
                packet = ANIMATION_PACKET.invoke(ENTITY_HANDLE.invoke(entity), animation.ordinal());
            } else {
                packet = ANIMATION_PACKET.invoke();
                ANIMATION_TYPE.invoke(packet, animation.ordinal());
                ANIMATION_ENTITY_ID.invoke(packet, entity.getEntityId());
            }
            for (Player player : players) {
                ReflectionUtils.sendPacket(player, packet);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public static void chest(Block chest, boolean open) {
        Location location = chest.getLocation();
        try {
            Object world = WORLD_HANDLE.invoke(location.getWorld());
            Object position = BLOCK_POSITION.invoke(location.getX(), location.getY(), location.getZ());
            Object block = GET_BLOCK.invoke(GET_BLOCK_TYPE.invoke(world, position));
            PLAY_BLOCK_ACTION.invoke(world, position, block, 1, open ? 1 : 0);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    @Deprecated
    protected static void sendBlockChange(Player player, Chunk chunk, Map<WorldlessBlockWrapper, Object> blocks) {
        try {
            Object packet = PLAY_OUT_MULTI_BLOCK_CHANGE_PACKET.invoke();
            if (ReflectionUtils.supports(16)) {
                Object wrapper = CHUNK_WRAPPER.invoke(chunk.getX(), chunk.getZ());
                CHUNK_WRAPPER_SET.invoke(wrapper);
                Object dataArray = Array.newInstance(BLOCK_DATA, blocks.size());
                Object shortArray = Array.newInstance(Short.TYPE, blocks.size());
                int i = 0;
                for (Map.Entry<WorldlessBlockWrapper, Object> entry : blocks.entrySet()) {
                    Block loc = entry.getKey().block;
                    int x = loc.getX() & 0xF;
                    int y = loc.getY() & 0xF;
                    int z = loc.getZ() & 0xF;
                    ++i;
                }
                SHORTS_OR_INFO.invoke(packet, shortArray);
                SET_BLOCK_DATA.invoke(packet, dataArray);
            } else {
                Object wrapper = CHUNK_WRAPPER.invoke(chunk.getX(), chunk.getZ());
                CHUNK_WRAPPER_SET.invoke(wrapper);
                Object array = Array.newInstance(MULTI_BLOCK_CHANGE_INFO_CLASS, blocks.size());
                int i = 0;
                for (Map.Entry<WorldlessBlockWrapper, Object> entry : blocks.entrySet()) {
                    Block loc = entry.getKey().block;
                    int x = loc.getX() & 0xF;
                    int z = loc.getZ() & 0xF;
                    ++i;
                }
                SHORTS_OR_INFO.invoke(packet, array);
            }
            ReflectionUtils.sendPacketSync(player, packet);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    static {
        MULTI_BLOCK_CHANGE_INFO_CLASS = null;
        BLOCK_DATA = ReflectionUtils.getNMSClass("world.level.block.state", "IBlockData");
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        MethodHandle expPacket = null;
        MethodHandle entityPacket = null;
        MethodHandle worldHandle = null;
        MethodHandle entityHandle = null;
        MethodHandle lightning = null;
        MethodHandle vec3D = null;
        MethodHandle animationPacket = null;
        MethodHandle animationType = null;
        MethodHandle animationEntityId = null;
        MethodHandle getBukkitEntity = null;
        MethodHandle blockPosition = null;
        MethodHandle playBlockAction = null;
        MethodHandle getBlockType = null;
        MethodHandle getBlock = null;
        Object playOutMultiBlockChange = null;
        Object multiBlockChangeInfo = null;
        MethodHandle chunkWrapper = null;
        Object chunkWrapperSet = null;
        Object shortsOrInfo = null;
        Object setBlockData = null;
        try {
            Class<?> nmsEntityType = ReflectionUtils.getNMSClass("world.entity", "EntityTypes");
            Class<?> nmsEntity = ReflectionUtils.getNMSClass("world.entity", "Entity");
            Class<?> craftEntity = ReflectionUtils.getCraftClass("entity.CraftEntity");
            Class<?> nmsVec3D = ReflectionUtils.getNMSClass("world.phys", "Vec3D");
            Class<?> world = ReflectionUtils.getNMSClass("world.level", "World");
            getBukkitEntity = lookup.findVirtual(nmsEntity, "getBukkitEntity", MethodType.methodType(craftEntity));
            entityHandle = lookup.findVirtual(craftEntity, "getHandle", MethodType.methodType(nmsEntity));
            expPacket = lookup.findConstructor(ReflectionUtils.getNMSClass("network.protocol.game", "PacketPlayOutExperience"), MethodType.methodType(Void.TYPE, Float.TYPE, Integer.TYPE, Integer.TYPE));
            if (!ReflectionUtils.supports(16)) {
                entityPacket = lookup.findConstructor(ReflectionUtils.getNMSClass("PacketPlayOutSpawnEntityWeather"), MethodType.methodType(Void.TYPE, nmsEntity));
            } else {
                vec3D = lookup.findConstructor(nmsVec3D, MethodType.methodType(Void.TYPE, Double.TYPE, Double.TYPE, Double.TYPE));
                entityPacket = lookup.findConstructor(ReflectionUtils.getNMSClass("network.protocol.game", "PacketPlayOutSpawnEntity"), MethodType.methodType(Void.TYPE, Integer.TYPE, UUID.class, Double.TYPE, Double.TYPE, Double.TYPE, Float.TYPE, Float.TYPE, nmsEntityType, Integer.TYPE, nmsVec3D));
            }
            worldHandle = lookup.findVirtual(ReflectionUtils.getCraftClass("CraftWorld"), "getHandle", MethodType.methodType(ReflectionUtils.getNMSClass("server.level", "WorldServer")));
            lightning = !ReflectionUtils.supports(16) ? lookup.findConstructor(ReflectionUtils.getNMSClass("world.entity", "EntityLightning"), MethodType.methodType(Void.TYPE, world, Double.TYPE, Double.TYPE, Double.TYPE, Boolean.TYPE, Boolean.TYPE)) : lookup.findConstructor(ReflectionUtils.getNMSClass("world.entity", "EntityLightning"), MethodType.methodType(Void.TYPE, nmsEntityType, world));
            Class<?> playOutMultiBlockChangeClass = ReflectionUtils.getNMSClass("network.protocol.game", "PacketPlayOutMultiBlockChange");
            Class<?> chunkCoordIntPairClass = ReflectionUtils.getNMSClass("world.level", "ChunkCoordIntPair");
            try {
                if (!ReflectionUtils.supports(16)) {
                    chunkWrapper = lookup.findConstructor(chunkCoordIntPairClass, MethodType.methodType(Void.TYPE, Integer.TYPE, Integer.TYPE));
                }
            }
            catch (IllegalAccessException | NoSuchMethodException e) {
                e.printStackTrace();
            }
            Class<?> animation = ReflectionUtils.getNMSClass("network.protocol.game", "PacketPlayOutAnimation");
            animationPacket = lookup.findConstructor(animation, ReflectionUtils.supports(17) ? MethodType.methodType(Void.TYPE, nmsEntity, Integer.TYPE) : MethodType.methodType(Void.TYPE));
            if (!ReflectionUtils.supports(17)) {
                Field field = animation.getDeclaredField("a");
                field.setAccessible(true);
                animationEntityId = lookup.unreflectSetter(field);
                field = animation.getDeclaredField("b");
                field.setAccessible(true);
                animationType = lookup.unreflectSetter(field);
            }
            Class<?> blockPos = ReflectionUtils.getNMSClass("core", "BlockPosition");
            Class<?> block = ReflectionUtils.getNMSClass("world.level.block", "Block");
            blockPosition = lookup.findConstructor(blockPos, MethodType.methodType(Void.TYPE, Double.TYPE, Double.TYPE, Double.TYPE));
            getBlockType = lookup.findVirtual(world, "getType", MethodType.methodType(BLOCK_DATA, blockPos));
            getBlock = lookup.findVirtual(BLOCK_DATA, "getBlock", MethodType.methodType(block));
            playBlockAction = lookup.findVirtual(world, "playBlockAction", MethodType.methodType(Void.TYPE, blockPos, block, Integer.TYPE, Integer.TYPE));
        }
        catch (IllegalAccessException | NoSuchFieldException | NoSuchMethodException ex) {
            ex.printStackTrace();
        }
        EXP_PACKET = expPacket;
        ENTITY_PACKET = entityPacket;
        WORLD_HANDLE = worldHandle;
        ENTITY_HANDLE = entityHandle;
        LIGHTNING_ENTITY = lightning;
        VEC3D = vec3D;
        ANIMATION_PACKET = animationPacket;
        ANIMATION_TYPE = animationType;
        ANIMATION_ENTITY_ID = animationEntityId;
        BLOCK_POSITION = blockPosition;
        PLAY_BLOCK_ACTION = playBlockAction;
        GET_BLOCK_TYPE = getBlockType;
        GET_BLOCK = getBlock;
        GET_BUKKIT_ENTITY = getBukkitEntity;
        PLAY_OUT_MULTI_BLOCK_CHANGE_PACKET = playOutMultiBlockChange;
        MULTI_BLOCK_CHANGE_INFO = multiBlockChangeInfo;
        CHUNK_WRAPPER = chunkWrapper;
        CHUNK_WRAPPER_SET = chunkWrapperSet;
        SHORTS_OR_INFO = shortsOrInfo;
        SET_BLOCK_DATA = setBlockData;
    }

    public static class WorldlessBlockWrapper {
        public final Block block;

        public WorldlessBlockWrapper(Block block) {
            this.block = block;
        }

        public int hashCode() {
            return (this.block.getY() + this.block.getZ() * 31) * 31 + this.block.getX();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Block)) {
                return false;
            }
            Block other = (Block)obj;
            return this.block.getX() == other.getX() && this.block.getY() == other.getY() && this.block.getZ() == other.getZ();
        }
    }

    public static enum Animation {
        SWING_MAIN_ARM,
        HURT,
        LEAVE_BED,
        SWING_OFF_HAND,
        CRITICAL_EFFECT,
        MAGIC_CRITICAL_EFFECT;

    }
}

