/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomorin.xseries;

import com.cryptomorin.xseries.XMaterial;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.lang.Validate;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.TreeSpecies;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.Ageable;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Levelled;
import org.bukkit.block.data.Lightable;
import org.bukkit.block.data.Openable;
import org.bukkit.block.data.Powerable;
import org.bukkit.block.data.Rotatable;
import org.bukkit.block.data.type.Cake;
import org.bukkit.block.data.type.EndPortalFrame;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.material.Colorable;
import org.bukkit.material.Directional;
import org.bukkit.material.MaterialData;
import org.bukkit.material.Wood;
import org.bukkit.material.Wool;

public final class XBlock {
    public static final Set<XMaterial> CROPS = Collections.unmodifiableSet(EnumSet.of(XMaterial.CARROT, new XMaterial[]{XMaterial.POTATO, XMaterial.NETHER_WART, XMaterial.WHEAT_SEEDS, XMaterial.PUMPKIN_SEEDS, XMaterial.MELON_SEEDS, XMaterial.BEETROOT_SEEDS, XMaterial.SUGAR_CANE, XMaterial.BAMBOO_SAPLING, XMaterial.CHORUS_PLANT, XMaterial.KELP, XMaterial.SEA_PICKLE, XMaterial.BROWN_MUSHROOM, XMaterial.RED_MUSHROOM}));
    public static final Set<XMaterial> DANGEROUS = Collections.unmodifiableSet(EnumSet.of(XMaterial.MAGMA_BLOCK, XMaterial.LAVA, XMaterial.CAMPFIRE, XMaterial.FIRE, XMaterial.SOUL_FIRE));
    public static final byte CAKE_SLICES = 6;
    private static final boolean ISFLAT = XMaterial.supports(13);

    private XBlock() {
    }

    public static boolean isLit(Block block) {
        if (ISFLAT) {
            if (!(block.getBlockData() instanceof Lightable)) {
                return false;
            }
            Lightable lightable = (Lightable)block.getBlockData();
            return lightable.isLit();
        }
        return XBlock.isMaterial(block, BlockMaterial.REDSTONE_LAMP_ON, BlockMaterial.REDSTONE_TORCH_ON, BlockMaterial.BURNING_FURNACE);
    }

    public static boolean isContainer(@Nullable Block block) {
        return block != null && block.getState() instanceof InventoryHolder;
    }

    public static void setLit(Block block, boolean lit) {
        if (ISFLAT) {
            if (!(block.getBlockData() instanceof Lightable)) {
                return;
            }
            Lightable lightable = (Lightable)block.getBlockData();
            lightable.setLit(lit);
            return;
        }
        String name = block.getType().name();
        if (name.endsWith("FURNACE")) {
            block.setType(BlockMaterial.BURNING_FURNACE.material);
        } else if (name.startsWith("REDSTONE_LAMP")) {
            block.setType(BlockMaterial.REDSTONE_LAMP_ON.material);
        } else {
            block.setType(BlockMaterial.REDSTONE_TORCH_ON.material);
        }
    }

    public static boolean isCrop(XMaterial material) {
        return CROPS.contains((Object)material);
    }

    public static boolean isDangerous(XMaterial material) {
        return DANGEROUS.contains((Object)material);
    }

    public static DyeColor getColor(Block block) {
        if (ISFLAT) {
            if (!(block.getBlockData() instanceof Colorable)) {
                return null;
            }
            Colorable colorable = (Colorable)block.getBlockData();
            return colorable.getColor();
        }
        BlockState state = block.getState();
        MaterialData data = state.getData();
        if (data instanceof Wool) {
            Wool wool = (Wool)data;
            return wool.getColor();
        }
        return null;
    }

    public static boolean isCake(@Nullable Material material) {
        return material == Material.CAKE || material == BlockMaterial.CAKE_BLOCK.material;
    }

    public static boolean isWheat(@Nullable Material material) {
        return material == Material.WHEAT || material == BlockMaterial.CROPS.material;
    }

    public static boolean isSugarCane(@Nullable Material material) {
        return material == Material.SUGAR_CANE || material == BlockMaterial.SUGAR_CANE_BLOCK.material;
    }

    public static boolean isBeetroot(@Nullable Material material) {
        return material == Material.BEETROOT || material == Material.BEETROOTS || material == BlockMaterial.BEETROOT_BLOCK.material;
    }

    public static boolean isNetherWart(@Nullable Material material) {
        return material == Material.NETHER_WART || material == BlockMaterial.NETHER_WARTS.material;
    }

    public static boolean isCarrot(@Nullable Material material) {
        return material == Material.CARROT || material == Material.CARROTS;
    }

    public static boolean isMelon(@Nullable Material material) {
        return material == Material.MELON || material == Material.MELON_SLICE || material == BlockMaterial.MELON_BLOCK.material;
    }

    public static boolean isPotato(@Nullable Material material) {
        return material == Material.POTATO || material == Material.POTATOES;
    }

    public static BlockFace getDirection(Block block) {
        if (ISFLAT) {
            if (!(block.getBlockData() instanceof org.bukkit.block.data.Directional)) {
                return BlockFace.SELF;
            }
            org.bukkit.block.data.Directional direction = (org.bukkit.block.data.Directional)block.getBlockData();
            return direction.getFacing();
        }
        BlockState state = block.getState();
        MaterialData data = state.getData();
        if (data instanceof Directional) {
            return ((Directional)data).getFacing();
        }
        return BlockFace.SELF;
    }

    public static boolean setDirection(Block block, BlockFace facing) {
        if (ISFLAT) {
            if (!(block.getBlockData() instanceof org.bukkit.block.data.Directional)) {
                return false;
            }
            org.bukkit.block.data.Directional direction = (org.bukkit.block.data.Directional)block.getBlockData();
            direction.setFacing(facing);
            return true;
        }
        BlockState state = block.getState();
        MaterialData data = state.getData();
        if (data instanceof Directional) {
            ((Directional)data).setFacingDirection(facing);
            state.update(true);
            return true;
        }
        return false;
    }

    private static String getMetaString(XMaterial material) {
        return material.name().substring(0, material.name().indexOf(95));
    }

    public static boolean setType(Block block, XMaterial material) {
        block.setType(material.parseMaterial());
        if (XMaterial.supports(13)) {
            return false;
        }
        BlockState state = block.getState();
        MaterialData data = state.getData();
        boolean update = false;
        if (data instanceof Wood) {
            Wood wood = (Wood)data;
            wood.setSpecies(TreeSpecies.valueOf((String)XBlock.getMetaString(material)));
            update = true;
        } else if (data instanceof Colorable) {
            ((Colorable)data).setColor(DyeColor.valueOf((String)XBlock.getMetaString(material)));
            update = true;
        }
        if (update) {
            state.update();
        }
        return update;
    }

    public static int getAge(Block block) {
        if (ISFLAT) {
            if (!(block.getBlockData() instanceof Ageable)) {
                return 0;
            }
            Ageable ageable = (Ageable)block.getBlockData();
            return ageable.getAge();
        }
        BlockState state = block.getState();
        MaterialData data = state.getData();
        return data.getData();
    }

    public static void setAge(Block block, int age) {
        if (ISFLAT) {
            if (!(block.getBlockData() instanceof Ageable)) {
                return;
            }
            Ageable ageable = (Ageable)block.getBlockData();
            ageable.setAge(age);
        }
        BlockState state = block.getState();
        MaterialData data = state.getData();
        data.setData((byte)age);
        state.update(true);
    }

    public static boolean setColor(Block block, DyeColor color) {
        if (ISFLAT) {
            String type = block.getType().name();
            int index = type.indexOf(95);
            if (index == -1) {
                return false;
            }
            String realType = type.substring(index);
            Material material = Material.getMaterial((String)(color.name() + '_' + realType));
            if (material == null) {
                return false;
            }
            block.setType(material);
            return true;
        }
        BlockState state = block.getState();
        state.setRawData(color.getWoolData());
        state.update(true);
        return false;
    }

    public static boolean setFluidLevel(Block block, int level) {
        if (ISFLAT) {
            if (!(block.getBlockData() instanceof Levelled)) {
                return false;
            }
            Levelled levelled = (Levelled)block.getBlockData();
            levelled.setLevel(level);
            return true;
        }
        BlockState state = block.getState();
        MaterialData data = state.getData();
        data.setData((byte)level);
        state.update(true);
        return false;
    }

    public static int getFluidLevel(Block block) {
        if (ISFLAT) {
            if (!(block.getBlockData() instanceof Levelled)) {
                return -1;
            }
            Levelled levelled = (Levelled)block.getBlockData();
            return levelled.getLevel();
        }
        BlockState state = block.getState();
        MaterialData data = state.getData();
        return data.getData();
    }

    public static boolean isWaterStationary(Block block) {
        return ISFLAT ? XBlock.getFluidLevel(block) < 7 : block.getType() == BlockMaterial.STATIONARY_WATER.material;
    }

    public static boolean isWater(Material material) {
        return material == Material.WATER || material == BlockMaterial.STATIONARY_WATER.material;
    }

    public static boolean isLava(Material material) {
        return material == Material.LAVA || material == BlockMaterial.STATIONARY_LAVA.material;
    }

    public static boolean isOneOf(Block block, Collection<String> blocks) {
        if (blocks == null || blocks.isEmpty()) {
            return false;
        }
        String name = block.getType().name();
        XMaterial matched = XMaterial.matchXMaterial(block.getType());
        for (String comp : blocks) {
            Optional<XMaterial> xMat;
            String checker = comp.toUpperCase(Locale.ENGLISH);
            if (!(checker.startsWith("CONTAINS:") ? name.contains(comp = XMaterial.format(checker.substring(9))) : (checker.startsWith("REGEX:") ? name.matches(comp = comp.substring(6)) : (xMat = XMaterial.matchXMaterial(comp)).isPresent() && (matched == xMat.get() || XBlock.isType(block, xMat.get()))))) continue;
            return true;
        }
        return false;
    }

    public static void setCakeSlices(Block block, int amount) {
        Validate.isTrue((boolean)XBlock.isCake(block.getType()), (String)("Block is not a cake: " + block.getType()));
        if (ISFLAT) {
            BlockData bd = block.getBlockData();
            Cake cake = (Cake)bd;
            int remaining = cake.getMaximumBites() - (cake.getBites() + amount);
            if (remaining > 0) {
                cake.setBites(remaining);
                block.setBlockData(bd);
            } else {
                block.breakNaturally();
            }
            return;
        }
        BlockState state = block.getState();
        org.bukkit.material.Cake cake = (org.bukkit.material.Cake)state.getData();
        if (amount > 0) {
            cake.setSlicesRemaining(amount);
            state.update(true);
        } else {
            block.breakNaturally();
        }
    }

    public static int addCakeSlices(Block block, int slices) {
        Validate.isTrue((boolean)XBlock.isCake(block.getType()), (String)("Block is not a cake: " + block.getType()));
        if (ISFLAT) {
            BlockData bd = block.getBlockData();
            Cake cake = (Cake)bd;
            int bites = cake.getBites() - slices;
            int remaining = cake.getMaximumBites() - bites;
            if (remaining > 0) {
                cake.setBites(bites);
                block.setBlockData(bd);
                return remaining;
            }
            block.breakNaturally();
            return 0;
        }
        BlockState state = block.getState();
        org.bukkit.material.Cake cake = (org.bukkit.material.Cake)state.getData();
        int remaining = cake.getSlicesRemaining() + slices;
        if (remaining > 0) {
            cake.setSlicesRemaining(remaining);
            state.update(true);
            return remaining;
        }
        block.breakNaturally();
        return 0;
    }

    public static boolean setWooden(Block block, XMaterial species) {
        block.setType(species.parseMaterial());
        if (ISFLAT) {
            return true;
        }
        TreeSpecies type = species == XMaterial.SPRUCE_LOG ? TreeSpecies.REDWOOD : TreeSpecies.valueOf((String)XBlock.getMetaString(species));
        BlockState state = block.getState();
        MaterialData data = state.getData();
        ((Wood)data).setSpecies(type);
        state.update(true);
        return true;
    }

    public static void setEnderPearlOnFrame(Block endPortalFrame, boolean eye) {
        BlockState state = endPortalFrame.getState();
        if (ISFLAT) {
            BlockData data = state.getBlockData();
            EndPortalFrame frame = (EndPortalFrame)data;
            frame.setEye(eye);
            state.setBlockData(data);
        } else {
            state.setRawData((byte)(eye ? 4 : 0));
        }
        state.update(true);
    }

    @Deprecated
    public static XMaterial getType(Block block) {
        byte dataValue;
        if (ISFLAT) {
            return XMaterial.matchXMaterial(block.getType());
        }
        String type = block.getType().name();
        BlockState state = block.getState();
        MaterialData data = state.getData();
        if (data instanceof Wood) {
            TreeSpecies species = ((Wood)data).getSpecies();
            dataValue = species.getData();
        } else if (data instanceof Colorable) {
            DyeColor color = ((Colorable)data).getColor();
            dataValue = color.getDyeData();
        } else {
            dataValue = data.getData();
        }
        return XMaterial.matchDefinedXMaterial(type, dataValue).orElseThrow(() -> new IllegalArgumentException("Unsupported material for block " + dataValue + ": " + block.getType().name()));
    }

    public static boolean isSimilar(Block block, XMaterial material) {
        return material == XMaterial.matchXMaterial(block.getType()) || XBlock.isType(block, material);
    }

    public static boolean isType(Block block, XMaterial material) {
        Material mat = block.getType();
        switch (material) {
            case CAKE: {
                return XBlock.isCake(mat);
            }
            case NETHER_WART: {
                return XBlock.isNetherWart(mat);
            }
            case MELON: 
            case MELON_SLICE: {
                return XBlock.isMelon(mat);
            }
            case CARROT: 
            case CARROTS: {
                return XBlock.isCarrot(mat);
            }
            case POTATO: 
            case POTATOES: {
                return XBlock.isPotato(mat);
            }
            case WHEAT: 
            case WHEAT_SEEDS: {
                return XBlock.isWheat(mat);
            }
            case BEETROOT: 
            case BEETROOT_SEEDS: 
            case BEETROOTS: {
                return XBlock.isBeetroot(mat);
            }
            case SUGAR_CANE: {
                return XBlock.isSugarCane(mat);
            }
            case WATER: {
                return XBlock.isWater(mat);
            }
            case LAVA: {
                return XBlock.isLava(mat);
            }
            case AIR: 
            case CAVE_AIR: 
            case VOID_AIR: {
                return XBlock.isAir(mat);
            }
        }
        return false;
    }

    public static boolean isAir(@Nullable Material material) {
        if (ISFLAT) {
            switch (material) {
                case AIR: 
                case CAVE_AIR: 
                case VOID_AIR: {
                    return true;
                }
            }
            return false;
        }
        return material == Material.AIR;
    }

    public static boolean isPowered(Block block) {
        if (ISFLAT) {
            if (!(block.getBlockData() instanceof Powerable)) {
                return false;
            }
            Powerable powerable = (Powerable)block.getBlockData();
            return powerable.isPowered();
        }
        String name = block.getType().name();
        if (name.startsWith("REDSTONE_COMPARATOR")) {
            return block.getType() == BlockMaterial.REDSTONE_COMPARATOR_ON.material;
        }
        return false;
    }

    public static void setPowered(Block block, boolean powered) {
        if (ISFLAT) {
            if (!(block.getBlockData() instanceof Powerable)) {
                return;
            }
            Powerable powerable = (Powerable)block.getBlockData();
            powerable.setPowered(powered);
            return;
        }
        String name = block.getType().name();
        if (name.startsWith("REDSTONE_COMPARATOR")) {
            block.setType(BlockMaterial.REDSTONE_COMPARATOR_ON.material);
        }
    }

    public static boolean isOpen(Block block) {
        if (ISFLAT) {
            if (!(block.getBlockData() instanceof Openable)) {
                return false;
            }
            Openable openable = (Openable)block.getBlockData();
            return openable.isOpen();
        }
        BlockState state = block.getState();
        if (!(state instanceof org.bukkit.material.Openable)) {
            return false;
        }
        org.bukkit.material.Openable openable = (org.bukkit.material.Openable)state.getData();
        return openable.isOpen();
    }

    public static void setOpened(Block block, boolean opened) {
        if (ISFLAT) {
            if (!(block.getBlockData() instanceof Openable)) {
                return;
            }
            Openable openable = (Openable)block.getBlockData();
            openable.setOpen(opened);
            return;
        }
        BlockState state = block.getState();
        if (!(state instanceof org.bukkit.material.Openable)) {
            return;
        }
        org.bukkit.material.Openable openable = (org.bukkit.material.Openable)state.getData();
        openable.setOpen(opened);
        state.setData((MaterialData)openable);
        state.update();
    }

    public static BlockFace getRotation(Block block) {
        if (ISFLAT) {
            if (!(block.getBlockData() instanceof Rotatable)) {
                return null;
            }
            Rotatable rotatable = (Rotatable)block.getBlockData();
            return rotatable.getRotation();
        }
        return null;
    }

    public static void setRotation(Block block, BlockFace facing) {
        if (ISFLAT) {
            if (!(block.getBlockData() instanceof Rotatable)) {
                return;
            }
            Rotatable rotatable = (Rotatable)block.getBlockData();
            rotatable.setRotation(facing);
        }
    }

    private static boolean isMaterial(Block block, BlockMaterial ... materials) {
        Material type = block.getType();
        for (BlockMaterial material : materials) {
            if (type != material.material) continue;
            return true;
        }
        return false;
    }

    public static enum BlockMaterial {
        CAKE_BLOCK,
        CROPS,
        SUGAR_CANE_BLOCK,
        BEETROOT_BLOCK,
        NETHER_WARTS,
        MELON_BLOCK,
        BURNING_FURNACE,
        STATIONARY_WATER,
        STATIONARY_LAVA,
        REDSTONE_LAMP_ON,
        REDSTONE_LAMP_OFF,
        REDSTONE_TORCH_ON,
        REDSTONE_TORCH_OFF,
        REDSTONE_COMPARATOR_ON,
        REDSTONE_COMPARATOR_OFF;

        @Nullable
        private final Material material = Material.getMaterial((String)this.name());
    }
}

