/*
 * Decompiled with CFR 0.152.
 */
package com.github.cukedoctor.i18n;

import com.github.cukedoctor.api.model.Feature;
import com.github.cukedoctor.util.Assert;
import com.github.cukedoctor.util.Constants;
import com.github.cukedoctor.util.FileUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;

public class I18nLoader
extends ResourceBundle.Control {
    private static I18nLoader instance;
    private static Logger log;
    private ResourceBundle bundle;

    private I18nLoader() {
    }

    public static synchronized I18nLoader instance(List<Feature> features) {
        if (instance == null) {
            instance = new I18nLoader();
            instance.init(features);
        }
        return instance;
    }

    public static synchronized I18nLoader newInstance(List<Feature> features) {
        instance = null;
        return I18nLoader.instance(features);
    }

    public String getMessage(String key) {
        try {
            return this.bundle.getString(key);
        }
        catch (MissingResourceException e) {
            return "??" + key + "??";
        }
    }

    public String getMessage(String key, Object ... params) {
        return MessageFormat.format(this.getMessage(key), params);
    }

    private void init(List<Feature> features) {
        String lang = this.resolveFeatureLanguage(features);
        if (!Assert.hasText(lang)) {
            lang = "en";
        }
        if (lang != null && this.bundle == null) {
            InputStream stream = this.findCukedoctorProperties(Constants.BASE_DIR);
            if (stream == null) {
                String bundleName = this.toBundleName("/i18n/cukedoctor", Locale.forLanguageTag(lang));
                String resourceName = this.toResourceName(bundleName, "properties");
                stream = I18nLoader.class.getResourceAsStream(resourceName);
            }
            try {
                this.bundle = new PropertyResourceBundle(new InputStreamReader(stream, "UTF-8"));
            }
            catch (Exception e) {
                log.warning(String.format("No resource bundle found for language %s. Using 'cukedoctor_en.properties' as default bundle.", lang));
                try {
                    this.bundle = new PropertyResourceBundle(new InputStreamReader(I18nLoader.class.getResourceAsStream("/i18n/cukedoctor_en.properties"), "UTF-8"));
                }
                catch (Exception e1) {
                    throw new RuntimeException("Could not find cukedoctor resource bundle", e1);
                }
            }
        }
    }

    private String resolveFeatureLanguage(List<Feature> features) {
        if (features != null) {
            for (Feature feature : features) {
                if (!Assert.hasText(feature.getLanguage())) continue;
                return feature.getLanguage();
            }
        }
        return null;
    }

    private InputStream findCukedoctorProperties(String baseDir) {
        List<String> files = FileUtil.findFiles(baseDir, "cukedoctor.properties", true);
        if (files != null && !files.isEmpty()) {
            String path = files.get(0);
            log.fine("Loading cukedoctor resource bundle from: " + path);
            File file = new File(path);
            try {
                return new FileInputStream(file);
            }
            catch (Exception e) {
                log.log(Level.WARNING, "Could not load resource bundle from target folder", e);
            }
        }
        return null;
    }

    static {
        log = Logger.getLogger(I18nLoader.class.getName());
    }
}

