/*
 * Decompiled with CFR 0.152.
 */
package com.github.cukedoctor.util.builder;

import com.github.cukedoctor.api.model.Match;
import com.github.cukedoctor.api.model.Result;
import com.github.cukedoctor.api.model.Status;
import com.github.cukedoctor.api.model.Step;

public class StepBuilder {
    private Step step;
    private static StepBuilder instance;

    private StepBuilder(Step step) {
        this.step = step;
    }

    private Step getStep() {
        return this.step;
    }

    public static synchronized StepBuilder instance() {
        instance = new StepBuilder(new Step());
        return instance;
    }

    public StepBuilder keyword(String keyword) {
        this.step.setKeyword(keyword);
        return instance;
    }

    public StepBuilder name(String name) {
        this.step.setName(name);
        return instance;
    }

    public StepBuilder match(Match match) {
        this.step.setMatch(match);
        return instance;
    }

    public StepBuilder result(Result result) {
        this.step.setResult(result);
        return instance;
    }

    public StepBuilder status(Status status) {
        if (this.step.getResult() == null) {
            this.step.setResult(new Result());
        }
        this.step.getResult().setStatus(status);
        return instance;
    }

    public StepBuilder durations(long duration) {
        if (this.step.getResult() == null) {
            this.step.setResult(new Result());
        }
        this.step.getResult().setDuration(duration);
        return instance;
    }

    public Step build() {
        return this.getStep();
    }
}

