/*
 * Decompiled with CFR 0.152.
 */
package com.github.cukedoctor;

import com.github.cukedoctor.api.CukedoctorConverter;
import com.github.cukedoctor.api.CukedoctorDocumentBuilder;
import com.github.cukedoctor.api.DocumentAttributes;
import com.github.cukedoctor.api.model.Feature;
import com.github.cukedoctor.config.CukedoctorConfig;
import com.github.cukedoctor.converter.CukedoctorConverterImpl;
import com.github.cukedoctor.util.Assert;
import java.util.List;

public class Cukedoctor {
    public static CukedoctorConverter instance(List<Feature> features, DocumentAttributes attrs, CukedoctorConfig cukedoctorConfig, CukedoctorDocumentBuilder docBuilder) {
        if (!Assert.hasElements(features)) {
            throw new RuntimeException("No features found");
        }
        CukedoctorConverterImpl instance = new CukedoctorConverterImpl(features, attrs, cukedoctorConfig, docBuilder);
        instance.setFilename(instance.getDocumentationTitle().replaceAll(" ", "_") + ".adoc");
        return instance;
    }

    public static CukedoctorConverter instance(List<Feature> features, DocumentAttributes attrs, CukedoctorConfig cukedoctorConfig) {
        return Cukedoctor.instance(features, attrs, cukedoctorConfig, CukedoctorDocumentBuilder.Factory.newInstance());
    }

    public static CukedoctorConverter instance(List<Feature> features, DocumentAttributes attrs) {
        return Cukedoctor.instance(features, attrs, Cukedoctor.getDefaultConfig());
    }

    public static CukedoctorConverter instance(List<Feature> features, CukedoctorDocumentBuilder docBuilder) {
        return Cukedoctor.instance(features, Cukedoctor.getDefaultDocumentAttributes(), Cukedoctor.getDefaultConfig(), docBuilder);
    }

    public static CukedoctorConverter instance(List<Feature> features) {
        return Cukedoctor.instance(features, Cukedoctor.getDefaultDocumentAttributes());
    }

    public static DocumentAttributes getDefaultDocumentAttributes() {
        return null;
    }

    public static CukedoctorConfig getDefaultConfig() {
        return new CukedoctorConfig();
    }
}

