/*
 * Decompiled with CFR 0.152.
 */
package com.github.cukedoctor.api.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.github.cukedoctor.util.Assert;
import java.util.Optional;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Comment {
    private String value;
    private Integer line;

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public Integer getLine() {
        return this.line;
    }

    public void setLine(Integer line) {
        this.line = line;
    }

    public Optional<String> getLanguage() {
        return this.extractPattern("language: ");
    }

    protected Optional<String> extractPattern(String pattern) {
        int indexOfLanguage = this.value.indexOf(pattern);
        if (Assert.hasText(this.value) && indexOfLanguage != -1) {
            return Optional.of(this.value.substring(indexOfLanguage + pattern.length()).trim());
        }
        return Optional.empty();
    }

    public Optional<String> getOrder() {
        return this.extractPattern("order: ");
    }

    public String toString() {
        return this.value;
    }
}

