/*
 * Decompiled with CFR 0.152.
 */
package com.github.cukedoctor.builder;

import com.github.cukedoctor.api.builder.AttributesBuilder;
import com.github.cukedoctor.util.Assert;
import com.github.cukedoctor.util.Constants;
import io.github.robwin.markup.builder.asciidoc.AsciiDocBuilder;

public class AttributesBuilderImpl
implements AttributesBuilder {
    private AsciiDocBuilder docBuilder;

    public AttributesBuilderImpl(AsciiDocBuilder docBuilder) {
        this.docBuilder = docBuilder;
    }

    @Override
    public AttributesBuilder toc(String value) {
        this.docBuilder.textLine(Constants.Attributes.toc(value));
        return this;
    }

    @Override
    public AttributesBuilder backend(String value) {
        this.docBuilder.textLine(Constants.Attributes.backend(value));
        return this;
    }

    @Override
    public AttributesBuilder docTitle(String value) {
        this.docBuilder.textLine(Constants.Attributes.docTitle(value));
        return this;
    }

    @Override
    public AttributesBuilder docType(String value) {
        this.docBuilder.textLine(Constants.Attributes.docType(value));
        return this;
    }

    @Override
    public AttributesBuilder icons(String value) {
        this.docBuilder.textLine(Constants.Attributes.icons(value));
        return this;
    }

    @Override
    public AttributesBuilder numbered(boolean value) {
        this.docBuilder.textLine(Constants.Attributes.numbered(value));
        return this;
    }

    @Override
    public AttributesBuilder linkcss(boolean value) {
        this.docBuilder.textLine(Constants.Attributes.linkcss(value));
        return this;
    }

    @Override
    public AttributesBuilder sectAnchors(boolean value) {
        this.docBuilder.textLine(Constants.Attributes.sectAnchors(value));
        return this;
    }

    @Override
    public AttributesBuilder sectLink(boolean value) {
        this.docBuilder.textLine(Constants.Attributes.sectLink(value));
        return this;
    }

    @Override
    public AttributesBuilder docInfo(boolean value) {
        this.docBuilder.textLine(Constants.Attributes.docInfo(value));
        return this;
    }

    @Override
    public AttributesBuilder hardBreaks(boolean value) {
        this.docBuilder.textLine(Constants.Attributes.hardBreaks(value));
        return this;
    }

    @Override
    public AttributesBuilder sourceHighlighter(String value) {
        this.docBuilder.textLine(Constants.Attributes.sourceHighlighter(value));
        return this;
    }

    @Override
    public AttributesBuilder tocLevels(String value) {
        this.docBuilder.textLine(Constants.Attributes.tocLevels(value));
        return this;
    }

    @Override
    public AttributesBuilder chapterLabel(String value) {
        this.docBuilder.textLine(Constants.Attributes.chapterLabel(value));
        return this;
    }

    @Override
    public AttributesBuilder versionLabel(String value) {
        this.docBuilder.textLine(Constants.Attributes.versionLabel(value));
        return this;
    }

    @Override
    public AttributesBuilder pdfStyle(String value) {
        if (!Assert.hasText(value)) {
            return this;
        }
        this.docBuilder.textLine(Constants.Attributes.pdfStyle(value));
        return this;
    }

    @Override
    public AttributesBuilder stem(String value) {
        if (!Assert.hasText(value)) {
            return this;
        }
        this.docBuilder.textLine(Constants.Attributes.stem(value));
        return this;
    }

    @Override
    public AttributesBuilder allowUriRead(Boolean value) {
        if (value != null) {
            this.docBuilder.textLine(Constants.Attributes.allowUriRead(value));
        }
        return this;
    }

    @Override
    public AsciiDocBuilder asciiDocBuilder() {
        return this.docBuilder;
    }

    @Override
    public AttributesBuilder revNumber(String value) {
        if (Assert.hasText(value)) {
            this.docBuilder.textLine(Constants.Attributes.revNumber(value));
        } else {
            String revNumberSysProp = System.getProperty("docVersion");
            if (revNumberSysProp != null) {
                this.docBuilder.textLine(Constants.Attributes.revNumber(revNumberSysProp));
            }
        }
        return this;
    }
}

