/*
 * Decompiled with CFR 0.152.
 */
package com.github.cukedoctor.renderer;

import com.github.cukedoctor.api.CukedoctorDocumentBuilder;
import com.github.cukedoctor.api.DocumentAttributes;
import com.github.cukedoctor.api.model.Feature;
import com.github.cukedoctor.api.model.Scenario;
import com.github.cukedoctor.config.CukedoctorConfig;
import com.github.cukedoctor.renderer.AbstractBaseRenderer;
import com.github.cukedoctor.renderer.CukedoctorScenarioRenderer;
import com.github.cukedoctor.spi.FeatureRenderer;
import com.github.cukedoctor.spi.ScenarioRenderer;
import com.github.cukedoctor.util.Assert;
import com.github.cukedoctor.util.Constants;
import com.github.cukedoctor.util.ServiceLoaderUtil;
import com.github.cukedoctor.util.StringUtil;
import java.util.List;

public class CukedoctorFeatureRenderer
extends AbstractBaseRenderer
implements FeatureRenderer {
    ScenarioRenderer scenarioRenderer;

    public CukedoctorFeatureRenderer() {
    }

    public CukedoctorFeatureRenderer(DocumentAttributes documentAttributes) {
        this.setDocumentAttributes(documentAttributes);
    }

    public CukedoctorFeatureRenderer(CukedoctorConfig cukedoctorConfig) {
        this.cukedoctorConfig = cukedoctorConfig;
    }

    @Override
    public String renderFeature(Feature feature) {
        String backend;
        this.loadDependentRenderers();
        CukedoctorDocumentBuilder builder = this.docBuilder.createPeerBuilder();
        if (feature.hasIgnoreDocsTag()) {
            return "";
        }
        builder.textLine(this.renderFeatureSectionId(feature));
        builder.title(Constants.Markup.bold(feature.getName())).newLine();
        if (Assert.notNull(this.documentAttributes) && Assert.hasText(this.documentAttributes.getBackend()) && ((backend = this.documentAttributes.getBackend()).toLowerCase().contains("html") || backend.toLowerCase().contains("all")) && !this.cukedoctorConfig.isDisableMinMaxExtension().booleanValue()) {
            builder.append("ifndef::backend-pdf[]").append(Constants.newLine());
            builder.append("minmax::", feature.getName().replaceAll(",", "").replaceAll(" ", "-")).append("[]").newLine();
            builder.append("endif::[]").append(Constants.newLine());
        }
        if (Assert.hasText(feature.getDescription())) {
            String description = StringUtil.trimAllLines(feature.getDescription()).replaceAll("\\\\", "");
            this.renderDescription(builder, description);
        }
        if (feature.hasScenarios()) {
            builder.append(this.renderFeatureScenarios(feature, builder));
        }
        return builder.toString();
    }

    protected void renderDescription(CukedoctorDocumentBuilder builder, String description) {
        builder.sideBarBlock(description);
    }

    @Override
    public String renderFeatures(List<Feature> features) {
        this.loadDependentRenderers();
        this.docBuilder.clear();
        if (!this.cukedoctorConfig.isHideFeaturesSection().booleanValue()) {
            this.docBuilder.titleThenNest(Constants.Markup.bold(this.i18n.getMessage("title.features"))).newLine();
        }
        for (Feature feature : features) {
            this.docBuilder.append(this.renderFeature(feature));
        }
        return this.docBuilder.toString();
    }

    protected String renderFeatureScenarios(Feature feature, CukedoctorDocumentBuilder builder) {
        StringBuilder sb = new StringBuilder();
        for (Scenario scenario : feature.getScenarios()) {
            sb.append(this.renderFeatureScenario(scenario, feature, builder));
        }
        feature.setBackgroundRendered(false);
        return sb.toString();
    }

    protected String renderFeatureSectionId(Feature feature) {
        if (Assert.isNull(feature) || Assert.not(Assert.hasText(feature.getName()))) {
            return "";
        }
        return "[[" + feature.getName().replaceAll(",", "").replaceAll(" ", "-") + ", " + feature.getName() + "]]";
    }

    protected String renderFeatureScenario(Scenario scenario, Feature feature, CukedoctorDocumentBuilder builder) {
        if (this.scenarioRenderer == null) {
            this.loadDependentRenderers();
        }
        return this.scenarioRenderer.renderScenario(scenario, feature, builder.createNestedBuilder());
    }

    private void loadDependentRenderers() {
        this.scenarioRenderer = new ServiceLoaderUtil<CukedoctorScenarioRenderer>().initialise(ScenarioRenderer.class, CukedoctorScenarioRenderer.class, this.i18n, this.documentAttributes, this.cukedoctorConfig, new Class[0]);
    }
}

