/*
 * Decompiled with CFR 0.152.
 */
package com.github.cukedoctor.renderer;

import com.github.cukedoctor.api.model.Feature;
import com.github.cukedoctor.api.model.Scenario;
import com.github.cukedoctor.api.model.Tag;
import com.github.cukedoctor.renderer.AbstractBaseRenderer;
import com.github.cukedoctor.spi.TagsRenderer;
import java.util.HashSet;
import java.util.List;

public class CukedoctorTagsRenderer
extends AbstractBaseRenderer
implements TagsRenderer {
    @Override
    public String renderScenarioTags(Feature feature, Scenario scenario) {
        this.docBuilder.clear();
        int expectedSize = (feature.hasTags() ? feature.getTags().size() : 0) + (scenario.hasTags() ? scenario.getTags().size() : 0);
        if (expectedSize == 0) {
            return "";
        }
        HashSet<String> tagNames = new HashSet<String>(expectedSize);
        this.extractTagNames(tagNames, feature.getTags());
        this.extractTagNames(tagNames, scenario.getTags());
        if (tagNames.size() == 0) {
            return "";
        }
        this.docBuilder.clear();
        StringBuilder tags = new StringBuilder("[small]#tags: ");
        for (String tagName : tagNames) {
            tags.append(tagName).append(",");
        }
        if (tags.indexOf(",") != -1) {
            tags.deleteCharAt(tags.lastIndexOf(","));
        }
        tags.append("#");
        this.docBuilder.textLine(tags.toString());
        this.docBuilder.newLine();
        return this.docBuilder.toString();
    }

    private void extractTagNames(HashSet<String> tagNames, List<Tag> tags) {
        if (tags == null) {
            return;
        }
        for (Tag tag : tags) {
            if (this.isCukedoctorTag(tag)) continue;
            tagNames.add(tag.getName());
        }
    }

    protected boolean isCukedoctorTag(Tag tag) {
        return tag.isOrder() || tag.isDiscrete();
    }
}

