/*
 * Decompiled with CFR 0.152.
 */
package com.github.cukedoctor.util;

import com.github.cukedoctor.util.Assert;
import com.github.cukedoctor.util.Constants;

public class StringUtil {
    private StringUtil() {
    }

    public static String trimAllLines(String text) {
        if (!Assert.hasText(text)) {
            return text;
        }
        StringBuilder trimmedDescription = new StringBuilder();
        String[] lines = StringUtil.normaliseLineEndings(text).split(Constants.newLine());
        boolean shouldTrim = true;
        boolean foundFirstNotEmptyLine = false;
        int leadingWhitespaceCharsToTrim = 0;
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            if (!foundFirstNotEmptyLine && line != null && !line.isEmpty()) {
                leadingWhitespaceCharsToTrim = StringUtil.countLeadingWhitespace(line);
                foundFirstNotEmptyLine = true;
            }
            if ((line = StringUtil.trimStart(line, leadingWhitespaceCharsToTrim)).trim().startsWith(Constants.Markup.listing())) {
                shouldTrim = !shouldTrim;
            }
            if (shouldTrim) {
                trimmedDescription.append(StringUtil.trimEnd(line));
            } else {
                trimmedDescription.append(line);
            }
            if (i >= lines.length - 1) continue;
            trimmedDescription.append(Constants.newLine());
        }
        return trimmedDescription.toString();
    }

    static int countLeadingWhitespace(String text) {
        int i;
        char c;
        if (text == null) {
            return 0;
        }
        for (i = 0; i < text.length() && ((c = text.charAt(i)) == ' ' || c == '\t'); i += Character.charCount(c)) {
        }
        return i;
    }

    static String trimStart(String text, int count) {
        int i;
        char c;
        if (count < 1) {
            return text;
        }
        if (text == null) {
            return null;
        }
        for (i = 0; i < text.length() && i < count && ((c = text.charAt(i)) == ' ' || c == '\t'); i += Character.charCount(c)) {
        }
        return text.substring(i);
    }

    static String trimEnd(String text) {
        if (text == null) {
            return null;
        }
        return text.replaceFirst("\\s++$", "");
    }

    public static String normaliseLineEndings(String s) {
        if (s == null) {
            return null;
        }
        return s.replaceAll("\\r\\n|\\r|\\n", System.lineSeparator());
    }
}

